#! /usr/bin/perl -w
#
# Produces a pciutils style pci.ids file from BSD pcidevs input
#
# Copyright (c) 2008 Matthieu Herrb <matthieu@herrb.eu>
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

while (<>) {
	chop;
	if (/^\$OpenBSD:/) {
		$rcsid = $_;
	}
	if (/^vendor/) {
		($dummy,$label,$id,$name) = split(/\s+/, $_, 4);
		$id = oct($id);
		$vendor_id{$label} = $id;
		$vendor_name{$id} = $name;
	}
	if (/^product/) {
		($dummy,$vlabel,$dummy,$id,$name) = split(/\s+/, $_, 5);
		$id = oct($id);
		$v =  $vendor_id{$vlabel};
		$name{$v,$id} = $name;
		push @{$product{$v}},$id;
	}
}

print "# THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.\n";
print "#\n";
print "# generated from:\n";
print "#\t $rcsid\n";
print "\n";

sub numerically {
	$a <=> $b
}

foreach $v (sort numerically keys %vendor_name) {
	printf("%04x  $vendor_name{$v}\n", $v);
	next if (!defined($product{$v}));
	foreach $p (sort numerically @{$product{$v}}) {
		printf("\t%04x  $name{$v,$p}\n", $p);
	}

}
