.\"	$OpenBSD: ws.man,v 1.12 2011/11/28 23:49:59 shadchin Exp $
.\"
.\" Copyright (c) 2005,2009,2011 Matthieu Herrb
.\"
.\" Permission to use, copy, modify, and distribute this software for any
.\" purpose with or without fee is hereby granted, provided that the above
.\" copyright notice and this permission notice appear in all copies.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
.\" WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
.\" MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
.\" ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
.\" WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
.\" ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
.\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH WS __drivermansuffix__ __vendorversion__
.SH NAME
WS \- wscons pointer input driver for __xservername__ on *BSD
.SH SYNOPSIS
.nf
.B "Section \*qInputDevice\*q"
.BI "    Identifier \*q" name \*q
.B  "    Driver \*qws\*q"
.BI "    Option \*qButtons\*q \*q" integer \*q
.BI "    Option \*qEmulate3Buttons\*q \*q" boolean \*q
.BI "    Option \*qEmulate3Timeout\*q \*q" integer \*q
.BI "    Option \*qDebugLevel\*q \*q" integer \*q
.BI "    Option \*qDevice\*q \*q" path \*q
.BI "    Option \*qMinX\*q \*q" integer \*q
.BI "    Option \*qMaxX\*q \*q" integer \*q
.BI "    Option \*qMinY\*q \*q" integer \*q
.BI "    Option \*qMaxY\*q \*q" integer \*q
.BI "    Option \*qRaw\*q \*q" boolean \*q
.BI "    Option \*qRotate\*q \*q" string \*q
.BI "    Option \*qSwapXY\*q \*q" boolean \*q
.BI "    Option \*qZAxisMapping\*q \*q" "N1 N2" \*q
.BI "    Option \*qWAxisMapping\*q \*q" "N1 N2" \*q
.B EndSection
.fi
.SH DESCRIPTION
.B ws
is an XFree86/X.Org input driver for pointer devices (mouse, tablet,
touchscreen,...) driven by the wscons console driver on
OpenBSD.
.SH "SUPPORTED HARDWARE"
This driver supports zts(4), the touchscreen of Zaurus machines,
uts(4), USB touchscreens and ums(4), generic USB mouse devices.
.SH "CONFIGURATION DETAILS"
Please refer to __xconfigfile__(__filemansuffix__) for general configuration
details and for options that can be used with all input drivers.
This section only covers configuration details specific to this driver.
.TP 4
.BI "Option \*qButtons\*q \*q" integer \*q
Specifies the number of mouse buttons.
In cases where the number of buttons cannot be auto-detected, the
default value is 3.
.TP 4
.BI "Option \*qEmulate3Buttons\*q \*q" boolean \*q
Enable/disable the emulation of the middle mouse button for mice which
only have two physical buttons. The third button is emulated by pressing
both buttons simultaneously. Default: on, until a middle button event
is detected.
.TP 4
.BI "Option \*qEmulate3Timeout\*q \*q" integer \*q
Sets the timeout (in milliseconds) that the driver waits before deciding
if two buttons where pressed "simultaneously" when 3 button emulation is
enabled. Default: 50.
.TP 4
.BI "Option \*qEmulateWheel\*q \*q" boolean \*q
Enable/disable "wheel" emulation.
Wheel emulation means emulating button press/release events when the mouse
is moved while a specific real button is pressed.
Wheel button events (typically buttons 4 and 5) are usually used for scrolling.
Wheel emulation is useful for getting wheel-like behaviour with trackballs.
It can also be useful for mice with 4 or more buttons but no wheel.
See the description of the
.BR EmulateWheelButton ,
.BR EmulateWheelInertia ,
.BR EmulateWheelTimeout ,
.BR XAxisMapping ,
and
.B YAxisMapping
options.
Default: off.
.TP 4
.BI "Option \*qEmulateWheelButton\*q \*q" integer \*q
Specifies which button must be held down to enable wheel emulation mode.
While this button is down, X and/or Y pointer movement will generate button
press/release events as specified for the
.B XAxisMapping
and
.B YAxisMapping
settings.
If the button is 0 and
.BR EmulateWheel
is on, any motion of the device is converted into wheel events.
Default:\ 4.
.TP 4
.BI "Option \*qEmulateWheelInertia\*q \*q" integer \*q
Specifies how far (in pixels) the pointer must move to generate button
press/release events in wheel emulation mode.
Default:\ 10.
.TP 4
.BI "Option \*qEmulateWheelTimeout\*q \*q" integer \*q
Specifies the time in milliseconds the
.BR EmulateWheelButton
must be pressed before wheel emulation is started.
If the
.BR EmulateWheelButton
is released before this timeout, the original button press/release event
is sent.
Default:\ 200.
.TP 4
.BI "Option \*qDebugLevel\*q \*q" integer \*q
This option sets the verbosity level of the driver.
It defaults to 0, which means no extra debug output.
.TP 4
.BI "Option \*qDevice\*q \*q" path \*q
sets the path to the special file used by the device, ususally
.I /dev/wsmouse .
This option is mandatory.
.TP 4
.BI "Option \*qMinX\*q \*q" integer \*q
.TP 4
.BI "Option \*qMaxX\*q \*q" integer \*q
.TP 4
.BI "Option \*qMinY\*q \*q" integer \*q
.TP 4
.BI "Option \*qMaxY\*q \*q" integer \*q
These options represent the coordinate space returned by the device.
They default to the screen dimensions, since the calibration is handled in
the kernel by the zts(4) driver and the ztsscale(8) utility.
.TP 4
.BI "Option \*qRaw\*q \*q" boolean \*q
This option selects the raw (uncalibrated) mode for tablet devices.
It defaults to True.
When using raw mode, if no coordinate space is specified by the
above options, the coordinate space will be read from the kernel calibration
data.
.TP 4
.B "Option \*qRotate\*q \*qCW\*q"
.TP 4
.B "Option \*qRotate\*q \*qCCW\*q"
.TP 4
.B "Option \*qRotate\*q \*qUD\*q"
These options rotate the screen coordinates returned by the driver
clockwise, counter-clockwise, or upside-down respectively.
.TP 4
.BI "Option \*qSwapXY\*q \*q" boolean \*q
swaps the X and Y axis of the input device if set. Default: false.
.TP 4
.BI "Option \*qXAxisMapping\*q \*q" "N1 N2" \*q
Specifies which buttons are mapped to motion in the X direction in wheel
emulation mode.
Button number
.I N1
is mapped to the negative X axis motion and button number
.I N2
is mapped to the positive X axis motion.
Default: no mapping.
.TP 4
.BI "Option \*qYAxisMapping\*q \*q" "N1 N2" \*q
Specifies which buttons are mapped to motion in the Y direction in wheel
emulation mode.
Button number
.I N1
is mapped to the negative Y axis motion and button number
.I N2
is mapped to the positive Y axis motion.
Default:\ "4\ 5".
.TP 4
.BI "Option \*qZAxisMapping\*q \*q" "N1 N2" \*q
Set the mapping for the Z axis (wheel) motion to buttons. Button
number
.I N1
is mapped to the negative Z axis motion and button
.I N2
is mapped to the positive Z axis motion.
Default:\ "4\ 5".
.TP 4
.BI "Option \*qWAxisMapping\*q \*q" "N1 N2" \*q
Set the mapping for the W axis (horizontal wheel) motion to buttons. Button
number
.I N1
is mapped to the negative W axis motion and button
.I N2
is mapped to the positive W axis motion.
Default:\ "6\ 7".
.SH "SUPPORTED PROPERTIES"
The following properties are provided by the
.B ws
driver.
.TP 7
.BI "WS Pointer Middle Button Emulation"
1 boolean value (8 bit, 0 or 1)
.TP 7
.BI "WS Pointer Middle Button Timeout"
1 32-bit positive value (unit: milliseconds)
.TP 7
.BI "WS Pointer Wheel Emulation"
1 boolean value (8 bit, 0 or 1).
.TP 7
.BI "WS Pointer Wheel Emulation Axes"
4 8-bit values, order X up, X down, Y up, Y down. 0 disables a value.
.TP 7
.BI "WS Pointer Wheel Emulation Button"
1 8-bit value, allowed range 0-32, 0 to always scroll.
.TP 7
.BI "WS Pointer Wheel Emulation Inertia"
1 16-bit positive value.
.TP 7
.BI "WS Pointer Wheel Emulation Timeout"
1 32-bit positive value (unit: milliseconds).
.TP 7
.BI "WS Pointer Axis Calibration"
4 32 bits values, in the order min-x, max-x, min-y, max-y.
This property is present only for devices with absolute coordinates (ie
tablets and touchscreens).
.TP 7
.BI "WS Pointer Axes Swap"
1 boolean value (8 bits, 0 or 1). 1 swaps x/y axes. This property
is present only for devices with absolute coordinates (ie
tablets and touchscreens).

.SH "SEE ALSO"
__xservername__(1), xinput(1), __xconfigfile__(__filemansuffix__),
ums(4), uts(4), zts(4), sysctl(8), xtsscale(8), ztsscale(8).
