# Code Generated by ZenTest v. 3.2.0
#                 classname: asrt / meth =  ratio%

$:.unshift '..'

require 'test/unit' unless defined? $ZENTEST and $ZENTEST
require 'RRDtool'

class TestRRDtool < Test::Unit::TestCase
  def setup
    @f = 'test.rrd'
    @g = (File.basename @f, '.rrd') + '.png'
    File.delete @f if File.exists? @f
    File.delete @g if File.exists? @g
    @r = RRDtool.new @f
  end
  
  def teardown
    File.delete @f if File.exists? @f
    # note: leave the graph file around to check it by hand
    @r = nil
  end
  
  def create_file
    @start = Time.now.to_i - 1
    @step = 300
    @r.create @step, @start, [ "DS:a:GAUGE:#{2*@step}:0:1", 
      "DS:b:GAUGE:#{2*@step}:-10:10",
      "RRA:AVERAGE:0.5:1:300", 
      "RRA:LAST:0.5:1:10" ]
  end
  
  def create_data
    scale = 10
    ts = Time.now.to_i + 1
    while (ts < (@start.to_i + @step*300)) do
      @r.update "a:b", ["#{ts}:#{rand()}:#{Math.sin(ts / @step / 10)}"]
      ts += @step
    end
  end
  
  def test_create
    create_file
    assert File.readable?(@f)    
  end

  def test_dump
    # RRDtool.dump is not defined for older versions of RRDtool
    dump_file = "#{@f}.out"
    create_file
    create_data
    if RRDtool.version < 1.2015 then
      assert_raise NoMethodError do
        @r.dump dump_file
      end
    else
      @r.dump dump_file
      assert File.readable? dump_file
    end
    # cleanup
    File.delete dump_file if File.exists? dump_file
  end

  def test_fetch
    assert_raise RRDtoolError do
      @r.fetch ["AVERAGE"]
    end
    create_file
    create_data
    fary = @r.fetch ["AVERAGE"]
    assert_not_nil fary
    assert !fary.empty?
    #assert_equals expected_data_points, fary[3]
    # LATER: test rrd.fetch ["AVERAGE", "LAST"]
  end

  def test_first
    # first and last should raise an exception without an RRD file
    assert_raise RRDtoolError do
      @r.first 0
    end
    create_file
    (0..1).each do |i|
      f = @r.first i
      assert_not_nil f
      assert f > 0
    end
    assert_raise RRDtoolError do
      f2 = @r.first 2
    end
  end

  def test_graph
    create_file
    create_data
    RRDtool.graph(
        [@g, "--title", " RubyRRD Demo", 
        "--start", "#{@start} + 1 h",
        "--end", "#{@start} + 1000 min",
        "--interlace", 
        "--imgformat", "PNG",
        "--width=450",
        "DEF:a=#{@f}:a:AVERAGE",
        "DEF:b=#{@f}:b:AVERAGE",
        "CDEF:line=TIME,2400,%,300,LT,a,UNKN,IF",
        "AREA:b#00b6e4:beta",
        "AREA:line#0022e9:alpha",
        "LINE3:line#ff0000"])
    assert File.exists?(@g)
  end

  def test_info
    create_file
    info = @r.info
    assert_not_nil info
    assert_equal info['filename'], @f
    assert_equal info['step'], @step
  end

  def test_last
    # first and last should raise an exception without an RRD file
    assert_raise RRDtoolError do
      @r.last
    end
    create_file
    l = @r.last
    assert l > 0
    assert_equal @start, l
    create_data
    l = @r.last
    assert l > @start
  end

  def test_resize
    raise NotImplementedError, 'Need to write test_resize'
  end

  def test_restore
    raise NotImplementedError, 'Need to write test_restore'
  end

  def test_rrdname
    r = RRDtool.new 'foo'
    assert_equal r.rrdname, 'foo'
  end

  def test_tune
    raise NotImplementedError, 'Need to write test_tune'
  end

  def test_update
    create_file
    # first, test the simple update case (now)
    @r.update "a:b", ["N:0:0"]
    assert_in_delta Time.now.to_i, @r.last, 1
    # next, create a bunch of data entries
    create_data
    l = @r.last
    @r.update "a:b", ["#{l+1}:0:0", "#{l+2}:1:1"]
    assert_equal @r.last, l+2
  end

  def test_version
    v = RRDtool.version
    assert_instance_of Float, v
    assert_not_nil v
  end

  def test_xport
    raise NotImplementedError, 'Need to write test_xport'
  end
end
