# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = "haml"
  s.version = "2.2.2"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["Nathan Weizenbaum", "Hampton Catlin"]
  s.date = "2009-07-20"
  s.description = "Haml (HTML Abstraction Markup Language) is a layer on top of XHTML or XML that's designed to express the structure of XHTML or XML documents in a non-repetitive, elegant, easy way, using indentation rather than closing tags and allowing Ruby to be embedded with ease. It was originally envisioned as a plugin for Ruby on Rails, but it can function as a stand-alone templating engine."
  s.email = "haml@googlegroups.com"
  s.executables = ["haml", "html2haml", "sass", "css2sass"]
  s.extra_rdoc_files = ["VERSION_NAME", "README.md", "MIT-LICENSE", "VERSION", "REVISION"]
  s.files = ["bin/haml", "bin/html2haml", "bin/sass", "bin/css2sass", "VERSION_NAME", "README.md", "MIT-LICENSE", "VERSION", "REVISION"]
  s.homepage = "http://haml.hamptoncatlin.com/"
  s.rdoc_options = ["--title", "Haml", "--main", "README.rdoc", "--exclude", "lib/haml/buffer.rb", "--line-numbers", "--inline-source"]
  s.require_paths = ["lib"]
  s.rubyforge_project = "haml"
  s.rubygems_version = "1.8.10"
  s.summary = "An elegant, structured XHTML/XML templating engine. Comes with Sass, a similar CSS templating engine."

  if s.respond_to? :specification_version then
    s.specification_version = 2

    if Gem::Version.new(Gem::VERSION) >= Gem::Version.new('1.2.0') then
      s.add_development_dependency(%q<yard>, [">= 0.2.3"])
      s.add_development_dependency(%q<maruku>, [">= 0.5.9"])
    else
      s.add_dependency(%q<yard>, [">= 0.2.3"])
      s.add_dependency(%q<maruku>, [">= 0.5.9"])
    end
  else
    s.add_dependency(%q<yard>, [">= 0.2.3"])
    s.add_dependency(%q<maruku>, [">= 0.5.9"])
  end
end
