/*

Copyright (C) 2000 - 2006 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __libnd_protocol_instance_h
#define __libnd_protocol_instance_h

#include <libnd_protocol.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

struct lnd_proto_inst
{
  LND_Protocol  *proto;
  guint          nesting;
};

struct lnd_proto_data
{
  LND_ProtoInst  inst;

  guchar        *data;
  guchar        *data_end;
};

struct lnd_proto_info
{
  LND_ProtoInst  inst;
  LND_Registry  *registry;
};


void              libnd_proto_inst_init(LND_ProtoInst *inst, LND_Protocol *protocol, guint nesting);
const char       *libnd_proto_inst_to_string(const LND_Protocol *proto, guint nesting);

LND_ProtoData    *libnd_proto_data_new(LND_Protocol *protocol, guint nesting, guchar *data, guchar *data_end);
void              libnd_proto_data_free(LND_ProtoData *pd);

LND_ProtoInfo    *libnd_proto_info_new(LND_Protocol *proto, guint nesting);
void              libnd_proto_info_free(LND_ProtoInfo *pinf);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
