/* ethos-plugin-loader.h
 *
 * Copyright (C) 2009 Christian Hergert <chris@dronelabs.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 
 * 02110-1301 USA
 */

#ifndef __ETHOS_PLUGIN_LOADER_H__
#define __ETHOS_PLUGIN_LOADER_H__

#include <glib-object.h>

#include "ethos-manager.h"
#include "ethos-plugin-info.h"
#include "ethos-plugin.h"

G_BEGIN_DECLS

#define ETHOS_TYPE_PLUGIN_LOADER		(ethos_plugin_loader_get_type())
#define ETHOS_PLUGIN_LOADER(obj)		(G_TYPE_CHECK_INSTANCE_CAST((obj),    ETHOS_TYPE_PLUGIN_LOADER, EthosPluginLoader))
#define ETHOS_IS_PLUGIN_LOADER(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj),    ETHOS_TYPE_PLUGIN_LOADER))
#define ETHOS_PLUGIN_LOADER_GET_INTERFACE(obj)	(G_TYPE_INSTANCE_GET_INTERFACE((obj), ETHOS_TYPE_PLUGIN_LOADER, EthosPluginLoaderIface))

typedef struct _EthosPluginLoader      EthosPluginLoader;
typedef struct _EthosPluginLoaderIface EthosPluginLoaderIface;

struct _EthosPluginLoaderIface
{
	GObjectClass parent_class;

	const gchar* (*get_name)        (EthosPluginLoader  *plugin_loader);
	void         (*initialize)      (EthosPluginLoader  *plugin_loader,
	                                 EthosManager       *manager);
	void         (*unload)          (EthosPluginLoader  *plugin_loader);
	EthosPlugin* (*load)            (EthosPluginLoader  *plugin_loader,
	                                 EthosPluginInfo    *plugin_info,
	                                 GError            **error);
	void         (*gc)              (EthosPluginLoader  *plugin_loader);
	void         (*register_plugin) (EthosPluginLoader *plugin_loader,
	                                 EthosPlugin       *plugin);

	void         (*reserved1)  (void);
	void         (*reserved2)  (void);
	void         (*reserved3)  (void);
	void         (*reserved4)  (void);
};

GType                 ethos_plugin_loader_get_type        (void) G_GNUC_CONST;
G_CONST_RETURN gchar* ethos_plugin_loader_get_name        (EthosPluginLoader  *plugin_loader);
void                  ethos_plugin_loader_initialize      (EthosPluginLoader  *plugin_loader,
                                                           EthosManager       *manager);
void                  ethos_plugin_loader_unload          (EthosPluginLoader  *plugin_loader);
EthosPlugin*          ethos_plugin_loader_load            (EthosPluginLoader  *plugin_loader,
                                                           EthosPluginInfo    *plugin_info,
                                                           GError            **error);
void                  ethos_plugin_loader_gc              (EthosPluginLoader  *plugin_loader);
void                  ethos_plugin_loader_register_plugin (EthosPluginLoader *plugin_loader,
                                                           EthosPlugin       *plugin);

G_END_DECLS

#endif /* __ETHOS_PLUGIN_LOADER_H__ */
