/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.gimmicks;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;

public class ImageCanvas
extends Canvas {
    protected Image image;
    private Image scaledImage;
    private boolean doScale = false;
    private int scaleMethod = 1;

    public ImageCanvas(Image img) {
        this.setImage(img);
    }

    public ImageCanvas(Image img, boolean scaling) {
        this(img);
        this.setScaling(scaling);
    }

    public ImageCanvas(Image img, boolean scaling, int method) {
        this(img, scaling);
        this.setScalingMethod(method);
    }

    public void paint(Graphics g) {
        if (this.image != null) {
            Dimension size = this.getSize();
            int width = this.image.getWidth(this);
            int height = this.image.getHeight(this);
            if (width == size.width && height == size.height) {
                g.drawImage(this.image, 0, 0, size.width, size.height, this);
            } else if (this.doScale) {
                g.drawImage(this.scaledImage, 0, 0, size.width, size.height, this);
            } else {
                g.drawImage(this.image, (size.width - width) / 2, (size.height - height) / 2, width, height, this);
            }
        }
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.makeScaledImage(width, height);
    }

    public void setSize(Dimension size) {
        super.setSize(size);
        this.makeScaledImage(size.width, size.height);
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.makeScaledImage(w, h);
    }

    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.makeScaledImage(r.width, r.height);
    }

    private void makeScaledImage(int width, int height) {
        if (this.doScale && (this.scaledImage == null || this.scaledImage.getWidth(this) != width || this.scaledImage.getHeight(this) != height)) {
            this.scaledImage = this.image.getScaledInstance(width, height, this.scaleMethod);
            this.prepareImage(this.scaledImage, null);
        }
    }

    public Dimension getPreferredSize() {
        if (this.image != null) {
            int width = this.image.getWidth(this);
            int height = this.image.getHeight(this);
            return new Dimension(width <= 0 ? 1 : width, height <= 0 ? 1 : height);
        }
        return new Dimension(1, 1);
    }

    public Dimension getMinimalSize() {
        return this.getPreferredSize();
    }

    public void setImage(Image img) {
        this.image = img;
        if (img != null) {
            try {
                MediaTracker mt = new MediaTracker(this);
                mt.addImage(this.image, 0);
                mt.waitForID(0);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.invalidate();
        this.repaint();
    }

    public void setScaling(boolean scaling) {
        this.doScale = scaling;
    }

    public boolean getScaling() {
        return this.doScale;
    }

    public void setScalingMethod(int method) {
        switch (method) {
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                this.scaleMethod = method;
                break;
            }
            default: {
                this.scaleMethod = 1;
            }
        }
    }
}

