/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.container.XNameAccess;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdb.XCompletedExecution;
import com.sun.star.sdb.XResultSetAccess;
import com.sun.star.sdbc.XResultSet;
import com.sun.star.sdbc.XRow;
import com.sun.star.sdbcx.XColumnsSupplier;
import com.sun.star.task.XInteractionHandler;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.InvalidQueryException;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NumberFormatter;
import com.sun.star.wizards.db.FieldColumn;
import com.sun.star.wizards.db.QueryMetaData;
import java.util.Vector;

public class RecordParser
extends QueryMetaData {
    XNameAccess xColumns;
    XRow xRow;
    XRow xResultSetRow;
    public XResultSet ResultSet;
    XInterface xRowSet;
    XCompletedExecution xExecute;
    XColumnsSupplier xRowSetColumnsSupplier;
    XComponent xRowSetComponent;
    XInteractionHandler xInteraction;
    public FieldColumn[] GroupFieldColumns;
    public FieldColumn[] RecordFieldColumns;

    public RecordParser(XMultiServiceFactory xMultiServiceFactory, Locale locale, NumberFormatter numberFormatter) {
        super(xMultiServiceFactory, locale, numberFormatter);
        this.getInterfaces();
    }

    public RecordParser(XMultiServiceFactory xMultiServiceFactory) {
        super(xMultiServiceFactory);
        this.getInterfaces();
    }

    private void getInterfaces() {
        try {
            this.xRowSet = (XInterface)this.xMSF.createInstance("com.sun.star.sdb.RowSet");
            this.xRowSetColumnsSupplier = (XColumnsSupplier)UnoRuntime.queryInterface(XColumnsSupplier.class, (Object)this.xRowSet);
            this.xRowSetComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.xRowSet);
            this.xExecute = (XCompletedExecution)UnoRuntime.queryInterface(XCompletedExecution.class, (Object)this.xRowSet);
            XInterface xInterface = (XInterface)this.xMSF.createInstance("com.sun.star.task.InteractionHandler");
            this.xInteraction = (XInteractionHandler)UnoRuntime.queryInterface(XInteractionHandler.class, (Object)xInterface);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private Object getColumnStringValue(int n) {
        try {
            String string = this.xResultSetRow.getString(n);
            Type type = new Type(String.class);
            Object object = AnyConverter.toObject((Type)type, (Object)string);
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return null;
        }
    }

    private Object getColumnDoubleValue(int n, boolean bl) {
        try {
            Double d = bl ? new Double(this.xResultSetRow.getDouble(n) + (double)super.getNullDateCorrection()) : new Double(this.xResultSetRow.getDouble(n));
            if (!this.xResultSetRow.wasNull()) {
                return d;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return Any.VOID;
    }

    public Object getColumnValue(int n, int n2) {
        Object object = Any.VOID;
        switch (n2) {
            case -7: 
            case 16: {
                object = this.getColumnDoubleValue(n, false);
                break;
            }
            case -6: {
                object = this.getColumnDoubleValue(n, false);
                break;
            }
            case -5: {
                object = this.getColumnDoubleValue(n, false);
                break;
            }
            case 1: {
                object = this.getColumnStringValue(n);
                break;
            }
            case 12: {
                object = this.getColumnStringValue(n);
                break;
            }
            case -1: {
                object = this.getColumnStringValue(n);
                break;
            }
            case 2: {
                object = this.getColumnDoubleValue(n, false);
                break;
            }
            case 4: {
                object = this.getColumnDoubleValue(n, false);
                break;
            }
            case 5: {
                object = this.getColumnDoubleValue(n, false);
                break;
            }
            case 3: {
                object = this.getColumnDoubleValue(n, false);
                break;
            }
            case 6: {
                object = this.getColumnDoubleValue(n, false);
                break;
            }
            case 7: {
                object = this.getColumnDoubleValue(n, false);
                break;
            }
            case 8: {
                object = this.getColumnDoubleValue(n, false);
                break;
            }
            case 91: {
                object = this.getColumnDoubleValue(n, true);
                break;
            }
            case 92: {
                object = this.getColumnDoubleValue(n, false);
                break;
            }
            case 93: {
                object = this.getColumnDoubleValue(n, true);
            }
        }
        return object;
    }

    public boolean executeCommand(int n) throws InvalidQueryException {
        try {
            Helper.setUnoPropertyValue(this.xRowSet, "DataSourceName", this.DataSourceName);
            Helper.setUnoPropertyValue(this.xRowSet, "ActiveConnection", this.DBConnection);
            Helper.setUnoPropertyValue(this.xRowSet, "Command", this.Command);
            Helper.setUnoPropertyValue(this.xRowSet, "CommandType", new Integer(n));
            this.xExecute.executeWithCompletion(this.xInteraction);
            XResultSetAccess xResultSetAccess = (XResultSetAccess)UnoRuntime.queryInterface(XResultSetAccess.class, (Object)this.xRowSet);
            this.ResultSet = xResultSetAccess.createResultSet();
            this.xResultSetRow = (XRow)UnoRuntime.queryInterface(XRow.class, (Object)this.ResultSet);
            XColumnsSupplier xColumnsSupplier = (XColumnsSupplier)UnoRuntime.queryInterface(XColumnsSupplier.class, (Object)this.ResultSet);
            this.xColumns = xColumnsSupplier.getColumns();
            this.setCommandType(n);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            throw new InvalidQueryException(this.xMSF, this.Command);
        }
    }

    public boolean getFields(String[] stringArray, boolean bl) {
        try {
            if (bl) {
                this.initializeFieldColumns(stringArray, this.xColumns);
            }
            String[] stringArray2 = this.xColumns.getElementNames();
            String[] stringArray3 = this.getFieldNames();
            for (int i = 0; i < this.FieldColumns.length; ++i) {
                int n;
                String string = this.FieldColumns[i].getFieldName();
                this.FieldColumns[i].ColIndex = n = JavaTools.FieldInList(stringArray2, string) + 1;
                if (n != -1) continue;
                throw new InvalidQueryException(this.xMSF, this.Command);
            }
            this.GroupFieldColumns = this.getFieldColumnList(this.GroupFieldNames);
            this.RecordFieldColumns = this.getFieldColumnList(this.getRecordFieldNames());
            return true;
        }
        catch (InvalidQueryException invalidQueryException) {
            invalidQueryException.printStackTrace(System.out);
            return false;
        }
    }

    private FieldColumn[] getFieldColumnList(String[] stringArray) {
        FieldColumn[] fieldColumnArray = new FieldColumn[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            fieldColumnArray[i] = super.getFieldColumnByFieldName(stringArray[i]);
        }
        return fieldColumnArray;
    }

    public Object getGroupColumnValue(int n) {
        FieldColumn fieldColumn = this.GroupFieldColumns[n];
        return this.getColumnValue(fieldColumn.ColIndex, fieldColumn.getFieldType());
    }

    public boolean getcurrentRecordData(Vector vector) {
        Object[] objectArray = new Object[this.RecordFieldColumns.length];
        for (int i = 0; i < this.RecordFieldColumns.length; ++i) {
            FieldColumn fieldColumn = this.RecordFieldColumns[i];
            objectArray[i] = this.getColumnValue(fieldColumn.ColIndex, fieldColumn.getFieldType());
        }
        vector.addElement(objectArray);
        return true;
    }

    public void dispose() {
        if (this.xRowSetComponent != null) {
            this.xRowSetComponent.dispose();
        }
        super.dispose();
    }
}

