/* Encoding of types for Objective C.
   Copyright (C) 1993 Free Software Foundation, Inc.

Author: Kresten Krab Thorup

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* As a special exception, if you link this library with files
   compiled with GCC to produce an executable, this does not cause
   the resulting executable to be covered by the GNU General Public License.
   This exception does not however invalidate any other reasons why
   the executable file might be covered by the GNU General Public License.  */

#ifndef __array_encoding_INCLUDE_GNU
#define __array_encoding_INCLUDE_GNU

int math_sizeof_type (const char* type);
int math_alignof_type (const char* type);
int math_aligned_size (const char* type);
int math_promoted_size (const char* type);
const char* math_skip_typespec (const char* type);

#ifdef HAVE_OBJC_ENCODING_H 
#include <objc/encoding.h>
#else
#define objc_sizeof_type math_sizeof_type
#define objc_alignof_type math_alignof_type
#define objc_aligned_size math_aligned_size
#define objc_promoted_size math_promoted_size
#define objc_skip_typespec math_skip_typespec
#endif

#ifndef GNU_FOUNDATION
#include <objc/objc.h>
/* cannot include objc-class because it has ObjC definitions in it */
#define _C_ID		'@'
#define _C_CLASS	'#'
#define _C_SEL		':'
#define _C_CHR		'c'
#define _C_UCHR		'C'
#define _C_SHT		's'
#define _C_USHT		'S'
#define _C_INT		'i'
#define _C_UINT		'I'
#define _C_LNG		'l'
#define _C_ULNG		'L'
#define _C_FLT		'f'
#define _C_DBL		'd'
#define _C_BFLD		'b'
#define _C_VOID		'v'
#define _C_UNDEF	'?'
#define _C_PTR		'^'
#define _C_CHARPTR	'*'
#define _C_ARY_B	'['
#define _C_ARY_E	']'
#define _C_UNION_B	'('
#define _C_UNION_E	')'
#define _C_STRUCT_B	'{'
#define _C_STRUCT_E	'}'
#define _C_ATOM		'%'
#else
#  include <objc/objc-api.h>
#endif

#endif /* __array_encoding_INCLUDE_GNU */
