/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class ConfigurableOption {
    private String componentName;
    private String optionName;
    private int id;
    private String category;
    private String name;
    private String description;
    private int currentValueIndex;
    private String[] possibleValues;
    public static final String[] NoDiscreteValue = new String[0];

    public ConfigurableOption(String componentName, String optionName, Locale loc, int currentValueIndex) {
        this.componentName = componentName;
        this.optionName = optionName;
        this.currentValueIndex = currentValueIndex;
        ResourceBundle resource = null;
        try {
            String location = componentName.substring(0, componentName.lastIndexOf(46));
            resource = ResourceBundle.getBundle(String.valueOf(location) + ".options", loc);
        }
        catch (MissingResourceException missingResourceException) {
            this.category = "Missing ressources entries for" + componentName + " options";
            this.name = "Missing ressources entries for" + componentName + " options";
            this.description = "Missing ressources entries for" + componentName + " options";
            this.possibleValues = new String[0];
            this.id = -1;
        }
        if (resource == null) {
            return;
        }
        try {
            this.id = Integer.parseInt(resource.getString(String.valueOf(optionName) + ".number"));
        }
        catch (MissingResourceException missingResourceException) {
            this.id = -1;
        }
        catch (NumberFormatException numberFormatException) {
            this.id = -1;
        }
        try {
            this.category = resource.getString(String.valueOf(optionName) + ".category");
        }
        catch (MissingResourceException missingResourceException) {
            this.category = "Missing ressources entries for" + componentName + " options";
        }
        try {
            this.name = resource.getString(String.valueOf(optionName) + ".name");
        }
        catch (MissingResourceException missingResourceException) {
            this.name = "Missing ressources entries for" + componentName + " options";
        }
        try {
            StringTokenizer tokenizer = new StringTokenizer(resource.getString(String.valueOf(optionName) + ".possibleValues"), "|");
            int numberOfValues = Integer.parseInt(tokenizer.nextToken());
            if (numberOfValues == -1) {
                this.possibleValues = NoDiscreteValue;
            } else {
                this.possibleValues = new String[numberOfValues];
                int index = 0;
                while (tokenizer.hasMoreTokens()) {
                    this.possibleValues[index] = tokenizer.nextToken();
                    ++index;
                }
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.possibleValues = new String[0];
        }
        catch (NoSuchElementException noSuchElementException) {
            this.possibleValues = new String[0];
        }
        catch (NumberFormatException numberFormatException) {
            this.possibleValues = new String[0];
        }
        try {
            this.description = resource.getString(String.valueOf(optionName) + ".description");
        }
        catch (MissingResourceException missingResourceException) {
            this.description = "Missing ressources entries for" + componentName + " options";
        }
    }

    public String getCategory() {
        return this.category;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public int getCurrentValueIndex() {
        return this.currentValueIndex;
    }

    public String getDescription() {
        return this.description;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String[] getPossibleValues() {
        return this.possibleValues;
    }

    public void setValueIndex(int newIndex) {
        this.currentValueIndex = newIndex;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Configurable option for ");
        buffer.append(this.componentName).append("\n");
        buffer.append("- category:\t\t\t").append(this.category).append("\n");
        buffer.append("- name:\t\t\t\t").append(this.name).append("\n");
        buffer.append("- current value:\t");
        if (this.possibleValues == NoDiscreteValue) {
            buffer.append(this.currentValueIndex);
        } else {
            buffer.append(this.possibleValues[this.currentValueIndex]);
        }
        buffer.append("\n");
        if (this.possibleValues != NoDiscreteValue) {
            buffer.append("- possible values:\t[");
            int i = 0;
            int max = this.possibleValues.length;
            while (i < max) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.possibleValues[i]);
                ++i;
            }
            buffer.append("]\n");
            buffer.append("- curr. val. index:\t").append(this.currentValueIndex).append("\n");
        }
        buffer.append("- description:\t\t").append(this.description).append("\n");
        return buffer.toString();
    }

    public String getOptionName() {
        return this.optionName;
    }
}

