/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.index;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.IIndex;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.index.Index;
import org.eclipse.help.internal.index.IndexBuilder;
import org.eclipse.help.internal.index.IndexFile;

public class IndexManager {
    public static final String INDEX_XP_NAME = "index";
    private Collection contributingPlugins;
    private Map indexesByLang = new HashMap();

    private void build(String locale) {
        Collection contributedIndexFiles = this.getContributedIndexFiles(locale);
        IndexBuilder builder = new IndexBuilder((Comparator)Collator.getInstance((Locale)IndexManager.getLocale(locale)));
        builder.build(contributedIndexFiles);
        IIndex index = builder.getBuiltIndex();
        this.indexesByLang.put(locale, index);
    }

    private Collection getContributedIndexFiles(String locale) {
        this.contributingPlugins = new HashSet();
        ArrayList<IndexFile> contributedIndexFiles = new ArrayList<IndexFile>();
        Collection ignored = this.getIgnoredIndexes();
        IExtensionPoint xpt = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.help", INDEX_XP_NAME);
        if (xpt == null) {
            return contributedIndexFiles;
        }
        IExtension[] extensions = xpt.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            this.contributingPlugins.add(extensions[i].getContributor().getName());
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                if (configElements[j].getName().equals(INDEX_XP_NAME)) {
                    String pluginId = configElements[j].getDeclaringExtension().getContributor().getName();
                    String href = configElements[j].getAttribute("file");
                    if (href != null && !ignored.contains("/" + pluginId + "/" + href)) {
                        contributedIndexFiles.add(new IndexFile(pluginId, href, locale));
                    }
                }
                ++j;
            }
            ++i;
        }
        return contributedIndexFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Index getIndex(String locale) {
        if (locale == null) {
            return new Index();
        }
        Index index = (Index)this.indexesByLang.get(locale);
        if (index == null) {
            IndexManager indexManager = this;
            synchronized (indexManager) {
                if (index == null) {
                    this.build(locale);
                }
            }
            index = (Index)this.indexesByLang.get(locale);
            if (index == null) {
                index = new Index();
            }
        }
        return index;
    }

    private Collection getIgnoredIndexes() {
        HashSet<String> ignored = new HashSet<String>();
        try {
            Preferences pref = HelpPlugin.getDefault().getPluginPreferences();
            String ignoredIndexes = pref.getString("ignoredIndexes");
            if (ignoredIndexes != null) {
                StringTokenizer tokens = new StringTokenizer(ignoredIndexes, " ;,");
                while (tokens.hasMoreTokens()) {
                    ignored.add(tokens.nextToken());
                }
            }
        }
        catch (Exception e) {
            HelpPlugin.logError("Problems occurred reading plug-in preferences.", e);
        }
        return ignored;
    }

    public boolean isIndexContributed() {
        return this.isIndexContributed(Platform.getNL());
    }

    public boolean isIndexContributed(String locale) {
        if (locale == null) {
            return false;
        }
        return !this.getContributedIndexFiles(locale).isEmpty();
    }

    private static Locale getLocale(String localeStr) {
        if (localeStr.length() >= 5) {
            return new Locale(localeStr.substring(0, 2), localeStr.substring(3, 5));
        }
        if (localeStr.length() >= 2) {
            return new Locale(localeStr.substring(0, 2), "");
        }
        return Locale.getDefault();
    }
}

