/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.context;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.internal.context.Context;
import org.eclipse.help.internal.context.ContextsFile;
import org.eclipse.help.internal.context.ContextsFileParser;
import org.eclipse.help.internal.context.PluginContexts;
import org.eclipse.help.internal.context.RelatedTopic;

public class ContextsBuilder {
    protected PluginContexts contexts;
    private String definingPluginID;
    private String pluginID;

    public ContextsBuilder(PluginContexts pluginContexts) {
        this.contexts = pluginContexts;
    }

    public void build(RelatedTopic relatedTopic) {
        String href = relatedTopic.getHref();
        if (href == null) {
            relatedTopic.setHref("");
        } else if (!href.equals("") && !href.startsWith("/") && href.indexOf(58) == -1) {
            relatedTopic.setHref("/" + this.definingPluginID + "/" + href);
        }
    }

    public void build(Context context) {
        context.setPluginID(this.pluginID);
        Context existingContext = (Context)this.contexts.get(context.getShortId());
        if (existingContext != null) {
            this.mergeContexts(existingContext, context);
        } else {
            this.contexts.put(context.getShortId(), context);
        }
    }

    public void build(ContextsFile contextsFile) {
        this.pluginID = contextsFile.getPluginID();
        this.definingPluginID = contextsFile.getDefiningPluginID();
        ContextsFileParser parser = new ContextsFileParser(this);
        parser.parse(contextsFile);
    }

    public void build(List pluginContextsFiles) {
        for (ContextsFile contextsFile : pluginContextsFiles) {
            contextsFile.build(this);
        }
    }

    private void mergeContexts(Context existingContext, Context newContext) {
        if (newContext.getStyledText() != null) {
            if (existingContext.getStyledText() != null) {
                existingContext.setStyledText(String.valueOf(existingContext.getStyledText()) + "\n" + newContext.getStyledText());
            } else {
                existingContext.setStyledText(newContext.getStyledText());
            }
        }
        existingContext.getChildren().addAll(newContext.getChildren());
        this.removeDuplicateLinks(existingContext);
    }

    private void removeDuplicateLinks(Context context) {
        List links = context.getChildren();
        if (links == null || links.size() <= 0) {
            return;
        }
        ArrayList<IHelpResource> filtered = new ArrayList<IHelpResource>();
        for (IHelpResource topic1 : links) {
            if (!this.isValidTopic(topic1)) continue;
            boolean dup = false;
            int j = 0;
            while (j < filtered.size()) {
                IHelpResource topic2 = (IHelpResource)filtered.get(j);
                if (this.isValidTopic(topic2) && this.equalTopics(topic1, topic2)) {
                    dup = true;
                    break;
                }
                ++j;
            }
            if (dup) continue;
            filtered.add(topic1);
        }
        context.setChildren(filtered);
    }

    private boolean isValidTopic(IHelpResource topic) {
        return topic != null && topic.getHref() != null && !"".equals(topic.getHref()) && topic.getLabel() != null && !"".equals(topic.getLabel());
    }

    private boolean equalTopics(IHelpResource topic1, IHelpResource topic2) {
        return topic1.getHref().equals(topic2.getHref()) && topic1.getLabel().equals(topic2.getLabel());
    }
}

