/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.builders;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.AbstractModel;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.NLResourceHelper;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.core.builders.CompilerFlags;
import org.eclipse.pde.internal.core.builders.IHeader;
import org.eclipse.pde.internal.core.builders.JarManifestErrorReporter;
import org.eclipse.pde.internal.core.search.PluginJavaSearchUtil;
import org.eclipse.pde.internal.core.util.IdUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class BundleErrorReporter
extends JarManifestErrorReporter {
    private boolean fOsgiR4;
    private IPluginModelBase fModel;
    private Set fProjectPackages;

    protected static IStatus validateVersionString(String versionString) {
        if (versionString == null) {
            return Status.OK_STATUS;
        }
        return PluginVersionIdentifier.validateVersion((String)versionString);
    }

    protected static IStatus validateVersionRange(String versionRangeString) {
        try {
            new VersionRange(versionRangeString);
        }
        catch (IllegalArgumentException e) {
            return new Status(4, "org.eclipse.pde.core", 4, PDECoreMessages.BundleErrorReporter_invalidVersionRangeFormat, (Throwable)e);
        }
        int comma = versionRangeString.indexOf(44);
        if (comma < 0) {
            return BundleErrorReporter.validateVersionString(versionRangeString);
        }
        IStatus status = BundleErrorReporter.validateVersionString(versionRangeString.substring(1, comma));
        if (!status.isOK()) {
            return status;
        }
        return BundleErrorReporter.validateVersionString(versionRangeString.substring(comma + 1, versionRangeString.length() - 1));
    }

    public BundleErrorReporter(IFile file) {
        super(file);
    }

    public void validateContent(IProgressMonitor monitor) {
        super.validateContent(monitor);
        if (this.fHeaders == null || this.getErrorCount() > 0) {
            return;
        }
        this.fModel = PDECore.getDefault().getModelManager().findModel(this.fProject);
        if (this.fModel == null) {
            return;
        }
        this.setOsgiR4();
        if (!this.validateBundleSymbolicName()) {
            return;
        }
        this.validateFragmentHost();
        this.validateRequiredHeader("Bundle-Name");
        this.validateBundleVersion();
        this.validateRequiredExecutionEnvironment();
        this.validateEclipsePlatformFilter();
        this.validateBundleActivator();
        this.validateBundleClasspath();
        this.validateRequireBundle(monitor);
        this.validateImportPackage(monitor);
        this.validateExportPackage(monitor);
        this.validateAutoStart();
        this.validateLazyStart();
        this.validateExtensibleAPI();
        this.validateTranslatableHeaders();
    }

    private void setOsgiR4() {
        IHeader header = (IHeader)this.fHeaders.get("Bundle-ManifestVersion");
        if (header != null) {
            String version = header.getValue();
            try {
                this.fOsgiR4 = version != null && Integer.parseInt(version) > 1;
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private boolean validateBundleSymbolicName() {
        String id;
        IHeader header = this.validateRequiredHeader("Bundle-SymbolicName");
        if (header == null) {
            return false;
        }
        ManifestElement[] elements = header.getElements();
        String string = id = elements.length > 0 ? elements[0].getValue() : null;
        if (id == null || id.length() == 0) {
            this.report(PDECoreMessages.BundleErrorReporter_NoSymbolicName, header.getLineNumber() + 1, 0);
            return false;
        }
        this.validatePluginId(header, id);
        this.validateSingleton(header, elements[0]);
        return true;
    }

    private boolean validatePluginId(IHeader header, String value) {
        if (!IdUtil.isValidCompositeID(value)) {
            String message = PDECoreMessages.BundleErrorReporter_InvalidSymbolicName;
            this.report(message, this.getLine(header, value), 1);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void validateSingleton(IHeader header, ManifestElement element) {
        boolean hasExtensions;
        String singletonAttr = element.getAttribute("singleton");
        String singletonDir = element.getDirective("singleton");
        IPluginBase base = this.fModel.getPluginBase();
        boolean bl = hasExtensions = base != null && (base.getExtensionPoints().length > 0 || base.getExtensions().length > 0);
        if (hasExtensions) {
            if (TargetPlatform.getTargetVersion() >= 3.1) {
                if (!"true".equals(singletonDir)) {
                    if (!"true".equals(singletonAttr)) {
                        String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_singletonRequired, (Object)"singleton");
                        this.report(message, header.getLineNumber() + 1, 0, 4099);
                        return;
                    }
                    if (this.isCheckDeprecated()) {
                        String message = PDECoreMessages.BundleErrorReporter_deprecated_attribute_singleton;
                        this.report(message, this.getLine(header, "singleton="), "compilers.p.deprecated", 4099);
                        return;
                    }
                }
            } else if (!"true".equals(singletonAttr)) {
                String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_singletonAttrRequired, (Object)"singleton");
                this.report(message, header.getLineNumber() + 1, 0, 4100);
                return;
            }
        }
        if (TargetPlatform.getTargetVersion() >= 3.1) {
            if (singletonAttr != null && this.isCheckDeprecated()) {
                String message = PDECoreMessages.BundleErrorReporter_deprecated_attribute_singleton;
                this.report(message, this.getLine(header, "singleton="), "compilers.p.deprecated", 4099);
            }
        } else if (singletonDir != null && this.isCheckDeprecated()) {
            String message = PDECoreMessages.BundleErrorReporter_unsupportedSingletonDirective;
            this.report(message, this.getLine(header, "singleton:="), "compilers.p.deprecated", 4113);
        }
        this.validateBooleanAttributeValue(header, element, "singleton");
        this.validateBooleanDirectiveValue(header, element, "singleton");
    }

    private void validateFragmentHost() {
        ModelEntry entry;
        IPluginModelBase model;
        IHeader header = (IHeader)this.fHeaders.get("Fragment-Host");
        if (header == null) {
            if (this.isCheckNoRequiredAttr() && this.fProject.getFile("fragment.xml").exists()) {
                this.report(PDECoreMessages.BundleErrorReporter_HostNeeded, 1, "compilers.p.no-required-att");
            }
            return;
        }
        if (header.getElements().length == 0) {
            if (this.isCheckNoRequiredAttr()) {
                this.report(PDECoreMessages.BundleErrorReporter_HostNeeded, 1, "compilers.p.no-required-att");
            }
            return;
        }
        if (!this.isCheckUnresolvedImports()) {
            return;
        }
        BundleDescription desc = this.fModel.getBundleDescription();
        if (desc == null) {
            return;
        }
        HostSpecification host = desc.getHost();
        if (host == null) {
            return;
        }
        String name = host.getName();
        if (host.getSupplier() == null) {
            boolean missingHost = false;
            ResolverError[] errors = desc.getContainingState().getResolverErrors(desc);
            int i = 0;
            while (i < errors.length) {
                if (errors[i].getType() == 4) {
                    missingHost = true;
                    break;
                }
                ++i;
            }
            if (missingHost) {
                BundleDescription[] suppliers = desc.getContainingState().getBundles(name);
                boolean resolved = true;
                int i2 = 0;
                while (i2 < suppliers.length) {
                    if (suppliers[i2].getHost() == null) {
                        if (suppliers[i2].isResolved()) {
                            Version version = suppliers[i2].getVersion();
                            VersionRange range = host.getVersionRange();
                            if (!range.isIncluded(version)) {
                                String versionRange = host.getVersionRange().toString();
                                this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_BundleRangeInvalidInBundleVersion, (Object)versionRange), this.getLine(header, versionRange), "compilers.p.unresolved-import");
                                return;
                            }
                        } else {
                            resolved = false;
                        }
                    }
                    ++i2;
                }
                if (!resolved) {
                    this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_unresolvedHost, (Object)name), this.getLine(header, name), "compilers.p.unresolved-import");
                    return;
                }
            }
        }
        IPluginModelBase iPluginModelBase = model = (entry = PDECore.getDefault().getModelManager().findEntry(name)) == null ? null : entry.getActiveModel();
        if (model == null || model instanceof IFragmentModel || !model.isEnabled()) {
            this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_HostNotExistPDE, (Object)name), this.getLine(header, name), "compilers.p.unresolved-import");
        }
    }

    private void validateBundleVersion() {
        IHeader header = this.validateRequiredHeader("Bundle-Version");
        if (header == null) {
            return;
        }
        IStatus status = BundleErrorReporter.validateVersionString(header.getValue());
        if (!status.isOK()) {
            int line = this.getLine(header, header.getValue());
            this.report(status.getMessage(), line, 0);
        }
    }

    private void validateRequiredExecutionEnvironment() {
        int sev = CompilerFlags.getFlag(this.fProject, "compilers.incompatible-environment");
        if (sev == 2) {
            return;
        }
        BundleDescription desc = this.fModel.getBundleDescription();
        if (desc == null) {
            return;
        }
        String[] bundleEnvs = desc.getExecutionEnvironments();
        if (bundleEnvs == null || bundleEnvs.length == 0) {
            return;
        }
        IHeader header = (IHeader)this.fHeaders.get("Bundle-RequiredExecutionEnvironment");
        if (header == null) {
            return;
        }
        IExecutionEnvironment env = JavaRuntime.getExecutionEnvironmentsManager().getEnvironment(bundleEnvs[0]);
        if (env != null) {
            IJavaProject jproject = JavaCore.create((IProject)this.fProject);
            try {
                IClasspathEntry[] entries = jproject.getRawClasspath();
                int i = 0;
                while (i < entries.length) {
                    if (entries[i].getEntryKind() == 5) {
                        IPath validPath;
                        IPath currentPath = entries[i].getPath();
                        if (JavaRuntime.newDefaultJREContainerPath().matchingFirstSegments(currentPath) != 0 && !(validPath = JavaRuntime.newJREContainerPath((IExecutionEnvironment)env)).equals((Object)currentPath)) {
                            this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_reqExecEnv_conflict, (Object)bundleEnvs[0]), this.getLine(header, bundleEnvs[0]), sev, 4115);
                        }
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        IExecutionEnvironment[] systemEnvs = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        int i = 0;
        while (i < bundleEnvs.length) {
            boolean found = false;
            int j = 0;
            while (j < systemEnvs.length) {
                if (bundleEnvs[i].equals(systemEnvs[j].getId())) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_reqExecEnv_unknown, (Object)bundleEnvs[i]), this.getLine(header, bundleEnvs[i]), sev, 4116);
                break;
            }
            ++i;
        }
    }

    private void validateEclipsePlatformFilter() {
        IHeader header = (IHeader)this.fHeaders.get("Eclipse-PlatformFilter");
        if (header == null) {
            return;
        }
        try {
            PDECore.getDefault().getBundleContext().createFilter(header.getValue());
            int severity = CompilerFlags.getFlag(this.fProject, "compilers.incompatible-environment");
            if (severity == 2) {
                return;
            }
            BundleDescription desc = this.fModel.getBundleDescription();
            if (desc != null && !desc.isResolved()) {
                ResolverError[] errors = desc.getContainingState().getResolverErrors(desc);
                int i = 0;
                while (i < errors.length) {
                    if (errors[i].getType() == 8192) {
                        this.report(PDECoreMessages.BundleErrorReporter_badFilter, header.getLineNumber() + 1, severity);
                    }
                    ++i;
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            this.report(PDECoreMessages.BundleErrorReporter_invalidFilterSyntax, header.getLineNumber() + 1, 0);
        }
    }

    private void validateBundleActivator() {
        IHeader header = (IHeader)this.fHeaders.get("Bundle-Activator");
        if (header == null) {
            return;
        }
        String activator = header.getValue();
        BundleDescription desc = this.fModel.getBundleDescription();
        if (desc != null && desc.getHost() != null) {
            this.report(PDECoreMessages.BundleErrorReporter_fragmentActivator, header.getLineNumber() + 1, 0);
            return;
        }
        if (this.isCheckUnknownClass()) {
            try {
                if (this.fProject.hasNature("org.eclipse.jdt.core.javanature")) {
                    IType type;
                    IJavaProject javaProject = JavaCore.create((IProject)this.fProject);
                    if (activator.indexOf(36) != -1) {
                        activator = activator.replace('$', '.');
                    }
                    if ((type = javaProject.findType(activator)) == null || !type.exists()) {
                        this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_NoExist, (Object)activator), this.getLine(header, activator), "compilers.p.unknown-class", 4112);
                    }
                }
            }
            catch (CoreException coreException) {}
        }
    }

    private void validateBundleClasspath() {
        IHeader header = (IHeader)this.fHeaders.get("Bundle-ClassPath");
        if (header != null && header.getElements().length == 0) {
            this.report(PDECoreMessages.BundleErrorReporter_ClasspathNotEmpty, header.getLineNumber() + 1, 0);
        }
    }

    private void validateRequireBundle(IProgressMonitor monitor) {
        if (!this.isCheckUnresolvedImports()) {
            return;
        }
        IHeader header = (IHeader)this.fHeaders.get("Require-Bundle");
        if (header == null) {
            return;
        }
        ManifestElement[] required = header.getElements();
        int i = 0;
        while (i < required.length) {
            block10: {
                this.checkCanceled(monitor);
                String bundleID = required[i].getValue();
                this.validateBundleVersionAttribute(header, required[i]);
                this.validateVisibilityDirective(header, required[i]);
                this.validateReprovideAttribute(header, required[i]);
                this.validateResolutionDirective(header, required[i]);
                this.validateOptionalAttribute(header, required[i]);
                boolean optional = this.isOptional(required[i]);
                int severity = this.getRequireBundleSeverity(required[i], optional);
                IPluginModel model = PDECore.getDefault().getModelManager().findPluginModel(bundleID);
                if (model == null || !model.isEnabled()) {
                    IMarker marker = this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_NotExistPDE, (Object)bundleID), this.getPackageLine(header, required[i]), severity, 4104);
                    try {
                        if (marker == null) break block10;
                        marker.setAttribute("bundleId", (Object)required[i].getValue());
                        if (optional) {
                            marker.setAttribute("optional", true);
                        }
                    }
                    catch (CoreException coreException) {}
                } else {
                    String requiredRange = required[i].getAttribute("bundle-version");
                    if (requiredRange != null && BundleErrorReporter.validateVersionRange(requiredRange).isOK()) {
                        VersionRange versionRange = new VersionRange(requiredRange);
                        String version = model.getPlugin().getVersion();
                        if (version != null && !versionRange.isIncluded(new Version(version))) {
                            this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_BundleRangeInvalidInBundleVersion, (Object)(String.valueOf(bundleID) + ": " + versionRange.toString())), this.getPackageLine(header, required[i]), severity);
                        }
                    }
                }
            }
            ++i;
        }
    }

    private void validateBundleVersionAttribute(IHeader header, ManifestElement element) {
        String versionRange = element.getAttribute("bundle-version");
        if (versionRange != null && !BundleErrorReporter.validateVersionRange(versionRange).isOK()) {
            this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_InvalidFormatInBundleVersion, (Object)element.getValue()), this.getPackageLine(header, element), 0);
        }
    }

    private void validateVisibilityDirective(IHeader header, ManifestElement element) {
        String visibility = element.getDirective("visibility");
        if (visibility != null) {
            this.validateDirectiveValue(header, element, "visibility", new String[]{"private", "reexport"});
        }
    }

    private void validateReprovideAttribute(IHeader header, ManifestElement element) {
        String rexport = element.getAttribute("reprovide");
        if (rexport != null) {
            this.validateBooleanAttributeValue(header, element, "reprovide");
            if (this.fOsgiR4 && this.isCheckDeprecated()) {
                String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_deprecated_attribute_reprovide, (Object)"reprovide");
                this.report(message, this.getLine(header, "reprovide="), "compilers.p.deprecated");
            }
        }
    }

    private boolean isOptional(ManifestElement element) {
        return "optional".equals(element.getDirective("resolution")) || "true".equals(element.getAttribute("optional"));
    }

    private int getRequireBundleSeverity(ManifestElement requireBundleElement, boolean optional) {
        int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.unresolved-import");
        if (optional && severity != 2) {
            ++severity;
        }
        return severity;
    }

    private void validateResolutionDirective(IHeader header, ManifestElement requireBundleElement) {
        String resolution = requireBundleElement.getDirective("resolution");
        if (resolution != null) {
            this.validateDirectiveValue(header, requireBundleElement, "resolution", new String[]{"mandatory", "optional"});
        }
    }

    private void validateOptionalAttribute(IHeader header, ManifestElement element) {
        String rexport = element.getAttribute("optional");
        if (rexport != null) {
            this.validateBooleanAttributeValue(header, element, "optional");
            if (this.fOsgiR4 && this.isCheckDeprecated()) {
                this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_deprecated_attribute_optional, (Object)"optional"), this.getLine(header, "optional="), "compilers.p.deprecated");
            }
        }
    }

    private void validateImportPackage(IProgressMonitor monitor) {
        int i;
        BundleDescription desc = this.fModel.getBundleDescription();
        if (desc == null) {
            return;
        }
        IHeader header = (IHeader)this.fHeaders.get("Import-Package");
        if (header == null) {
            return;
        }
        boolean hasUnresolved = false;
        VersionConstraint[] constraints = desc.getContainingState().getStateHelper().getUnsatisfiedConstraints(desc);
        int i2 = 0;
        while (i2 < constraints.length) {
            if (constraints[i2] instanceof ImportPackageSpecification) {
                hasUnresolved = true;
                break;
            }
            ++i2;
        }
        HashMap exported = this.getAvailableExportedPackages(desc.getContainingState());
        ImportPackageSpecification[] imports = desc.getImportPackages();
        if (desc.hasDynamicImports()) {
            ArrayList<ImportPackageSpecification> staticImportsList = new ArrayList<ImportPackageSpecification>();
            i = 0;
            while (i < imports.length) {
                if (!imports[i].getDirective("resolution").equals("dynamic")) {
                    staticImportsList.add(imports[i]);
                }
                ++i;
            }
            imports = staticImportsList.toArray(new ImportPackageSpecification[staticImportsList.size()]);
        }
        ManifestElement[] elements = header.getElements();
        i = 0;
        while (i < elements.length) {
            this.checkCanceled(monitor);
            this.validateSpecificationVersionAttribute(header, elements[i]);
            this.validateResolutionDirective(header, elements[i]);
            if (hasUnresolved) {
                IHeader jreHeader;
                this.validateVersionAttribute(header, elements[i], true);
                String name = imports[i].getName();
                if (!(!name.equals("java") && !name.startsWith("java.") || (jreHeader = (IHeader)this.fHeaders.get("Eclipse-JREBundle")) != null && "true".equals(jreHeader.getValue()))) {
                    this.report(PDECoreMessages.BundleErrorReporter_importNoJRE, this.getPackageLine(header, elements[i]), 0, 4098);
                } else if (!imports[i].isResolved() && this.isCheckUnresolvedImports()) {
                    boolean optional = this.isOptional(elements[i]);
                    int severity = this.getRequireBundleSeverity(elements[i], optional);
                    ExportPackageDescription export = (ExportPackageDescription)exported.get(name);
                    if (export != null) {
                        if (export.getSupplier().isResolved()) {
                            Version version = export.getVersion();
                            VersionRange range = imports[i].getVersionRange();
                            if (range != null && !range.isIncluded(version)) {
                                this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_unsatisfiedConstraint, (Object)imports[i].toString()), this.getPackageLine(header, elements[i]), severity);
                            }
                        } else {
                            this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_unresolvedExporter, (Object[])new String[]{export.getSupplier().getSymbolicName(), name}), this.getPackageLine(header, elements[i]), severity);
                        }
                    } else {
                        IMarker marker = this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_PackageNotExported, (Object)name), this.getPackageLine(header, elements[i]), severity, 4103);
                        try {
                            if (marker != null) {
                                marker.setAttribute("packageName", (Object)name);
                                if (optional) {
                                    marker.setAttribute("optional", true);
                                }
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                }
            }
            ++i;
        }
    }

    private HashMap getAvailableExportedPackages(State state) {
        BundleDescription[] bundles = state.getBundles();
        HashMap<String, ExportPackageDescription> exported = new HashMap<String, ExportPackageDescription>();
        int i = 0;
        while (i < bundles.length) {
            ExportPackageDescription[] exports = bundles[i].getExportPackages();
            int j = 0;
            while (j < exports.length) {
                String name = exports[j].getName();
                if (exported.containsKey(name)) {
                    if (exports[j].getSupplier().isResolved()) {
                        exported.put(name, exports[j]);
                    }
                } else {
                    exported.put(name, exports[j]);
                }
                ++j;
            }
            ++i;
        }
        return exported;
    }

    protected void validateExportPackage(IProgressMonitor monitor) {
        IHeader header = (IHeader)this.fHeaders.get("Export-Package");
        if (header == null) {
            return;
        }
        String message = null;
        ManifestElement[] elements = header.getElements();
        int i = 0;
        while (i < elements.length) {
            block12: {
                String name;
                block11: {
                    block10: {
                        this.checkCanceled(monitor);
                        this.validateVersionAttribute(header, elements[i], false);
                        this.validateSpecificationVersionAttribute(header, elements[i]);
                        this.validateX_InternalDirective(header, elements[i]);
                        this.validateX_FriendsDirective(header, elements[i]);
                        name = elements[i].getValue();
                        if (!name.equals("java") && !name.startsWith("java.")) break block10;
                        IHeader jreHeader = (IHeader)this.fHeaders.get("Eclipse-JREBundle");
                        if (jreHeader == null || !"true".equals(jreHeader.getValue())) {
                            message = PDECoreMessages.BundleErrorReporter_exportNoJRE;
                            this.report(message, this.getPackageLine(header, elements[i]), 0, 4098);
                        }
                        break block11;
                    }
                    if (".".equals(name.trim())) break block12;
                }
                if (this.isCheckUnresolvedImports() && !this.getExportedPackages().contains(name)) {
                    message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_NotExistInProject, (Object)name);
                    IMarker marker = this.report(message, this.getPackageLine(header, elements[i]), "compilers.p.unresolved-import", 4102);
                    try {
                        if (marker != null) {
                            marker.setAttribute("packageName", (Object)name);
                        }
                    }
                    catch (CoreException coreException) {}
                }
            }
            ++i;
        }
    }

    private Set getExportedPackages() {
        if (this.fProjectPackages == null) {
            this.fProjectPackages = new HashSet();
            this.addProjectPackages(this.fProject);
            BundleDescription desc = this.fModel.getBundleDescription();
            if (desc != null) {
                HostSpecification host = desc.getHost();
                if (host != null) {
                    this.addHostPackages(host.getName());
                } else {
                    this.addFragmentPackages(desc.getFragments());
                }
            }
        }
        return this.fProjectPackages;
    }

    private void addHostPackages(String hostID) {
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        IPluginModel model = manager.findPluginModel(hostID);
        if (model != null) {
            IResource resource = model.getUnderlyingResource();
            if (resource != null) {
                this.addProjectPackages(resource.getProject());
            } else {
                try {
                    if (this.fProject.hasNature("org.eclipse.jdt.core.javanature")) {
                        IPackageFragment[] packages = PluginJavaSearchUtil.collectPackageFragments(new IPluginBase[]{model.getPluginBase()}, JavaCore.create((IProject)this.fProject), false);
                        int i = 0;
                        while (i < packages.length) {
                            this.fProjectPackages.add(packages[i].getElementName());
                            ++i;
                        }
                    }
                }
                catch (CoreException coreException) {}
            }
        }
    }

    private void addFragmentPackages(BundleDescription[] fragments) {
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        int i = 0;
        while (i < fragments.length) {
            IResource resource;
            String id = fragments[i].getSymbolicName();
            IFragmentModel model = manager.findFragmentModel(id);
            IResource iResource = resource = model == null ? null : model.getUnderlyingResource();
            if (resource != null) {
                this.addProjectPackages(resource.getProject());
            }
            ++i;
        }
    }

    private void addProjectPackages(IProject proj) {
        try {
            if (proj.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject jp = JavaCore.create((IProject)proj);
                IPackageFragmentRoot[] roots = jp.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    if (roots[i].getKind() == 1 || roots[i].getKind() == 2 && !roots[i].isExternal()) {
                        IJavaElement[] children = roots[i].getChildren();
                        int j = 0;
                        while (j < children.length) {
                            IPackageFragment f = (IPackageFragment)children[j];
                            String name = f.getElementName();
                            if (name.equals("")) {
                                name = ".";
                            }
                            if (f.hasChildren() || f.getNonJavaResources().length > 0) {
                                this.fProjectPackages.add(name);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
    }

    protected boolean isCheckDeprecated() {
        return CompilerFlags.getFlag(this.fProject, "compilers.p.deprecated") != 2;
    }

    protected boolean isCheckNoRequiredAttr() {
        return CompilerFlags.getFlag(this.fProject, "compilers.p.no-required-att") != 2;
    }

    protected boolean isCheckUnknownClass() {
        return CompilerFlags.getFlag(this.fProject, "compilers.p.unknown-class") != 2;
    }

    protected boolean isCheckUnresolvedImports() {
        return CompilerFlags.getFlag(this.fProject, "compilers.p.unresolved-import") != 2;
    }

    private void validateTranslatableHeaders() {
        int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.not-externalized-att");
        if (severity == 2) {
            return;
        }
        int i = 0;
        while (i < ICoreConstants.TRANSLATABLE_HEADERS.length) {
            IHeader header = (IHeader)this.fHeaders.get(ICoreConstants.TRANSLATABLE_HEADERS[i]);
            if (header != null) {
                NLResourceHelper helper;
                String value = header.getValue();
                if (!value.startsWith("%")) {
                    this.report(NLS.bind((String)PDECoreMessages.Builders_Manifest_non_ext_attribute, (Object)header.getName()), this.getLine(header, value), severity, 12290, header.getName());
                } else if (this.fModel instanceof AbstractModel && ((helper = ((AbstractModel)((Object)this.fModel)).getNLResourceHelper()) == null || !helper.resourceExists(value))) {
                    this.report(NLS.bind((String)PDECoreMessages.Builders_Manifest_key_not_found, (Object)value.substring(1)), this.getLine(header, value), severity);
                }
            }
            ++i;
        }
    }

    private void validateSpecificationVersionAttribute(IHeader header, ManifestElement element) {
        String version = element.getAttribute("specification-version");
        IStatus status = BundleErrorReporter.validateVersionString(version);
        if (!status.isOK()) {
            this.report(status.getMessage(), this.getPackageLine(header, element), 0);
        }
        if (this.isCheckDeprecated() && this.fOsgiR4 && version != null) {
            this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_deprecated_attribute_specification_version, (Object)"specification-version"), this.getPackageLine(header, element), "compilers.p.deprecated");
        }
    }

    private void validateVersionAttribute(IHeader header, ManifestElement element, boolean range) {
        IStatus status;
        String version = element.getAttribute("version");
        if (version == null) {
            return;
        }
        IStatus iStatus = status = range ? BundleErrorReporter.validateVersionRange(version) : BundleErrorReporter.validateVersionString(version);
        if (!status.isOK()) {
            this.report(status.getMessage(), this.getPackageLine(header, element), 0);
        }
    }

    private void validateX_InternalDirective(IHeader header, ManifestElement element) {
        String internal = element.getDirective("x-internal");
        if (internal == null) {
            return;
        }
        int i = 0;
        while (i < BOOLEAN_VALUES.length) {
            if (BOOLEAN_VALUES[i].equals(internal)) {
                return;
            }
            ++i;
        }
        String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_dir_value, (Object[])new String[]{internal, "x-internal"});
        this.report(message, this.getPackageLine(header, element), 0);
    }

    private void validateX_FriendsDirective(IHeader header, ManifestElement element) {
        String friends = element.getDirective("x-friends");
        String internal = element.getDirective("x-internal");
        if (friends != null && internal != null) {
            String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_directive_hasNoEffectWith_, (Object[])new String[]{"x-friends", "x-internal"});
            IMarker marker = this.report(message, this.getPackageLine(header, element), 1, 4114);
            try {
                if (marker != null) {
                    marker.setAttribute("packageName", (Object)element.getValue());
                }
            }
            catch (CoreException coreException) {}
        }
    }

    private void validateAutoStart() {
        IHeader header = (IHeader)this.fHeaders.get("Eclipse-AutoStart");
        if (!this.validateStartHeader(header)) {
            return;
        }
        int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.deprecated");
        if (severity != 2 && TargetPlatform.getTargetVersion() >= 3.2) {
            int line = header.getLineNumber();
            this.report(PDECoreMessages.BundleErrorReporter_startHeader_autoStartDeprecated, line + 1, severity, 4097);
        }
    }

    private void validateLazyStart() {
        IHeader header = (IHeader)this.fHeaders.get("Eclipse-LazyStart");
        int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.deprecated");
        if (header != null && TargetPlatform.getTargetVersion() < 3.2 && severity != 2) {
            this.report(PDECoreMessages.BundleErrorReporter_lazyStart_unsupported, header.getLineNumber() + 1, severity, -1);
        } else {
            this.validateStartHeader(header);
        }
    }

    private boolean validateStartHeader(IHeader header) {
        if (header == null) {
            return false;
        }
        this.validateBooleanValue(header);
        return this.exceptionsAttributesValid(header, header.getElements());
    }

    private boolean exceptionsAttributesValid(IHeader header, ManifestElement[] elements) {
        String key;
        if (elements == null || elements.length == 0) {
            return true;
        }
        int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.unknown-attribute");
        if (severity == 2) {
            return true;
        }
        Enumeration keys = elements[0].getKeys();
        if (keys != null && keys.hasMoreElements() && "exceptions".equals(key = (String)keys.nextElement())) {
            String[] values = elements[0].getAttributes(key);
            int i = 0;
            while (i < values.length) {
                StringTokenizer st = new StringTokenizer(values[i], ",");
                while (st.hasMoreTokens()) {
                    String name = st.nextToken().trim();
                    if (this.getExportedPackages().contains(name)) continue;
                    String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_NotExistInProject, (Object)name);
                    this.report(message, this.getLine(header, name), "compilers.p.unresolved-import");
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private void validateExtensibleAPI() {
        IHeader header = (IHeader)this.fHeaders.get("Eclipse-ExtensibleAPI");
        if (header != null) {
            this.validateBooleanValue(header);
        }
    }

    public void report(String message, int line, int severity, int problemID, String headerName) {
        try {
            IMarker marker = this.report(message, line, severity, problemID);
            if (marker != null) {
                marker.setAttribute("xmlTree.locationPath", (Object)headerName);
            }
        }
        catch (CoreException coreException) {}
    }
}

