/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.EntryFileAdapter;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.RequiredPluginsClasspathContainer;

public class ModelEntry
extends PlatformObject {
    private String id;
    private IPluginModelBase fWorkspaceModel;
    private IPluginModelBase fExternalModel;
    private RequiredPluginsClasspathContainer fClasspathContainer;
    private boolean fInJavaSearch;
    private PluginModelManager fManager;

    public ModelEntry(PluginModelManager manager, String id) {
        this.fManager = manager;
        this.id = id;
    }

    public IPluginModelBase getActiveModel() {
        return this.fWorkspaceModel != null ? this.fWorkspaceModel : this.fExternalModel;
    }

    public String getId() {
        return this.id;
    }

    public Object[] getChildren() {
        File file;
        if (this.fWorkspaceModel == null && this.fExternalModel != null && !(file = new File(this.fExternalModel.getInstallLocation())).isFile()) {
            EntryFileAdapter adapter = new EntryFileAdapter(this, file, this.fManager.getFileAdapterFactory());
            return adapter.getChildren();
        }
        return new Object[0];
    }

    public boolean isInJavaSearch() {
        return this.fInJavaSearch;
    }

    void setInJavaSearch(boolean value) {
        this.fInJavaSearch = value;
    }

    public void setWorkspaceModel(IPluginModelBase model) {
        this.fWorkspaceModel = model;
        this.fClasspathContainer = null;
    }

    public void setExternalModel(IPluginModelBase model) {
        this.fExternalModel = model;
        this.fClasspathContainer = null;
    }

    public IPluginModelBase getWorkspaceModel() {
        return this.fWorkspaceModel;
    }

    public IPluginModelBase getExternalModel() {
        return this.fExternalModel;
    }

    public boolean isEmpty() {
        return this.fWorkspaceModel == null && this.fExternalModel == null;
    }

    public RequiredPluginsClasspathContainer getClasspathContainer(boolean reset) {
        if (reset) {
            this.fClasspathContainer = null;
        }
        if (this.fClasspathContainer == null) {
            this.fClasspathContainer = new RequiredPluginsClasspathContainer(this.fWorkspaceModel);
        }
        return this.fClasspathContainer;
    }

    public void updateClasspathContainer(boolean doCheckClasspath) throws CoreException {
        if (this.shouldUpdateClasspathContainer(doCheckClasspath)) {
            IProject project = this.fWorkspaceModel.getUnderlyingResource().getProject();
            IJavaProject[] javaProjects = new IJavaProject[]{JavaCore.create((IProject)project)};
            IClasspathContainer[] containers = new IClasspathContainer[]{this.getClasspathContainer(true)};
            Path path = new Path("org.eclipse.pde.core.requiredPlugins");
            try {
                JavaCore.setClasspathContainer((IPath)path, (IJavaProject[])javaProjects, (IClasspathContainer[])containers, null);
            }
            catch (OperationCanceledException e) {
                this.getClasspathContainer(false).reset();
                throw e;
            }
        }
    }

    public boolean shouldUpdateClasspathContainer(boolean doCheckClasspath) throws CoreException {
        if (this.fWorkspaceModel == null) {
            return false;
        }
        IProject project = this.fWorkspaceModel.getUnderlyingResource().getProject();
        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
            return false;
        }
        return !doCheckClasspath || this.fWorkspaceModel.isLoaded();
    }

    public static void updateUnknownClasspathContainer(IJavaProject javaProject) throws CoreException {
        if (javaProject == null) {
            return;
        }
        Path path = new Path("org.eclipse.pde.core.requiredPlugins");
        JavaCore.setClasspathContainer((IPath)path, (IJavaProject[])new IJavaProject[]{javaProject}, (IClasspathContainer[])new IClasspathContainer[]{new RequiredPluginsClasspathContainer(null)}, null);
    }
}

