/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import com.ibm.icu.text.MessageFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IDropToFrame;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IRegister;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IStep;
import org.eclipse.debug.core.model.IStepFilters;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.ColorManager;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIAdapterFactory;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DefaultLabelProvider;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.ImageDescriptorRegistry;
import org.eclipse.debug.internal.ui.StepFilterManager;
import org.eclipse.debug.internal.ui.actions.context.ActionAdapterFactory;
import org.eclipse.debug.internal.ui.contexts.SuspendTriggerAdapterFactory;
import org.eclipse.debug.internal.ui.launchConfigurations.ClosedProjectFilter;
import org.eclipse.debug.internal.ui.launchConfigurations.DeletedProjectFilter;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTypeFilter;
import org.eclipse.debug.internal.ui.launchConfigurations.PerspectiveManager;
import org.eclipse.debug.internal.ui.launchConfigurations.WorkingSetsFilter;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupFacility;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupManager;
import org.eclipse.debug.internal.ui.stringsubstitution.SelectedResourceManager;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointOrganizerManager;
import org.eclipse.debug.internal.ui.views.breakpoints.OtherBreakpointCategory;
import org.eclipse.debug.internal.ui.views.console.ProcessConsoleManager;
import org.eclipse.debug.internal.ui.views.launch.DebugElementAdapterFactory;
import org.eclipse.debug.internal.ui.views.launch.DebugElementHelper;
import org.eclipse.debug.internal.ui.views.memory.renderings.MemorySegment;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.IProgressService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.w3c.dom.Document;

public class DebugUIPlugin
extends AbstractUIPlugin
implements ILaunchListener {
    private static final String PI_DEBUG_UI = "org.eclipse.debug.ui";
    private static DebugUIPlugin fgDebugUIPlugin = null;
    protected static IDebugModelPresentation fgPresentation = null;
    private static DefaultLabelProvider fgDefaultLabelProvider;
    public static String ATTR_LAUNCHING_CONFIG_HANDLE;
    private ProcessConsoleManager fProcessConsoleManager = null;
    private PerspectiveManager fPerspectiveManager = null;
    private LaunchConfigurationManager fLaunchConfigurationManager = null;
    private StepFilterManager fStepFilterManager = null;
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    private ServiceTracker fServiceTracker;
    private PackageAdmin fPackageAdminService;
    public static boolean DEBUG;

    static {
        ATTR_LAUNCHING_CONFIG_HANDLE = String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + "launching_config_handle";
        DEBUG = false;
    }

    public Bundle getBundle(Class clazz) {
        if (this.fPackageAdminService != null) {
            return this.fPackageAdminService.getBundle(clazz);
        }
        return null;
    }

    public DebugUIPlugin() {
        fgDebugUIPlugin = this;
    }

    public static void debug(String message) {
        if (DEBUG) {
            System.out.println(message);
        }
    }

    public static DebugUIPlugin getDefault() {
        return fgDebugUIPlugin;
    }

    public static String getUniqueIdentifier() {
        return PI_DEBUG_UI;
    }

    public static IDebugModelPresentation getModelPresentation() {
        if (fgPresentation == null) {
            fgPresentation = new DelegatingModelPresentation();
        }
        return fgPresentation;
    }

    public LaunchConfigurationManager getLaunchConfigurationManager() {
        if (this.fLaunchConfigurationManager == null) {
            this.fLaunchConfigurationManager = new LaunchConfigurationManager();
        }
        return this.fLaunchConfigurationManager;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getShell() {
        if (DebugUIPlugin.getActiveWorkbenchWindow() != null) {
            return DebugUIPlugin.getActiveWorkbenchWindow().getShell();
        }
        return null;
    }

    public static ILabelProvider getDefaultLabelProvider() {
        if (fgDefaultLabelProvider == null) {
            fgDefaultLabelProvider = new DefaultLabelProvider();
        }
        return fgDefaultLabelProvider;
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) throws CoreException {
        Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
        if (bundle.getState() == 32) {
            return element.createExecutableExtension(classAttribute);
        }
        final Object[] ret = new Object[1];
        final CoreException[] exc = new CoreException[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    ret[0] = element.createExecutableExtension(classAttribute);
                }
                catch (CoreException e) {
                    exc[0] = e;
                }
            }
        });
        if (exc[0] != null) {
            throw exc[0];
        }
        return ret[0];
    }

    protected ImageRegistry createImageRegistry() {
        return DebugPluginImages.initializeImageRegistry();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.fProcessConsoleManager != null) {
                this.fProcessConsoleManager.shutdown();
            }
            BreakpointOrganizerManager.getDefault().shutdown();
            if (this.fPerspectiveManager != null) {
                this.fPerspectiveManager.shutdown();
            }
            if (this.fLaunchConfigurationManager != null) {
                this.fLaunchConfigurationManager.shutdown();
            }
            if (this.fStepFilterManager != null) {
                this.fStepFilterManager.shutdown();
            }
            ColorManager.getDefault().dispose();
            if (fgPresentation != null) {
                fgPresentation.dispose();
            }
            if (this.fImageDescriptorRegistry != null) {
                this.fImageDescriptorRegistry.dispose();
            }
            SourceLookupFacility.shutdown();
            DebugElementHelper.dispose();
            this.fServiceTracker.close();
            this.fPackageAdminService = null;
        }
        finally {
            super.stop(context);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        DEBUG = "true".equals(Platform.getDebugOption((String)"org.eclipse.debug.ui/debug"));
        this.fPerspectiveManager = new PerspectiveManager();
        this.fPerspectiveManager.startup();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this);
        BreakpointOrganizerManager.getDefault();
        IAdapterManager manager = Platform.getAdapterManager();
        DebugElementAdapterFactory propertiesFactory = new DebugElementAdapterFactory();
        manager.registerAdapters((IAdapterFactory)propertiesFactory, ILaunchManager.class);
        manager.registerAdapters((IAdapterFactory)propertiesFactory, ILaunch.class);
        manager.registerAdapters((IAdapterFactory)propertiesFactory, IDebugTarget.class);
        manager.registerAdapters((IAdapterFactory)propertiesFactory, IProcess.class);
        manager.registerAdapters((IAdapterFactory)propertiesFactory, IThread.class);
        manager.registerAdapters((IAdapterFactory)propertiesFactory, IStackFrame.class);
        manager.registerAdapters((IAdapterFactory)propertiesFactory, IRegisterGroup.class);
        manager.registerAdapters((IAdapterFactory)propertiesFactory, IVariable.class);
        manager.registerAdapters((IAdapterFactory)propertiesFactory, IRegister.class);
        manager.registerAdapters((IAdapterFactory)propertiesFactory, IExpression.class);
        manager.registerAdapters((IAdapterFactory)propertiesFactory, IExpressionManager.class);
        manager.registerAdapters((IAdapterFactory)propertiesFactory, OtherBreakpointCategory.class);
        manager.registerAdapters((IAdapterFactory)propertiesFactory, IDebugElement.class);
        manager.registerAdapters((IAdapterFactory)propertiesFactory, IMemoryBlockRetrieval.class);
        manager.registerAdapters((IAdapterFactory)propertiesFactory, MemorySegment.class);
        DebugUIAdapterFactory uiFactory = new DebugUIAdapterFactory();
        manager.registerAdapters((IAdapterFactory)uiFactory, ILaunchConfiguration.class);
        manager.registerAdapters((IAdapterFactory)uiFactory, ILaunchConfigurationType.class);
        SuspendTriggerAdapterFactory factory = new SuspendTriggerAdapterFactory();
        manager.registerAdapters((IAdapterFactory)factory, ILaunch.class);
        ActionAdapterFactory actionFactory = new ActionAdapterFactory();
        manager.registerAdapters((IAdapterFactory)actionFactory, IDisconnect.class);
        manager.registerAdapters((IAdapterFactory)actionFactory, IDropToFrame.class);
        manager.registerAdapters((IAdapterFactory)actionFactory, IStep.class);
        manager.registerAdapters((IAdapterFactory)actionFactory, IStepFilters.class);
        manager.registerAdapters((IAdapterFactory)actionFactory, ISuspendResume.class);
        manager.registerAdapters((IAdapterFactory)actionFactory, ITerminate.class);
        manager.registerAdapters((IAdapterFactory)actionFactory, ILaunch.class);
        manager.registerAdapters((IAdapterFactory)actionFactory, IProcess.class);
        manager.registerAdapters((IAdapterFactory)actionFactory, IDebugElement.class);
        DebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                SelectedResourceManager.getDefault();
                DebugUIPlugin.this.getLaunchConfigurationManager().getLaunchShortcuts();
            }
        });
        this.fServiceTracker = new ServiceTracker(context, PackageAdmin.class.getName(), null);
        this.fServiceTracker.open();
        this.fPackageAdminService = (PackageAdmin)this.fServiceTracker.getService();
    }

    public static void errorDialog(Shell shell, String title, String message, IStatus s) {
        if (s != null && message.equals(s.getMessage())) {
            message = null;
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)s);
    }

    public static void errorDialog(Shell shell, String title, String message, Throwable t) {
        IStatus status;
        if (t instanceof CoreException) {
            status = ((CoreException)t).getStatus();
            if (status != null && message.equals(status.getMessage())) {
                message = null;
            }
        } else {
            status = new Status(4, DebugUIPlugin.getUniqueIdentifier(), 120, "Error within Debug UI: ", t);
            DebugUIPlugin.log(status);
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
    }

    public static void log(IStatus status) {
        DebugUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable t) {
        DebugUIPlugin.log(DebugUIPlugin.newErrorStatus("Error logged from Debug UI: ", t));
    }

    public static void logErrorMessage(String message) {
        DebugUIPlugin.log(DebugUIPlugin.newErrorStatus("Internal message logged from Debug UI: " + message, null));
    }

    public static IStatus newErrorStatus(String message, Throwable exception) {
        return new Status(4, DebugUIPlugin.getUniqueIdentifier(), 120, message, exception);
    }

    protected static boolean saveAllEditors(boolean confirm) {
        if (DebugUIPlugin.getActiveWorkbenchWindow() == null) {
            return false;
        }
        return PlatformUI.getWorkbench().saveAllEditors(confirm);
    }

    public static boolean saveAndBuild() {
        boolean status = true;
        String saveDirty = DebugUIPlugin.getDefault().getPreferenceStore().getString(IInternalDebugUIConstants.PREF_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH);
        boolean buildBeforeLaunch = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IDebugUIConstants.PREF_BUILD_BEFORE_LAUNCH);
        if (saveDirty.equals("never")) {
            if (buildBeforeLaunch) {
                return DebugUIPlugin.doBuild();
            }
        } else {
            status = DebugUIPlugin.saveAllEditors(saveDirty.equals("prompt"));
            if (status && buildBeforeLaunch) {
                status = DebugUIPlugin.doBuild();
            }
        }
        return status;
    }

    private static boolean doBuild() {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        ResourcesPlugin.getWorkspace().build(10, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            String title = DebugUIMessages.DebugUIPlugin_Run_Debug_1;
            String message = DebugUIMessages.DebugUIPlugin_Build_error__Check_log_for_details__2;
            Throwable t = e.getTargetException();
            DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), title, message, t);
            return false;
        }
        return true;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static Color getPreferenceColor(String type) {
        return ColorManager.getDefault().getColor(PreferenceConverter.getColor((IPreferenceStore)DebugUIPlugin.getDefault().getPreferenceStore(), (String)type));
    }

    public ProcessConsoleManager getProcessConsoleManager() {
        if (this.fProcessConsoleManager == null) {
            this.fProcessConsoleManager = new ProcessConsoleManager();
        }
        return this.fProcessConsoleManager;
    }

    public static String serializeDocument(Document doc) throws TransformerException, IOException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        StreamResult outputTarget = new StreamResult(s);
        transformer.transform(source, outputTarget);
        return s.toString("UTF8");
    }

    public static Document getDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        return doc;
    }

    public void launchAdded(ILaunch launch) {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this);
        this.getProcessConsoleManager().startup();
        if (this.fStepFilterManager == null) {
            this.getStepFilterManager().launchAdded(launch);
        }
        this.getLaunchConfigurationManager().startup();
        SourceLookupManager.getDefault();
    }

    public PerspectiveManager getPerspectiveManager() {
        return this.fPerspectiveManager;
    }

    public StepFilterManager getStepFilterManager() {
        if (this.fStepFilterManager == null) {
            this.fStepFilterManager = new StepFilterManager();
        }
        return this.fStepFilterManager;
    }

    public void launchChanged(ILaunch launch) {
    }

    public void launchRemoved(ILaunch launch) {
    }

    public static boolean preLaunchSave() {
        String saveDirty = DebugUIPlugin.getDefault().getPreferenceStore().getString(IInternalDebugUIConstants.PREF_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH);
        if (saveDirty.equals("never")) {
            return true;
        }
        return DebugUIPlugin.saveAllEditors(saveDirty.equals("prompt"));
    }

    public static ILaunch buildAndLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        boolean buildBeforeLaunch = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IDebugUIConstants.PREF_BUILD_BEFORE_LAUNCH);
        IProgressMonitor subMonitor = monitor;
        String message = MessageFormat.format((String)"{0}...", (Object[])new String[]{configuration.getName()});
        if (buildBeforeLaunch) {
            monitor.beginTask(message, 200);
            return configuration.launch(mode, monitor, true);
        }
        subMonitor = monitor;
        subMonitor.beginTask(message, 100);
        return configuration.launch(mode, subMonitor);
    }

    public static void launchInForeground(final ILaunchConfiguration configuration, final String mode) {
        final IJobManager jobManager = Platform.getJobManager();
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        boolean wait = false;
        if (jobManager.find(ResourcesPlugin.FAMILY_AUTO_BUILD).length > 0 || jobManager.find(ResourcesPlugin.FAMILY_MANUAL_BUILD).length > 0) {
            String waitForBuild = store.getString(IInternalDebugUIConstants.PREF_WAIT_FOR_BUILD);
            if (waitForBuild.equals("prompt")) {
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoCancelQuestion((Shell)DebugUIPlugin.getShell(), (String)DebugUIMessages.DebugUIPlugin_23, (String)DebugUIMessages.DebugUIPlugin_24, null, (boolean)false, (IPreferenceStore)store, (String)IInternalDebugUIConstants.PREF_WAIT_FOR_BUILD);
                switch (dialog.getReturnCode()) {
                    case 1: {
                        return;
                    }
                    case 2: {
                        wait = false;
                        break;
                    }
                    case 3: {
                        wait = true;
                    }
                }
            } else if (waitForBuild.equals("always")) {
                wait = true;
            }
        }
        if (wait) {
            IWorkbench workbench = DebugUIPlugin.getDefault().getWorkbench();
            IProgressService progressService = workbench.getProgressService();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        jobManager.join(ResourcesPlugin.FAMILY_MANUAL_BUILD, monitor);
                        jobManager.join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (!monitor.isCanceled()) {
                        try {
                            DebugUIPlugin.buildAndLaunch(configuration, mode, monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                }
            };
            try {
                progressService.busyCursorWhile(runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e2) {
                DebugUIPlugin.handleInvocationTargetException(e2, configuration, mode);
            }
        } else {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        DebugUIPlugin.buildAndLaunch(configuration, mode, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
            }
            catch (InvocationTargetException e) {
                DebugUIPlugin.handleInvocationTargetException(e, configuration, mode);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static void handleInvocationTargetException(InvocationTargetException e, ILaunchConfiguration configuration, String mode) {
        Throwable targetException = e.getTargetException();
        Throwable t = e;
        if (targetException instanceof CoreException) {
            t = targetException;
        }
        if (t instanceof CoreException) {
            ILaunchGroup group;
            CoreException ce = (CoreException)t;
            IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(ce.getStatus());
            if (handler != null && (group = DebugUITools.getLaunchGroup(configuration, mode)) != null) {
                DebugUITools.openLaunchConfigurationDialogOnGroup(DebugUIPlugin.getShell(), (IStructuredSelection)new StructuredSelection((Object)configuration), group.getIdentifier(), ce.getStatus());
                return;
            }
            if ((ce.getStatus().getSeverity() & 6) == 0) {
                return;
            }
        }
        DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), DebugUIMessages.DebugUITools_Error_1, DebugUIMessages.DebugUITools_Exception_occurred_during_launch_2, t);
    }

    public static void launchInBackground(final ILaunchConfiguration configuration, final String mode) {
        final IJobManager jobManager = Platform.getJobManager();
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        boolean wait = jobManager.find(ResourcesPlugin.FAMILY_AUTO_BUILD).length > 0 || jobManager.find(ResourcesPlugin.FAMILY_MANUAL_BUILD).length > 0;
        String waitPref = store.getString(IInternalDebugUIConstants.PREF_WAIT_FOR_BUILD);
        if (wait) {
            if (waitPref.equals("prompt")) {
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoCancelQuestion((Shell)DebugUIPlugin.getShell(), (String)DebugUIMessages.DebugUIPlugin_23, (String)DebugUIMessages.DebugUIPlugin_24, null, (boolean)false, (IPreferenceStore)store, (String)IInternalDebugUIConstants.PREF_WAIT_FOR_BUILD);
                switch (dialog.getReturnCode()) {
                    case 1: {
                        return;
                    }
                    case 2: {
                        wait = true;
                        break;
                    }
                    case 3: {
                        wait = false;
                    }
                }
            } else {
                wait = waitPref.equals("always");
            }
        }
        final boolean waitInJob = wait;
        Job job = new Job(DebugUIMessages.DebugUITools_3){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    if (waitInJob) {
                        StringBuffer buffer = new StringBuffer(configuration.getName());
                        buffer.append(DebugUIMessages.DebugUIPlugin_0);
                        ILaunchConfigurationWorkingCopy workingCopy = configuration.copy(buffer.toString());
                        workingCopy.setAttribute(ATTR_LAUNCHING_CONFIG_HANDLE, configuration.getMemento());
                        PendingLaunch pendingLaunch = new PendingLaunch((ILaunchConfiguration)workingCopy, mode, this);
                        DebugPlugin.getDefault().getLaunchManager().addLaunch((ILaunch)pendingLaunch);
                        IJobChangeListener listener = new IJobChangeListener((ILaunch)pendingLaunch){
                            private final /* synthetic */ ILaunch val$pendingLaunch;
                            {
                                this.val$pendingLaunch = iLaunch;
                            }

                            public void sleeping(IJobChangeEvent event) {
                            }

                            public void scheduled(IJobChangeEvent event) {
                            }

                            public void running(IJobChangeEvent event) {
                            }

                            public void done(IJobChangeEvent event) {
                                DebugPlugin.getDefault().getLaunchManager().removeLaunch(this.val$pendingLaunch);
                                this.removeJobChangeListener(this);
                            }

                            public void awake(IJobChangeEvent event) {
                            }

                            public void aboutToRun(IJobChangeEvent event) {
                            }
                        };
                        this.addJobChangeListener(listener);
                        try {
                            jobManager.join(ResourcesPlugin.FAMILY_MANUAL_BUILD, monitor);
                            jobManager.join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
                        }
                        catch (InterruptedException interruptedException) {}
                        DebugPlugin.getDefault().getLaunchManager().removeLaunch((ILaunch)pendingLaunch);
                    }
                    if (!monitor.isCanceled()) {
                        DebugUIPlugin.buildAndLaunch(configuration, mode, monitor);
                    }
                }
                catch (CoreException e) {
                    final IStatus status = e.getStatus();
                    IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(status);
                    if (handler == null) {
                        return status;
                    }
                    final ILaunchGroup group = DebugUITools.getLaunchGroup(configuration, mode);
                    if (group == null) {
                        return status;
                    }
                    Runnable r = new Runnable(){

                        public void run() {
                            DebugUITools.openLaunchConfigurationDialogOnGroup(DebugUIPlugin.getShell(), (IStructuredSelection)new StructuredSelection((Object)configuration), group.getIdentifier(), status);
                        }
                    };
                    DebugUIPlugin.getStandardDisplay().asyncExec(r);
                }
                return Status.OK_STATUS;
            }
        };
        IWorkbench workbench = DebugUIPlugin.getDefault().getWorkbench();
        IProgressService progressService = workbench.getProgressService();
        job.setPriority(10);
        job.setName(DebugUIMessages.DebugUITools_8);
        if (wait) {
            progressService.showInDialog(workbench.getActiveWorkbenchWindow().getShell(), job);
        }
        job.schedule();
    }

    public static String removeAccelerators(String label) {
        String title = label;
        if (title != null) {
            int index = title.indexOf(38);
            if (index == 0) {
                title = title.substring(1);
            } else if (index > 0) {
                if (title.charAt(index - 1) == '(' && title.length() >= index + 3 && title.charAt(index + 2) == ')') {
                    String first = title.substring(0, index - 1);
                    String last = title.substring(index + 3);
                    title = String.valueOf(first) + last;
                } else if (index < title.length() - 1) {
                    String first = title.substring(0, index);
                    String last = title.substring(index + 1);
                    title = String.valueOf(first) + last;
                }
            }
        }
        return title;
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        if (DebugUIPlugin.getDefault().fImageDescriptorRegistry == null) {
            DebugUIPlugin.getDefault().fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return DebugUIPlugin.getDefault().fImageDescriptorRegistry;
    }

    public static ImageDescriptor getImageDescriptor(IConfigurationElement element, String attr) {
        URL iconURL;
        Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
        String iconPath = element.getAttribute(attr);
        if (iconPath != null && (iconURL = FileLocator.find((Bundle)bundle, (IPath)new Path(iconPath), null)) != null) {
            return ImageDescriptor.createFromURL((URL)iconURL);
        }
        return null;
    }

    public static boolean doLaunchConfigurationFiltering(ILaunchConfiguration config) {
        boolean ret = true;
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IInternalDebugUIConstants.PREF_FILTER_LAUNCH_CLOSED)) {
            ret &= new ClosedProjectFilter().select(null, null, config);
        }
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IInternalDebugUIConstants.PREF_FILTER_LAUNCH_DELETED)) {
            ret &= new DeletedProjectFilter().select(null, null, config);
        }
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IInternalDebugUIConstants.PREF_FILTER_WORKING_SETS)) {
            ret &= new WorkingSetsFilter().select(null, null, config);
        }
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IInternalDebugUIConstants.PREF_FILTER_LAUNCH_TYPES)) {
            try {
                ret &= new LaunchConfigurationTypeFilter().select(null, null, config.getType());
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        return ret;
    }

    public static class PendingLaunch
    extends Launch {
        private Job fJob;

        public PendingLaunch(ILaunchConfiguration launchConfiguration, String mode, Job job) {
            super(launchConfiguration, mode, null);
            this.fJob = job;
        }

        public boolean canTerminate() {
            return true;
        }

        public void terminate() throws DebugException {
            this.fJob.cancel();
        }
    }
}

