/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.IInstallConfigurationChangedListener;
import org.eclipse.update.configuration.LocalSystemInfo;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.ui.UpdateLabelProvider;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.parts.DefaultContentProvider;
import org.eclipse.update.internal.ui.parts.SWTUtil;
import org.eclipse.update.internal.ui.wizards.BannerPage;
import org.eclipse.update.internal.ui.wizards.IDynamicPage;
import org.eclipse.update.internal.ui.wizards.TargetSiteDialog;
import org.eclipse.update.operations.IInstallFeatureOperation;

public class TargetPage
extends BannerPage
implements IDynamicPage {
    private static final int FEATURE_NAME_COLUMN = 0;
    private static final int FEATURE_VERSION_COLUMN = 1;
    private static final int FEATURE_SIZE_COLUMN = 2;
    private static final int INSTALLATION_DIRECTORY_COLUMN = 3;
    private float featureNameColumnProcetange = 0.25f;
    private float featureVersionColumnProcetange = 0.25f;
    private float featureSizeColumnProcetange = 0.15f;
    private TableViewer jobViewer;
    private IInstallConfiguration config;
    private ConfigListener configListener;
    private Label requiredSpaceLabel;
    private Label availableSpaceLabel;
    private IInstallFeatureOperation[] jobs;
    private Label installLocation;
    private Button changeLocation;
    static HashSet added;

    public TargetPage(IInstallConfiguration config) {
        super("Target");
        this.setTitle(UpdateUIMessages.InstallWizard_TargetPage_title);
        this.setDescription(UpdateUIMessages.InstallWizard_TargetPage_desc);
        this.config = config;
        UpdateUI.getDefault().getLabelProvider().connect(this);
        this.configListener = new ConfigListener();
    }

    public void setJobs(IInstallFeatureOperation[] jobs) {
        this.jobs = jobs;
    }

    public void dispose() {
        UpdateUI.getDefault().getLabelProvider().disconnect(this);
        super.dispose();
    }

    public Control createContents(Composite parent) {
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        client.setLayout((Layout)layout);
        client.setLayoutData((Object)new GridData(1808));
        Label label = new Label(client, 0);
        label.setText(UpdateUIMessages.InstallWizard_TargetPage_jobsLabel);
        this.createJobViewer(client);
        label = new Label(client, 0);
        label.setText(UpdateUIMessages.InstallWizard_TargetPage_location);
        GridData gd = new GridData(32);
        label.setLayoutData((Object)gd);
        this.installLocation = new Label(client, 0);
        this.installLocation.setText("foo");
        gd = new GridData(768);
        this.installLocation.setLayoutData((Object)gd);
        this.changeLocation = new Button(client, 8);
        this.changeLocation.setText(UpdateUIMessages.InstallWizard_TargetPage_location_change);
        this.changeLocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetPage.this.changeLocationOfFeatures();
            }
        });
        Composite status = new Composite(client, 0);
        gd = new GridData(256);
        gd.horizontalSpan = 3;
        status.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 2;
        status.setLayout((Layout)layout);
        label = new Label(status, 0);
        label.setText(UpdateUIMessages.InstallWizard_TargetPage_requiredSpace);
        this.requiredSpaceLabel = new Label(status, 0);
        this.requiredSpaceLabel.setLayoutData((Object)new GridData(768));
        label = new Label(status, 0);
        label.setText(UpdateUIMessages.InstallWizard_TargetPage_availableSpace);
        this.availableSpaceLabel = new Label(status, 0);
        this.availableSpaceLabel.setLayoutData((Object)new GridData(768));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)client, "org.eclipse.update.ui.MultiTargetPage2");
        Dialog.applyDialogFont((Control)parent);
        return client;
    }

    private void createJobViewer(Composite parent) {
        final Table table = new Table(parent, 68370);
        TableColumn featureNameColumn = new TableColumn(table, 16384, 0);
        featureNameColumn.setText(UpdateUIMessages.TargetPage_FeatureNameColumn);
        featureNameColumn.setWidth(75);
        TableColumn featureVersionColumn = new TableColumn(table, 16384, 1);
        featureVersionColumn.setText(UpdateUIMessages.TargetPage_Feature_Version);
        featureVersionColumn.setWidth(75);
        TableColumn featureSizeColumn = new TableColumn(table, 16384, 2);
        featureSizeColumn.setText(UpdateUIMessages.TargetPage_Feature_Size);
        featureSizeColumn.setWidth(75);
        TableColumn featureLocationColumn = new TableColumn(table, 16384, 3);
        featureLocationColumn.setText(UpdateUIMessages.TargetPage_InstallationDirectoryColumn);
        featureLocationColumn.setWidth(75);
        this.jobViewer = new TableViewer(table);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.widthHint = 150;
        this.jobViewer.getTable().setLayoutData((Object)gd);
        this.jobViewer.setContentProvider((IContentProvider)new JobsContentProvider());
        this.jobViewer.setLabelProvider((IBaseLabelProvider)new JobsLabelProvider());
        this.jobViewer.setSorter((ViewerSorter)new JobViewerSorter());
        this.jobViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TargetPage.this.changeLocationOfFeatures();
            }
        });
        table.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                Menu menu = new Menu((Decorations)TargetPage.this.getShell(), 8);
                MenuItem item = new MenuItem(menu, 8);
                item.setText(UpdateUIMessages.InstallWizard_TargetPage_location_change);
                item.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        TargetPage.this.changeLocationOfFeatures();
                    }
                });
                menu.setLocation(event.x, event.y);
                menu.setVisible(true);
            }
        });
        featureNameColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((JobViewerSorter)TargetPage.this.jobViewer.getSorter()).doSort(0);
                TargetPage.this.jobViewer.refresh();
            }
        });
        featureVersionColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((JobViewerSorter)TargetPage.this.jobViewer.getSorter()).doSort(1);
                TargetPage.this.jobViewer.refresh();
            }
        });
        featureSizeColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((JobViewerSorter)TargetPage.this.jobViewer.getSorter()).doSort(2);
                TargetPage.this.jobViewer.refresh();
            }
        });
        featureLocationColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((JobViewerSorter)TargetPage.this.jobViewer.getSorter()).doSort(3);
                TargetPage.this.jobViewer.refresh();
            }
        });
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = table.getClientArea();
                Point preferredSize = table.computeSize(-1, -1);
                int tableWidth = area.width - 3 * table.getBorderWidth();
                if (preferredSize.y > area.height + table.getHeaderHeight()) {
                    Point vBarSize = table.getVerticalBar().getSize();
                    tableWidth -= vBarSize.x;
                }
                TableColumn featureNameColumn = table.getColumn(0);
                TableColumn featureVersionColumn = table.getColumn(1);
                TableColumn featureSizeColumn = table.getColumn(2);
                TableColumn featureLocationColumn = table.getColumn(3);
                featureNameColumn.setWidth((int)((float)tableWidth * TargetPage.this.featureNameColumnProcetange));
                featureVersionColumn.setWidth((int)((float)tableWidth * TargetPage.this.featureVersionColumnProcetange));
                featureSizeColumn.setWidth((int)((float)tableWidth * TargetPage.this.featureSizeColumnProcetange));
                featureLocationColumn.setWidth(tableWidth - featureNameColumn.getWidth() - featureVersionColumn.getWidth() - featureSizeColumn.getWidth());
                TargetPage.this.featureNameColumnProcetange = (float)featureNameColumn.getWidth() / (float)tableWidth;
                TargetPage.this.featureVersionColumnProcetange = (float)featureVersionColumn.getWidth() / (float)tableWidth;
                TargetPage.this.featureSizeColumnProcetange = (float)featureSizeColumn.getWidth() / (float)tableWidth;
            }
        });
        this.jobViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TargetPage.this.updateStatus();
            }
        });
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.initializeDefaultTargetSites();
            this.jobViewer.setInput((Object)this.jobs);
            if (this.jobViewer.getSelection().isEmpty() && this.jobs.length > 0) {
                this.jobViewer.setSelection((ISelection)new StructuredSelection((Object)this.jobs[0]));
            }
        }
        super.setVisible(visible);
    }

    private void verifyNotEmpty(boolean empty) {
        String errorMessage = null;
        if (empty) {
            errorMessage = UpdateUIMessages.InstallWizard_TargetPage_location_empty;
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(!empty);
    }

    private void updateStatus() {
        IStructuredSelection selectedJobs = (IStructuredSelection)this.jobViewer.getSelection();
        IInstallFeatureOperation selectedJob = (IInstallFeatureOperation)selectedJobs.getFirstElement();
        this.requiredSpaceLabel.setText("");
        this.availableSpaceLabel.setText("");
        this.installLocation.setText("");
        if (selectedJob == null) {
            return;
        }
        IConfiguredSite site = selectedJob.getTargetSite();
        File file = new File(site.getSite().getURL().getFile());
        long available = -1L;
        long required = -1L;
        if (this.areAllTargetSitesSame()) {
            available = LocalSystemInfo.getFreeSpace((File)file);
            required = this.computeRequiredSizeFor(site);
            required += this.computeDownloadSizeFor(site);
            this.installLocation.setText(new File(selectedJob.getTargetSite().getSite().getURL().getFile()).toString());
        }
        if (available == -1L) {
            available = -1L;
        }
        this.requiredSpaceLabel.setText(this.getSizeString(required));
        this.availableSpaceLabel.setText(this.getSizeString(available));
        if (available != -1L && required > available) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
        }
    }

    private boolean areAllTargetSitesSame() {
        IStructuredSelection selectedJobs = (IStructuredSelection)this.jobViewer.getSelection();
        Iterator iterator = selectedJobs.iterator();
        URL site = null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                IInstallFeatureOperation current = (IInstallFeatureOperation)iterator.next();
                if (site != null) {
                    if (site.equals(current.getTargetSite().getSite().getURL())) continue;
                    return false;
                }
                site = current.getTargetSite().getSite().getURL();
            }
            return true;
        }
        return false;
    }

    private String getSizeString(long size) {
        if (size <= 0L) {
            return UpdateUIMessages.InstallWizard_TargetPage_unknownSize;
        }
        double order = 1024.0;
        double sizeInMB = (double)size / order;
        double sizeInGB = (double)size / order / order;
        if (sizeInMB < 1.0) {
            return NLS.bind((String)UpdateUIMessages.InstallWizard_TargetPage_size_KB, (Object)("" + size));
        }
        String pattern = "#.##";
        DecimalFormat formatter = new DecimalFormat(pattern);
        if (sizeInGB < 1.0) {
            return NLS.bind((String)UpdateUIMessages.InstallWizard_TargetPage_size_MB, (Object)formatter.format(sizeInMB));
        }
        return NLS.bind((String)UpdateUIMessages.InstallWizard_TargetPage_size_GB, (Object)formatter.format(sizeInGB));
    }

    private long computeRequiredSizeFor(IConfiguredSite site) {
        long totalSize = 0L;
        int i = 0;
        while (i < this.jobs.length) {
            if (site.equals(this.jobs[i].getTargetSite())) {
                long jobSize = site.getSite().getInstallSizeFor(this.jobs[i].getFeature());
                if (jobSize == -1L) {
                    return -1L;
                }
                totalSize += jobSize;
            }
            ++i;
        }
        return totalSize;
    }

    private long computeDownloadSizeFor(IConfiguredSite site) {
        long totalSize = 0L;
        int i = 0;
        while (i < this.jobs.length) {
            if (site.equals(this.jobs[i].getTargetSite())) {
                long jobSize = site.getSite().getDownloadSizeFor(this.jobs[i].getFeature());
                if (jobSize == -1L) {
                    return -1L;
                }
                totalSize += jobSize;
            }
            ++i;
        }
        return totalSize;
    }

    private void pageChanged() {
        boolean empty = false;
        int i = 0;
        while (this.jobs != null && i < this.jobs.length) {
            if (this.jobs[i].getTargetSite() == null) {
                empty = true;
                break;
            }
            IFeature feature = this.jobs[i].getFeature();
            if (feature.isPatch()) {
                IInstallFeatureOperation patchedFeatureJob = this.findPatchedFeature(feature);
                if (patchedFeatureJob != null && patchedFeatureJob.getTargetSite() != null && !this.jobs[i].getTargetSite().equals(patchedFeatureJob.getTargetSite())) {
                    String msg = NLS.bind((String)UpdateUIMessages.InstallWizard_TargetPage_patchError, (Object[])new String[]{feature.getLabel(), patchedFeatureJob.getFeature().getLabel()});
                    this.setErrorMessage(msg);
                    this.setPageComplete(false);
                    return;
                }
                IFeature patchedFeature = UpdateUtils.getPatchedFeature((IFeature)feature);
                if (patchedFeature != null && !this.jobs[i].getTargetSite().equals(patchedFeature.getSite().getCurrentConfiguredSite())) {
                    String msg = NLS.bind((String)UpdateUIMessages.InstallWizard_TargetPage_patchError2, (Object[])new String[]{feature.getLabel(), patchedFeature.getLabel(), patchedFeature.getSite().getCurrentConfiguredSite().getSite().getURL().getFile()});
                    this.setErrorMessage(msg);
                    this.setPageComplete(false);
                    return;
                }
            }
            ++i;
        }
        this.verifyNotEmpty(empty);
    }

    private boolean getSiteVisibility(IConfiguredSite site, IInstallFeatureOperation job) {
        if (!site.isUpdatable()) {
            return false;
        }
        IConfiguredSite affinitySite = UpdateUtils.getAffinitySite((IInstallConfiguration)this.config, (IFeature)job.getFeature());
        if (affinitySite != null) {
            return site.getSite().equals(affinitySite.getSite());
        }
        if (job.getOldFeature() != null) {
            IConfiguredSite oldSite = UpdateUtils.getSiteWithFeature((IInstallConfiguration)this.config, (String)job.getOldFeature().getVersionedIdentifier().getIdentifier());
            return site == oldSite;
        }
        return true;
    }

    private void initializeDefaultTargetSites() {
        IConfiguredSite mostReceantlyUsedSite = this.getMostReceantlyUsedSite();
        int i = 0;
        while (i < this.jobs.length) {
            if (this.jobs[i].getTargetSite() == null) {
                IConfiguredSite affinitySite = UpdateUtils.getAffinitySite((IInstallConfiguration)this.config, (IFeature)this.jobs[i].getFeature());
                if (affinitySite != null) {
                    this.jobs[i].setTargetSite(affinitySite);
                } else {
                    IConfiguredSite defaultSite = UpdateUtils.getDefaultTargetSite((IInstallConfiguration)this.config, (IInstallFeatureOperation)this.jobs[i], (boolean)false);
                    if (defaultSite != null) {
                        this.jobs[i].setTargetSite(defaultSite);
                    } else if (mostReceantlyUsedSite != null) {
                        this.jobs[i].setTargetSite(mostReceantlyUsedSite);
                    } else {
                        this.jobs[i].setTargetSite(this.getFirstTargetSite(this.jobs[i]));
                    }
                }
            }
            ++i;
        }
    }

    private IConfiguredSite getMostReceantlyUsedSite() {
        IDialogSettings master = UpdateUI.getDefault().getDialogSettings();
        IDialogSettings section = master.getSection("mostReceantlyUsedSiteURL");
        if (section == null) {
            return null;
        }
        String mostReceantlyUsedSiteURLString = section.get("mostReceantlyUsedSiteURL");
        if (mostReceantlyUsedSiteURLString == null) {
            return null;
        }
        URL mostReceantlyUsedSiteURL = null;
        try {
            mostReceantlyUsedSiteURL = new URL(mostReceantlyUsedSiteURLString);
        }
        catch (MalformedURLException mue) {
            UpdateCore.log((String)"Url format is wrong for the mostReceantlyUsedSiteURL in preferences", (Throwable)mue);
            mue.printStackTrace();
            return null;
        }
        IConfiguredSite[] sites = this.config.getConfiguredSites();
        int i = 0;
        while (i < sites.length) {
            IConfiguredSite configuredSite = sites[i];
            if (mostReceantlyUsedSiteURL.equals(configuredSite.getSite().getURL())) {
                return configuredSite;
            }
            ++i;
        }
        return null;
    }

    private IConfiguredSite getFirstTargetSite(IInstallFeatureOperation job) {
        IConfiguredSite[] sites = this.config.getConfiguredSites();
        int i = 0;
        while (i < sites.length) {
            IConfiguredSite csite = sites[i];
            if (this.getSiteVisibility(csite, job)) {
                return csite;
            }
            ++i;
        }
        return null;
    }

    public IInstallFeatureOperation findPatchedFeature(IFeature patch) {
        int i = 0;
        while (i < this.jobs.length) {
            IFeature target = this.jobs[i].getFeature();
            if (!target.equals(patch) && UpdateUtils.isPatch((IFeature)target, (IFeature)patch)) {
                return this.jobs[i];
            }
            ++i;
        }
        return null;
    }

    void removeAddedSites() {
        if (added != null) {
            Iterator it = added.iterator();
            while (it.hasNext()) {
                this.config.removeConfiguredSite((IConfiguredSite)it.next());
            }
            added.clear();
        }
    }

    public boolean isPageComplete() {
        int i = 0;
        while (this.jobs != null && i < this.jobs.length) {
            if (this.jobs[i].getTargetSite() == null) {
                return false;
            }
            ++i;
        }
        return super.isPageComplete();
    }

    private IInstallFeatureOperation[] toJobArray(Iterator selectedJobs) {
        if (selectedJobs == null) {
            return new IInstallFeatureOperation[0];
        }
        ArrayList result = new ArrayList();
        while (selectedJobs.hasNext()) {
            result.add(selectedJobs.next());
        }
        return result.toArray(new IInstallFeatureOperation[result.size()]);
    }

    private void changeLocationOfFeatures() {
        IStructuredSelection selection = (IStructuredSelection)this.jobViewer.getSelection();
        if (selection == null) {
            return;
        }
        Iterator selectedJob = selection.iterator();
        if (selectedJob == null) {
            return;
        }
        TargetSiteDialog dialog = new TargetSiteDialog(this.getShell(), this.config, this.toJobArray(selection.iterator()), this.configListener);
        dialog.create();
        SWTUtil.setDialogSize(dialog, 400, 300);
        dialog.getShell().setText(UpdateUIMessages.SitePage_new);
        if (dialog.open() == 0) {
            this.pageChanged();
            this.jobViewer.refresh();
            this.updateStatus();
        }
    }

    class JobsContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        JobsContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return TargetPage.this.jobs;
        }
    }

    class JobsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        JobsLabelProvider() {
        }

        public Image getColumnImage(Object obj, int col) {
            if (col > 0) {
                return null;
            }
            UpdateLabelProvider provider = UpdateUI.getDefault().getLabelProvider();
            IInstallFeatureOperation job = (IInstallFeatureOperation)obj;
            ImageDescriptor base = job.getFeature().isPatch() ? UpdateUIImages.DESC_EFIX_OBJ : UpdateUIImages.DESC_FEATURE_OBJ;
            int flags = 0;
            if (job.getTargetSite() == null) {
                flags = 1;
            }
            return provider.get(base, flags);
        }

        public String getColumnText(Object obj, int col) {
            IFeature feature = ((IInstallFeatureOperation)obj).getFeature();
            ISite site = ((IInstallFeatureOperation)obj).getTargetSite().getSite();
            if (col == 0) {
                return feature.getLabel();
            }
            if (col == 1) {
                return feature.getVersionedIdentifier().getVersion().toString();
            }
            if (col == 2) {
                long requiredSpace = site.getDownloadSizeFor(feature) + site.getInstallSizeFor(feature);
                return TargetPage.this.getSizeString(requiredSpace);
            }
            if (col == 3) {
                return site.getURL().getFile().toString();
            }
            return null;
        }
    }

    class JobViewerSorter
    extends ViewerSorter {
        private static final int ASCENDING = 0;
        private static final int DESCENDING = 1;
        private int column;
        private int direction;

        JobViewerSorter() {
        }

        public void doSort(int column) {
            if (column == this.column) {
                this.direction = 1 - this.direction;
            } else {
                this.column = column;
                this.direction = 0;
            }
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            int rc = 0;
            IFeature feature1 = ((IInstallFeatureOperation)o1).getFeature();
            IFeature feature2 = ((IInstallFeatureOperation)o2).getFeature();
            String featureName1 = feature1.getLabel();
            String featureName2 = feature2.getLabel();
            String featureId1 = feature1.getVersionedIdentifier().getVersion().toString();
            String featureId2 = feature2.getVersionedIdentifier().getVersion().toString();
            String installationDirectory1 = ((IInstallFeatureOperation)o1).getTargetSite().getSite().getURL().getFile().toString();
            String installationDirectory2 = ((IInstallFeatureOperation)o2).getTargetSite().getSite().getURL().getFile().toString();
            switch (this.column) {
                case 0: {
                    rc = this.collator.compare(featureName1, featureName2);
                    break;
                }
                case 1: {
                    rc = this.collator.compare(featureId1, featureId2);
                    break;
                }
                case 3: {
                    rc = this.collator.compare(installationDirectory1, installationDirectory2);
                }
            }
            if (this.direction == 1) {
                rc = -rc;
            }
            return rc;
        }
    }

    class ConfigListener
    implements IInstallConfigurationChangedListener {
        ConfigListener() {
        }

        public void installSiteAdded(IConfiguredSite csite) {
            int i = 0;
            while (TargetPage.this.jobs != null && i < TargetPage.this.jobs.length) {
                if (TargetPage.this.jobs[i].getTargetSite() == null && TargetPage.this.getSiteVisibility(csite, TargetPage.this.jobs[i])) {
                    TargetPage.this.jobs[i].setTargetSite(csite);
                }
                ++i;
            }
            TargetPage.this.jobViewer.refresh();
        }

        public void installSiteRemoved(IConfiguredSite csite) {
            boolean refreshJobs = false;
            int i = 0;
            while (TargetPage.this.jobs != null && i < TargetPage.this.jobs.length) {
                if (TargetPage.this.jobs[i].getTargetSite() == csite) {
                    TargetPage.this.jobs[i].setTargetSite(null);
                    refreshJobs = true;
                }
                ++i;
            }
            TargetPage.this.pageChanged();
            TargetPage.this.jobViewer.refresh();
            if (refreshJobs) {
                TargetPage.this.jobViewer.getControl().setFocus();
            }
        }
    }
}

