/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.jdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.ui.search.OccurrencesSearchQuery;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;

public abstract class FindOccurrencesEngine {
    private IOccurrencesFinder fFinder;

    protected FindOccurrencesEngine(IOccurrencesFinder finder) {
        this.fFinder = finder;
    }

    public static FindOccurrencesEngine create(IJavaElement root, IOccurrencesFinder finder) {
        if (root == null || finder == null) {
            return null;
        }
        ICompilationUnit unit = (ICompilationUnit)root.getAncestor(5);
        if (unit != null) {
            return new FindOccurencesCUEngine(unit, finder);
        }
        IClassFile cf = (IClassFile)root.getAncestor(6);
        if (cf != null) {
            return new FindOccurencesClassFileEngine(cf, finder);
        }
        return null;
    }

    protected abstract CompilationUnit createAST();

    protected abstract IJavaElement getInput();

    protected abstract ISourceReference getSourceReference();

    protected IOccurrencesFinder getOccurrencesFinder() {
        return this.fFinder;
    }

    public String run(int offset, int length) throws JavaModelException {
        ISourceReference sr = this.getSourceReference();
        if (sr.getSourceRange() == null) {
            return SearchMessages.FindOccurrencesEngine_noSource_text;
        }
        CompilationUnit root = this.createAST();
        if (root == null) {
            return SearchMessages.FindOccurrencesEngine_cannotParse_text;
        }
        String message = this.fFinder.initialize(root, offset, length);
        if (message != null) {
            return message;
        }
        Document document = new Document(this.getSourceReference().getSource());
        this.performNewSearch(this.fFinder, (IDocument)document, this.getInput());
        return null;
    }

    private void performNewSearch(IOccurrencesFinder finder, IDocument document, IJavaElement element) {
        NewSearchUI.runQueryInBackground((ISearchQuery)new OccurrencesSearchQuery(finder, document, element));
    }

    private static class FindOccurencesClassFileEngine
    extends FindOccurrencesEngine {
        private IClassFile fClassFile;

        public FindOccurencesClassFileEngine(IClassFile file, IOccurrencesFinder finder) {
            super(finder);
            this.fClassFile = file;
        }

        protected CompilationUnit createAST() {
            return JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)this.fClassFile, ASTProvider.WAIT_YES, null);
        }

        protected IJavaElement getInput() {
            return this.fClassFile;
        }

        protected ISourceReference getSourceReference() {
            return this.fClassFile;
        }
    }

    private static class FindOccurencesCUEngine
    extends FindOccurrencesEngine {
        private ICompilationUnit fCUnit;

        public FindOccurencesCUEngine(ICompilationUnit unit, IOccurrencesFinder finder) {
            super(finder);
            this.fCUnit = unit;
        }

        protected CompilationUnit createAST() {
            return JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)this.fCUnit, ASTProvider.WAIT_YES, null);
        }

        protected IJavaElement getInput() {
            return this.fCUnit;
        }

        protected ISourceReference getSourceReference() {
            return this.fCUnit;
        }
    }
}

