/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.TypedSource;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgEnablementPolicy;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaElementTransfer;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.TypedSourceTransfer;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ResourceTransfer;

public class CopyToClipboardAction
extends SelectionDispatchAction {
    private final Clipboard fClipboard;
    private SelectionDispatchAction fPasteAction;
    private boolean fAutoRepeatOnFailure = false;

    public CopyToClipboardAction(IWorkbenchSite site, Clipboard clipboard, SelectionDispatchAction pasteAction) {
        super(site);
        this.setText(ReorgMessages.CopyToClipboardAction_0);
        this.setDescription(ReorgMessages.CopyToClipboardAction_1);
        Assert.isNotNull((Object)clipboard);
        this.fClipboard = clipboard;
        this.fPasteAction = pasteAction;
        ISharedImages workbenchImages = CopyToClipboardAction.getWorkbenchSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.update(this.getSelection());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.copy_action");
    }

    public void setAutoRepeatOnFailure(boolean autorepeatOnFailure) {
        this.fAutoRepeatOnFailure = autorepeatOnFailure;
    }

    private static ISharedImages getWorkbenchSharedImages() {
        return JavaPlugin.getDefault().getWorkbench().getSharedImages();
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            List elements = selection.toList();
            IResource[] resources = ReorgUtils.getResources(elements);
            IJavaElement[] javaElements = ReorgUtils.getJavaElements(elements);
            if (elements.size() != resources.length + javaElements.length) {
                this.setEnabled(false);
            } else {
                this.setEnabled(this.canEnable(resources, javaElements));
            }
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection selection) {
        try {
            List elements = selection.toList();
            IResource[] resources = ReorgUtils.getResources(elements);
            IJavaElement[] javaElements = ReorgUtils.getJavaElements(elements);
            if (elements.size() == resources.length + javaElements.length && this.canEnable(resources, javaElements)) {
                this.doRun(resources, javaElements);
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), ReorgMessages.CopyToClipboardAction_2, ReorgMessages.CopyToClipboardAction_3);
        }
    }

    private void doRun(IResource[] resources, IJavaElement[] javaElements) throws CoreException {
        new ClipboardCopier(resources, javaElements, this.fClipboard, this.getShell(), this.fAutoRepeatOnFailure).copyToClipboard();
        if (this.fPasteAction != null && this.fPasteAction.getSelection() != null) {
            this.fPasteAction.update(this.fPasteAction.getSelection());
        }
    }

    private boolean canEnable(IResource[] resources, IJavaElement[] javaElements) throws JavaModelException {
        return new CopyToClipboardEnablementPolicy(resources, javaElements).canEnable();
    }

    private static class ClipboardCopier {
        private final boolean fAutoRepeatOnFailure;
        private final IResource[] fResources;
        private final IJavaElement[] fJavaElements;
        private final Clipboard fClipboard;
        private final Shell fShell;
        private final ILabelProvider fLabelProvider;

        private ClipboardCopier(IResource[] resources, IJavaElement[] javaElements, Clipboard clipboard, Shell shell, boolean autoRepeatOnFailure) {
            Assert.isNotNull((Object)resources);
            Assert.isNotNull((Object)javaElements);
            Assert.isNotNull((Object)clipboard);
            Assert.isNotNull((Object)shell);
            this.fResources = resources;
            this.fJavaElements = javaElements;
            this.fClipboard = clipboard;
            this.fShell = shell;
            this.fLabelProvider = ClipboardCopier.createLabelProvider();
            this.fAutoRepeatOnFailure = autoRepeatOnFailure;
        }

        public void copyToClipboard() throws CoreException {
            HashSet fileNames = new HashSet(this.fResources.length + this.fJavaElements.length);
            StringBuffer namesBuf = new StringBuffer();
            this.processResources(fileNames, namesBuf);
            this.processJavaElements(fileNames, namesBuf);
            IType[] mainTypes = ReorgUtils.getMainTypes(this.fJavaElements);
            ICompilationUnit[] cusOfMainTypes = ReorgUtils.getCompilationUnits((IJavaElement[])mainTypes);
            IResource[] resourcesOfMainTypes = ReorgUtils.getResources((IJavaElement[])cusOfMainTypes);
            ClipboardCopier.addFileNames(fileNames, resourcesOfMainTypes);
            IResource[] cuResources = ReorgUtils.getResources(ClipboardCopier.getCompilationUnits(this.fJavaElements));
            ClipboardCopier.addFileNames(fileNames, cuResources);
            IResource[] resourcesForClipboard = ReorgUtils.union(this.fResources, ReorgUtils.union(cuResources, resourcesOfMainTypes));
            IJavaElement[] javaElementsForClipboard = ReorgUtils.union(this.fJavaElements, (IJavaElement[])cusOfMainTypes);
            TypedSource[] typedSources = TypedSource.createTypedSources(javaElementsForClipboard);
            String[] fileNameArray = fileNames.toArray(new String[fileNames.size()]);
            this.copyToClipboard(resourcesForClipboard, fileNameArray, namesBuf.toString(), javaElementsForClipboard, typedSources, 0);
        }

        private static IJavaElement[] getCompilationUnits(IJavaElement[] javaElements) {
            List cus = ReorgUtils.getElementsOfType(javaElements, 5);
            return cus.toArray(new ICompilationUnit[cus.size()]);
        }

        private void processResources(Set fileNames, StringBuffer namesBuf) {
            int i = 0;
            while (i < this.fResources.length) {
                IResource resource = this.fResources[i];
                ClipboardCopier.addFileName(fileNames, resource);
                if (i > 0) {
                    namesBuf.append('\n');
                }
                namesBuf.append(this.getName(resource));
                ++i;
            }
        }

        private void processJavaElements(Set fileNames, StringBuffer namesBuf) {
            int i = 0;
            while (i < this.fJavaElements.length) {
                IJavaElement element = this.fJavaElements[i];
                switch (element.getElementType()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        ClipboardCopier.addFileName(fileNames, ReorgUtils.getResource(element));
                        break;
                    }
                }
                if (this.fResources.length > 0 || i > 0) {
                    namesBuf.append('\n');
                }
                namesBuf.append(this.getName(element));
                ++i;
            }
        }

        private static void addFileNames(Set fileName, IResource[] resources) {
            int i = 0;
            while (i < resources.length) {
                ClipboardCopier.addFileName(fileName, resources[i]);
                ++i;
            }
        }

        private static void addFileName(Set fileName, IResource resource) {
            if (resource == null) {
                return;
            }
            IPath location = resource.getLocation();
            if (location != null) {
                fileName.add(location.toOSString());
            }
        }

        private void copyToClipboard(IResource[] resources, String[] fileNames, String names, IJavaElement[] javaElements, TypedSource[] typedSources, int repeat) {
            block6: {
                try {
                    this.fClipboard.setContents(ClipboardCopier.createDataArray(resources, javaElements, fileNames, names, typedSources), ClipboardCopier.createDataTypeArray(resources, javaElements, fileNames, typedSources));
                }
                catch (SWTError e) {
                    if (e.code != 2002 || repeat >= 10) {
                        throw e;
                    }
                    if (this.fAutoRepeatOnFailure) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (!this.fAutoRepeatOnFailure && !MessageDialog.openQuestion((Shell)this.fShell, (String)ReorgMessages.CopyToClipboardAction_4, (String)ReorgMessages.CopyToClipboardAction_5)) break block6;
                    this.copyToClipboard(resources, fileNames, names, javaElements, typedSources, repeat + 1);
                }
            }
        }

        private static Transfer[] createDataTypeArray(IResource[] resources, IJavaElement[] javaElements, String[] fileNames, TypedSource[] typedSources) {
            ArrayList<Object> result = new ArrayList<Object>(4);
            if (resources.length != 0) {
                result.add(ResourceTransfer.getInstance());
            }
            if (javaElements.length != 0) {
                result.add((Object)JavaElementTransfer.getInstance());
            }
            if (fileNames.length != 0) {
                result.add(FileTransfer.getInstance());
            }
            if (typedSources.length != 0) {
                result.add((Object)TypedSourceTransfer.getInstance());
            }
            result.add(TextTransfer.getInstance());
            return result.toArray(new Transfer[result.size()]);
        }

        private static Object[] createDataArray(IResource[] resources, IJavaElement[] javaElements, String[] fileNames, String names, TypedSource[] typedSources) {
            ArrayList<Object> result = new ArrayList<Object>(4);
            if (resources.length != 0) {
                result.add(resources);
            }
            if (javaElements.length != 0) {
                result.add(javaElements);
            }
            if (fileNames.length != 0) {
                result.add(fileNames);
            }
            if (typedSources.length != 0) {
                result.add(typedSources);
            }
            result.add(names);
            return result.toArray();
        }

        private static ILabelProvider createLabelProvider() {
            return new JavaElementLabelProvider(546);
        }

        private String getName(IResource resource) {
            return this.fLabelProvider.getText((Object)resource);
        }

        private String getName(IJavaElement javaElement) {
            return this.fLabelProvider.getText((Object)javaElement);
        }
    }

    private static class CopyToClipboardEnablementPolicy
    implements IReorgEnablementPolicy {
        private final IResource[] fResources;
        private final IJavaElement[] fJavaElements;

        public CopyToClipboardEnablementPolicy(IResource[] resources, IJavaElement[] javaElements) {
            Assert.isNotNull((Object)resources);
            Assert.isNotNull((Object)javaElements);
            this.fResources = resources;
            this.fJavaElements = javaElements;
        }

        public boolean canEnable() throws JavaModelException {
            if (this.fResources.length + this.fJavaElements.length == 0) {
                return false;
            }
            if (this.hasProjects() && this.hasNonProjects()) {
                return false;
            }
            if (!this.canCopyAllToClipboard()) {
                return false;
            }
            return new ParentChecker(this.fResources, this.fJavaElements).haveCommonParent();
        }

        private boolean canCopyAllToClipboard() throws JavaModelException {
            int i = 0;
            while (i < this.fResources.length) {
                if (!CopyToClipboardEnablementPolicy.canCopyToClipboard(this.fResources[i])) {
                    return false;
                }
                ++i;
            }
            i = 0;
            while (i < this.fJavaElements.length) {
                if (!CopyToClipboardEnablementPolicy.canCopyToClipboard(this.fJavaElements[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private static boolean canCopyToClipboard(IJavaElement element) throws JavaModelException {
            if (element == null || !element.exists()) {
                return false;
            }
            return !JavaElementUtil.isDefaultPackage(element);
        }

        private static boolean canCopyToClipboard(IResource resource) {
            return resource != null && resource.exists() && !resource.isPhantom() && resource.getType() != 8;
        }

        private boolean hasProjects() {
            int i = 0;
            while (i < this.fResources.length) {
                if (ReorgUtils.isProject(this.fResources[i])) {
                    return true;
                }
                ++i;
            }
            i = 0;
            while (i < this.fJavaElements.length) {
                if (ReorgUtils.isProject(this.fJavaElements[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean hasNonProjects() {
            int i = 0;
            while (i < this.fResources.length) {
                if (!ReorgUtils.isProject(this.fResources[i])) {
                    return true;
                }
                ++i;
            }
            i = 0;
            while (i < this.fJavaElements.length) {
                if (!ReorgUtils.isProject(this.fJavaElements[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

