/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.nls;

import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaPackageCompletionProcessor;
import org.eclipse.jdt.internal.ui.refactoring.nls.SourceChangeListener;
import org.eclipse.jdt.internal.ui.refactoring.nls.SourceFirstPackageSelectionDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonStatusDialogField;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

class PackageFragmentSelection
extends StringButtonStatusDialogField
implements SourceChangeListener {
    private final SourceFirstPackageSelectionDialogField fDialogField;
    private JavaPackageCompletionProcessor fCurrPackageCompletionProcessor;
    private IDialogFieldListener fUpdateListener;

    public PackageFragmentSelection(SourceFirstPackageSelectionDialogField field, String packageLabel, String browseLabel, String statusHint, IStringButtonAdapter adapter) {
        super(adapter);
        this.fDialogField = field;
        this.setLabelText(packageLabel);
        this.setButtonLabel(browseLabel);
        this.setStatusWidthHint(statusHint);
        this.fCurrPackageCompletionProcessor = new JavaPackageCompletionProcessor();
    }

    public void setUpdateListener(IDialogFieldListener updateListener) {
        this.fUpdateListener = updateListener;
    }

    public Control[] doFillIntoGrid(Composite parent, int nColumns, int textWidth) {
        Control[] res = super.doFillIntoGrid(parent, nColumns);
        Text text = this.getTextControl(null);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PackageFragmentSelection.this.updateListener();
            }
        });
        LayoutUtil.setWidthHint((Control)text, textWidth);
        LayoutUtil.setHorizontalGrabbing((Control)text);
        ControlContentAssistHelper.createTextContentAssistant(text, this.fCurrPackageCompletionProcessor);
        TextFieldNavigationHandler.install(text);
        return res;
    }

    public void setPackageFragment(IPackageFragment fragment) {
        if (fragment != null) {
            this.setText(fragment.getElementName());
        }
        this.updateListener();
    }

    private void updateListener() {
        if (this.fUpdateListener != null) {
            this.fUpdateListener.dialogFieldChanged(this);
        }
    }

    public IPackageFragment getPackageFragment() {
        return this.calculateFragment(this.fDialogField.getSelectedFragmentRoot());
    }

    private IPackageFragment calculateFragment(IPackageFragmentRoot root) {
        if (root == null) {
            return null;
        }
        return root.getPackageFragment(this.getText());
    }

    public void sourceRootChanged(IPackageFragmentRoot newRoot) {
        this.fCurrPackageCompletionProcessor.setPackageFragmentRoot(newRoot);
        this.setPackageFragment(this.calculateFragment(newRoot));
    }
}

