/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.navigator;

import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.INavigatorContentService;

public abstract class NonEssentialElementsFilter
extends ViewerFilter {
    private static final String JAVA_EXTENSION_ID = "org.eclipse.jdt.java.ui.javaContent";
    private boolean isStateModelInitialized = false;
    private IExtensionStateModel fStateModel = null;
    private INavigatorContentService fContentService;
    private ViewerFilter fDelegateFilter;

    protected NonEssentialElementsFilter(ViewerFilter delegateFilter) {
        this.fDelegateFilter = delegateFilter;
    }

    public boolean select(Viewer viewer, Object parent, Object element) {
        if (!this.isStateModelInitialized) {
            this.initStateModel(viewer);
        }
        if (this.fContentService == null || this.fStateModel == null) {
            return true;
        }
        if (element instanceof IPackageFragment && this.isApplicable()) {
            boolean isFlatLayout = this.fStateModel.getBooleanProperty("isLayoutFlat");
            try {
                IPackageFragment fragment = (IPackageFragment)element;
                if (!isFlatLayout && !fragment.isDefaultPackage() && fragment.hasSubpackages()) {
                    return true;
                }
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        return this.doSelect(viewer, parent, element);
    }

    protected boolean doSelect(Viewer viewer, Object parent, Object element) {
        return this.fDelegateFilter.select(viewer, parent, element);
    }

    private boolean isApplicable() {
        return this.fContentService != null && this.fContentService.isVisible(JAVA_EXTENSION_ID) && this.fContentService.isActive(JAVA_EXTENSION_ID);
    }

    private synchronized void initStateModel(Viewer viewer) {
        if (!this.isStateModelInitialized && viewer instanceof CommonViewer) {
            CommonViewer commonViewer = (CommonViewer)viewer;
            this.fContentService = commonViewer.getNavigatorContentService();
            this.fStateModel = this.fContentService.findStateModel(JAVA_EXTENSION_ID);
            this.isStateModelInitialized = true;
        }
    }
}

