/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.Assert;

final class CompilationUnitCompletion
extends CompletionRequestor {
    private ICompilationUnit fUnit;
    private List fLocalVariables = new ArrayList();
    private Map fLocalTypes = new HashMap();
    private boolean fError;

    CompilationUnitCompletion(ICompilationUnit unit) {
        this.reset(unit);
        this.setIgnored(1, true);
        this.setIgnored(2, true);
        this.setIgnored(3, true);
        this.setIgnored(4, true);
        this.setIgnored(7, true);
        this.setIgnored(12, true);
        this.setIgnored(6, true);
        this.setIgnored(8, true);
        this.setIgnored(11, true);
        this.setIgnored(10, true);
        this.setIgnored(9, true);
    }

    private void reset(ICompilationUnit unit) {
        this.fUnit = unit;
        this.fLocalVariables.clear();
        this.fLocalTypes.clear();
        if (this.fUnit != null) {
            try {
                IType[] cuTypes = this.fUnit.getAllTypes();
                int i = 0;
                while (i < cuTypes.length) {
                    String fqn = cuTypes[i].getFullyQualifiedName();
                    String sig = Signature.createTypeSignature((String)fqn, (boolean)true);
                    this.fLocalTypes.put(sig, cuTypes[i].getElementName());
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        this.fError = false;
    }

    public void accept(CompletionProposal proposal) {
        String name = String.valueOf(proposal.getCompletion());
        String signature = String.valueOf(proposal.getSignature());
        switch (proposal.getKind()) {
            case 5: {
                this.fLocalVariables.add(new LocalVariable(name, signature));
                break;
            }
        }
    }

    public void completionFailure(IProblem problem) {
        this.fError = true;
    }

    public boolean hasErrors() {
        return this.fError;
    }

    public boolean existsLocalName(String name) {
        for (LocalVariable localVariable : this.fLocalVariables) {
            if (!localVariable.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public String[] getLocalVariableNames() {
        String[] names = new String[this.fLocalVariables.size()];
        int i = 0;
        ListIterator iterator = this.fLocalVariables.listIterator(this.fLocalVariables.size());
        while (iterator.hasPrevious()) {
            LocalVariable localVariable = (LocalVariable)iterator.previous();
            names[i++] = localVariable.getName();
        }
        return names;
    }

    public LocalVariable[] findLocalArrays() {
        ArrayList<LocalVariable> arrays = new ArrayList<LocalVariable>();
        ListIterator iterator = this.fLocalVariables.listIterator(this.fLocalVariables.size());
        while (iterator.hasPrevious()) {
            LocalVariable localVariable = (LocalVariable)iterator.previous();
            if (!localVariable.isArray()) continue;
            arrays.add(localVariable);
        }
        return arrays.toArray(new LocalVariable[arrays.size()]);
    }

    public LocalVariable[] findLocalCollections() {
        ArrayList<LocalVariable> collections = new ArrayList<LocalVariable>();
        ListIterator iterator = this.fLocalVariables.listIterator(this.fLocalVariables.size());
        while (iterator.hasPrevious()) {
            LocalVariable localVariable = (LocalVariable)iterator.previous();
            if (!localVariable.isCollection()) continue;
            collections.add(localVariable);
        }
        return collections.toArray(new LocalVariable[collections.size()]);
    }

    public LocalVariable[] findLocalIterables() {
        ArrayList<LocalVariable> iterables = new ArrayList<LocalVariable>();
        ListIterator iterator = this.fLocalVariables.listIterator(this.fLocalVariables.size());
        while (iterator.hasPrevious()) {
            LocalVariable localVariable = (LocalVariable)iterator.previous();
            if (!localVariable.isArray() && !localVariable.isIterable()) continue;
            iterables.add(localVariable);
        }
        return iterables.toArray(new LocalVariable[iterables.size()]);
    }

    public final class LocalVariable {
        private static final int UNKNOWN = 0;
        private static final int NONE = 0;
        private static final int ARRAY = 1;
        private static final int COLLECTION = 2;
        private static final int ITERABLE = 4;
        private final String name;
        private final String signature;
        private int fType = 0;
        private int fChecked = 0;
        private String[] fMemberTypes;

        private LocalVariable(String name, String signature) {
            this.name = name;
            this.signature = signature;
        }

        public String getName() {
            return this.name;
        }

        public boolean isArray() {
            if (this.fType == 0 && (this.fChecked & 1) == 0 && Signature.getTypeSignatureKind((String)this.signature) == 4) {
                this.fType = 1;
            }
            this.fChecked |= 1;
            return this.fType == 1;
        }

        public boolean isCollection() {
            if ((this.fType == 0 || this.fType == 4) && (this.fChecked & 2) == 0 && this.isImplementorOf("java.util.Collection")) {
                this.fType = 2;
            }
            this.fChecked |= 2;
            return this.fType == 2;
        }

        public boolean isIterable() {
            if (this.fType == 0 && (this.fChecked & 4) == 0 && this.isImplementorOf("java.lang.Iterable")) {
                this.fType = 4;
            }
            this.fChecked |= 4;
            return this.fType == 4 || this.fType == 2;
        }

        private boolean isImplementorOf(String interfaceName) {
            IType interfaze;
            IType implementor;
            block8: {
                IJavaProject project;
                block7: {
                    String implementorName = SignatureUtil.stripSignatureToFQN(this.signature);
                    if (implementorName.length() == 0) {
                        return false;
                    }
                    if (implementorName.equals(interfaceName)) {
                        return true;
                    }
                    if (CompilationUnitCompletion.this.fUnit == null) {
                        return false;
                    }
                    project = CompilationUnitCompletion.this.fUnit.getJavaProject();
                    try {
                        implementor = project.findType(implementorName);
                        if (implementor != null) break block7;
                        return false;
                    }
                    catch (JavaModelException javaModelException) {
                        return false;
                    }
                }
                interfaze = project.findType(interfaceName);
                if (interfaze != null) break block8;
                return false;
            }
            ITypeHierarchy hierarchy = implementor.newSupertypeHierarchy(null);
            return hierarchy.contains(interfaze);
        }

        public String getMemberTypeSignature() {
            return this.getMemberTypeSignatures()[0];
        }

        public String[] getMemberTypeSignatures() {
            if (this.isArray()) {
                return new String[]{Signature.createArraySignature((String)Signature.getElementType((String)this.signature), (int)(Signature.getArrayCount((String)this.signature) - 1))};
            }
            if (this.fType == 4 || this.fType == 2) {
                if (this.fMemberTypes == null) {
                    try {
                        TypeParameterResolver util = new TypeParameterResolver(this);
                        this.fMemberTypes = util.computeBinding("java.lang.Iterable", 0);
                    }
                    catch (JavaModelException javaModelException) {
                        this.fMemberTypes = new String[0];
                    }
                }
                if (this.fMemberTypes.length > 0) {
                    return this.fMemberTypes;
                }
            }
            return new String[]{Signature.createTypeSignature((String)"java.lang.Object", (boolean)true)};
        }

        public String[] getMemberTypeNames() {
            String[] signatures = this.getMemberTypeSignatures();
            String[] names = new String[signatures.length];
            int i = 0;
            while (i < signatures.length) {
                String sig = signatures[i];
                String local = (String)CompilationUnitCompletion.this.fLocalTypes.get(Signature.getElementType((String)sig));
                int dim = Signature.getArrayCount((String)sig);
                if (local != null && dim > 0) {
                    StringBuffer array = new StringBuffer(local);
                    int j = 0;
                    while (j < dim) {
                        array.append("[]");
                        ++j;
                    }
                    local = array.toString();
                }
                names[i] = local != null ? local : Signature.getSimpleName((String)Signature.getSignatureSimpleName((String)sig));
                ++i;
            }
            return names;
        }

        public String toString() {
            String type;
            switch (this.fType) {
                case 4: {
                    type = "ITERABLE";
                    break;
                }
                case 2: {
                    type = "COLLECTION";
                    break;
                }
                case 1: {
                    type = "ARRAY";
                    break;
                }
                default: {
                    type = "UNKNOWN";
                }
            }
            return "LocalVariable [name=\"" + this.name + "\" signature=\"" + this.signature + "\" type=\"" + type + "\" member=\"" + this.getMemberTypeSignature() + "\"]";
        }
    }

    private final class TypeParameterResolver {
        private static final String OBJECT_SIGNATURE = "Ljava.lang.Object;";
        private final ITypeHierarchy fHierarchy;
        private final LocalVariable fVariable;
        private final IType fType;
        private final List fBounds = new ArrayList();

        public TypeParameterResolver(LocalVariable variable) throws JavaModelException {
            String typeName = SignatureUtil.stripSignatureToFQN(variable.signature);
            IJavaProject project = CompilationUnitCompletion.this.fUnit.getJavaProject();
            this.fType = project.findType(typeName);
            this.fHierarchy = this.fType.newSupertypeHierarchy(null);
            this.fVariable = variable;
        }

        public String[] computeBinding(String superType, int index) throws JavaModelException {
            IJavaProject project = CompilationUnitCompletion.this.fUnit.getJavaProject();
            return this.computeBinding(project.findType(superType), index);
        }

        public String[] computeBinding(IType superType, int index) throws JavaModelException {
            this.initBounds();
            this.computeTypeParameterBinding(superType, index);
            return this.fBounds.toArray(new String[this.fBounds.size()]);
        }

        private void computeTypeParameterBinding(IType superType, int index) throws JavaModelException {
            int nParameters = superType.getTypeParameters().length;
            Assert.isTrue((nParameters > index ? 1 : 0) != 0);
            IType[] subTypes = this.fHierarchy.getSubtypes(superType);
            if (subTypes.length == 0) {
                Assert.isTrue((boolean)superType.equals(this.fType));
                String match = this.findMatchingTypeArgument(this.fVariable.signature, index, CompilationUnitCompletion.this.fUnit.findPrimaryType());
                String bound = SignatureUtil.getUpperBound(match);
                this.addBound(bound);
                return;
            }
            IType subType = subTypes[0];
            String signature = this.findMatchingSuperTypeSignature(subType, superType);
            String match = this.findMatchingTypeArgument(signature, index, subType);
            if (this.isConcreteType(match, subType)) {
                this.addBound(match);
                return;
            }
            ITypeParameter[] typeParameters = subType.getTypeParameters();
            int k = 0;
            while (k < typeParameters.length) {
                ITypeParameter formalParameter = typeParameters[k];
                if (formalParameter.getElementName().equals(SignatureUtil.stripSignatureToFQN(match))) {
                    String[] bounds = formalParameter.getBounds();
                    int i = 0;
                    while (i < bounds.length) {
                        String boundSignature = Signature.createTypeSignature((String)bounds[i], (boolean)true);
                        this.addBound(SignatureUtil.qualifySignature(boundSignature, subType));
                        ++i;
                    }
                    this.computeTypeParameterBinding(subType, k);
                    return;
                }
                ++k;
            }
            this.addBound(match);
        }

        private String findMatchingTypeArgument(String signature, int index, IType context) {
            String[] typeArguments = Signature.getTypeArguments((String)signature);
            Assert.isTrue((typeArguments.length == 0 || typeArguments.length > index ? 1 : 0) != 0);
            if (typeArguments.length == 0) {
                return OBJECT_SIGNATURE;
            }
            String bound = SignatureUtil.getUpperBound(typeArguments[index]);
            return SignatureUtil.qualifySignature(bound, context);
        }

        private String findMatchingSuperTypeSignature(IType subType, IType superType) throws JavaModelException {
            String[] signatures = this.getSuperTypeSignatures(subType, superType);
            int i = 0;
            while (i < signatures.length) {
                String superFQN;
                String signature = signatures[i];
                String qualified = SignatureUtil.qualifySignature(signature, subType);
                String subFQN = SignatureUtil.stripSignatureToFQN(qualified);
                if (subFQN.equals(superFQN = superType.getFullyQualifiedName())) {
                    return signature;
                }
                if (CompilationUnitCompletion.this.fLocalTypes.containsValue(subFQN)) {
                    return signature;
                }
                ++i;
            }
            throw new JavaModelException(new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, "Illegal hierarchy", null)));
        }

        private String[] getSuperTypeSignatures(IType subType, IType superType) throws JavaModelException {
            if (superType.isInterface()) {
                return subType.getSuperInterfaceTypeSignatures();
            }
            return new String[]{subType.getSuperclassTypeSignature()};
        }

        private void initBounds() {
            this.fBounds.clear();
            this.fBounds.add(OBJECT_SIGNATURE);
        }

        private void addBound(String boundSignature) {
            if (SignatureUtil.isJavaLangObject(boundSignature)) {
                return;
            }
            boolean found = false;
            ListIterator<String> it = this.fBounds.listIterator();
            while (it.hasNext()) {
                String old = (String)it.next();
                if (!this.isTrueSubtypeOf(boundSignature, old)) continue;
                if (!found) {
                    it.set(boundSignature);
                    found = true;
                    continue;
                }
                it.remove();
            }
            if (!found) {
                this.fBounds.add(boundSignature);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isTrueSubtypeOf(String subTypeSignature, String superTypeSignature) {
            if (subTypeSignature.equals(superTypeSignature)) {
                return true;
            }
            if (SignatureUtil.isJavaLangObject(subTypeSignature)) {
                return false;
            }
            if (Signature.getTypeSignatureKind((String)subTypeSignature) != 2 && SignatureUtil.isJavaLangObject(superTypeSignature)) {
                return true;
            }
            if (CompilationUnitCompletion.this.fUnit == null) {
                return false;
            }
            IJavaProject project = CompilationUnitCompletion.this.fUnit.getJavaProject();
            try {
                if ((Signature.getTypeSignatureKind((String)subTypeSignature) & 3) == 0) {
                    return false;
                }
                IType subType = project.findType(SignatureUtil.stripSignatureToFQN(subTypeSignature));
                if (subType == null) {
                    return false;
                }
                if ((Signature.getTypeSignatureKind((String)superTypeSignature) & 3) == 0) {
                    return false;
                }
                IType superType = project.findType(SignatureUtil.stripSignatureToFQN(superTypeSignature));
                if (superType == null) {
                    return false;
                }
                ITypeHierarchy hierarchy = subType.newSupertypeHierarchy(null);
                IType[] types = hierarchy.getAllSupertypes(subType);
                int i = 0;
                while (true) {
                    if (i >= types.length) {
                        return false;
                    }
                    if (types[i].equals(superType)) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
            return false;
        }

        private boolean isConcreteType(String signature, IType context) throws JavaModelException {
            if (3 == Signature.getTypeSignatureKind((String)signature)) {
                return false;
            }
            if (context.isBinary()) {
                return CompilationUnitCompletion.this.fUnit.getJavaProject().findType(SignatureUtil.stripSignatureToFQN(signature)) != null;
            }
            return context.resolveType(SignatureUtil.stripSignatureToFQN(signature)) != null;
        }
    }
}

