/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.expressions;

import java.util.ArrayList;
import java.util.List;

public class ExpressionInfo {
    private boolean fHasDefaultVariableAccess;
    private boolean fHasSystemPropertyAccess;
    private List fAccessedVariableNames;
    private List fMisbehavingExpressionTypes;

    public boolean hasDefaultVariableAccess() {
        return this.fHasDefaultVariableAccess;
    }

    public void markDefaultVariableAccessed() {
        this.fHasDefaultVariableAccess = true;
    }

    public boolean hasSystemPropertyAccess() {
        return this.fHasSystemPropertyAccess;
    }

    public void markSystemPropertyAccessed() {
        this.fHasSystemPropertyAccess = true;
    }

    public String[] getAccessedVariableNames() {
        if (this.fAccessedVariableNames == null) {
            return new String[0];
        }
        return this.fAccessedVariableNames.toArray(new String[this.fAccessedVariableNames.size()]);
    }

    public void addVariableNameAccess(String name) {
        if (this.fAccessedVariableNames == null) {
            this.fAccessedVariableNames = new ArrayList(5);
            this.fAccessedVariableNames.add(name);
        } else if (!this.fAccessedVariableNames.contains(name)) {
            this.fAccessedVariableNames.add(name);
        }
    }

    public Class[] getMisbehavingExpressionTypes() {
        if (this.fMisbehavingExpressionTypes == null) {
            return null;
        }
        return this.fMisbehavingExpressionTypes.toArray(new Class[this.fMisbehavingExpressionTypes.size()]);
    }

    public void addMisBehavingExpressionType(Class clazz) {
        if (this.fMisbehavingExpressionTypes == null) {
            this.fMisbehavingExpressionTypes = new ArrayList();
            this.fMisbehavingExpressionTypes.add(clazz);
        } else if (!this.fMisbehavingExpressionTypes.contains(clazz)) {
            this.fMisbehavingExpressionTypes.add(clazz);
        }
    }

    public void merge(ExpressionInfo other) {
        this.mergeDefaultVariableAccess(other);
        this.mergeSystemPropertyAccess(other);
        this.mergeAccessedVariableNames(other);
        this.mergeMisbehavingExpressionTypes(other);
    }

    public void mergeExceptDefaultVariable(ExpressionInfo other) {
        this.mergeSystemPropertyAccess(other);
        this.mergeAccessedVariableNames(other);
        this.mergeMisbehavingExpressionTypes(other);
    }

    private void mergeDefaultVariableAccess(ExpressionInfo other) {
        this.fHasDefaultVariableAccess = this.fHasDefaultVariableAccess || other.fHasDefaultVariableAccess;
    }

    private void mergeSystemPropertyAccess(ExpressionInfo other) {
        this.fHasSystemPropertyAccess = this.fHasSystemPropertyAccess || other.fHasSystemPropertyAccess;
    }

    private void mergeAccessedVariableNames(ExpressionInfo other) {
        if (this.fAccessedVariableNames == null) {
            this.fAccessedVariableNames = other.fAccessedVariableNames;
        } else if (other.fAccessedVariableNames != null) {
            for (Object variableName : other.fAccessedVariableNames) {
                if (this.fAccessedVariableNames.contains(variableName)) continue;
                this.fAccessedVariableNames.add(variableName);
            }
        }
    }

    private void mergeMisbehavingExpressionTypes(ExpressionInfo other) {
        if (this.fMisbehavingExpressionTypes == null) {
            this.fMisbehavingExpressionTypes = other.fMisbehavingExpressionTypes;
        } else if (other.fMisbehavingExpressionTypes != null) {
            for (Object clazz : other.fMisbehavingExpressionTypes) {
                if (this.fMisbehavingExpressionTypes.contains(clazz)) continue;
                this.fMisbehavingExpressionTypes.add(clazz);
            }
        }
    }
}

