/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.internal.provisional.verifier.CertificateVerifierFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.FeatureContentProvider;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteContentProvider;
import org.eclipse.update.core.IVerifier;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.ExtendedSite;
import org.eclipse.update.internal.core.LockManager;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.NullContentReference;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.jarprocessor.JarProcessor;
import org.eclipse.update.internal.security.JarVerifier;
import org.eclipse.update.internal.verifier.CertVerifier;

public class FeaturePackagedContentProvider
extends FeatureContentProvider {
    private ContentReference localManifest = null;
    private ContentReference[] localFeatureFiles = new ContentReference[0];
    private IVerifier jarVerifier = null;
    private ExtendedSite siteModel = null;
    private boolean continueOnError;
    public static final FilenameFilter filter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    };

    public FeaturePackagedContentProvider(URL url, ISite site) {
        super(url);
        if (site instanceof ExtendedSite) {
            this.siteModel = (ExtendedSite)site;
        }
    }

    public IVerifier getVerifier() throws CoreException {
        CertificateVerifierFactory factory = UpdateCore.getPlugin().getVerifierFactory();
        if (this.jarVerifier == null || this.jarVerifier.getParent() == null) {
            this.jarVerifier = factory != null ? new CertVerifier(UpdateCore.getPlugin().getVerifierFactory()) : new JarVerifier();
            return this.jarVerifier;
        }
        return this.jarVerifier;
    }

    public ContentReference getFeatureManifestReference(InstallMonitor monitor) throws CoreException {
        if (this.localManifest != null) {
            return this.localManifest;
        }
        ContentReference[] featureArchiveReference = this.getFeatureEntryArchiveReferences(monitor);
        JarContentReference featureJarReference = null;
        try {
            featureJarReference = (JarContentReference)this.asLocalReference(featureArchiveReference[0], null);
            this.localFeatureFiles = featureJarReference.unpack(this.getWorkingDirectory(), null, monitor);
        }
        catch (IOException e) {
            throw this.errorRetrieving("feature.xml", featureJarReference, e);
        }
        int i = 0;
        while (i < this.localFeatureFiles.length) {
            if (this.localFeatureFiles[i].getIdentifier().equals("feature.xml")) {
                this.localManifest = this.localFeatureFiles[i];
                return this.localManifest;
            }
            ++i;
        }
        Object[] values = new String[]{"feature.xml", this.getURL().toExternalForm()};
        throw Utilities.newCoreException(NLS.bind((String)Messages.FeaturePackagedContentProvider_NoManifestFile, (Object[])values), new Exception());
    }

    public ContentReference[] getArchiveReferences(InstallMonitor monitor) throws CoreException {
        IPluginEntry[] entries = this.getFeature().getPluginEntries();
        INonPluginEntry[] nonEntries = this.getFeature().getNonPluginEntries();
        ArrayList listAllContentRef = new ArrayList();
        ContentReference[] allContentRef = new ContentReference[]{};
        listAllContentRef.addAll(Arrays.asList(this.getFeatureEntryArchiveReferences(monitor)));
        int i = 0;
        while (i < entries.length) {
            listAllContentRef.addAll(Arrays.asList(this.getPluginEntryArchiveReferences(entries[i], monitor)));
            ++i;
        }
        i = 0;
        while (i < nonEntries.length) {
            listAllContentRef.addAll(Arrays.asList(this.getNonPluginEntryArchiveReferences(nonEntries[i], monitor)));
            ++i;
        }
        if (listAllContentRef.size() > 0) {
            allContentRef = new ContentReference[listAllContentRef.size()];
            listAllContentRef.toArray(allContentRef);
        }
        return allContentRef;
    }

    public ContentReference[] getFeatureEntryArchiveReferences(InstallMonitor monitor) throws CoreException {
        ContentReference[] references = new ContentReference[1];
        ContentReference currentReference = null;
        String archiveID = null;
        try {
            archiveID = this.getFeature() != null ? this.getFeature().getVersionedIdentifier().toString() : "";
            currentReference = new JarContentReference(archiveID, this.getURL());
            currentReference = this.asLocalReference(currentReference, monitor);
            references[0] = currentReference;
        }
        catch (IOException e) {
            references[0] = this.continueOnErrorOrRethrow(archiveID, e);
        }
        return references;
    }

    public ContentReference[] getPluginEntryArchiveReferences(IPluginEntry pluginEntry, InstallMonitor monitor) throws CoreException {
        ContentReference[] references = new ContentReference[1];
        String archiveID = this.getPathID(pluginEntry);
        ISite site = this.getFeature() == null ? null : this.getFeature().getSite();
        ISiteContentProvider siteContentProvider = site == null ? null : site.getSiteContentProvider();
        URL url = siteContentProvider == null ? null : siteContentProvider.getArchiveReference(archiveID);
        try {
            references[0] = this.retrieveLocalJar(new JarContentReference(archiveID, url), monitor);
        }
        catch (IOException e) {
            references[0] = this.continueOnErrorOrRethrow(archiveID, e);
        }
        return references;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContentReference retrieveLocalJar(JarContentReference reference, InstallMonitor monitor) throws IOException, CoreException {
        Object jarLock;
        if (this.siteModel == null || !this.siteModel.supportsPack200() || !JarProcessor.canPerformUnpack()) {
            ContentReference contentReference = null;
            try {
                contentReference = this.asLocalReference(reference, monitor);
            }
            catch (FileNotFoundException e) {
                contentReference = this.continueOnErrorOrRethrow(reference.getIdentifier(), e);
            }
            catch (IOException e) {
                contentReference = this.continueOnErrorOrRethrow(reference.getIdentifier(), e);
            }
            catch (CoreException e) {
                contentReference = this.continueOnErrorOrRethrow(reference.getIdentifier(), (Exception)((Object)e));
            }
            return contentReference;
        }
        ContentReference packedRef = null;
        String key = reference.toString();
        Object object = jarLock = LockManager.getLock(key);
        synchronized (object) {
            File localFile = Utilities.lookupLocalFile(key);
            if (localFile != null && UpdateManagerUtils.isSameTimestamp(reference.asURL(), localFile.lastModified())) {
                LockManager.returnLock(key);
                return reference.createContentReference(reference.getIdentifier(), localFile);
            }
            try {
                URL packGZURL = new URL(String.valueOf(reference.asURL().toExternalForm()) + ".pack.gz");
                packedRef = this.asLocalReference(new JarContentReference(reference.getIdentifier(), packGZURL), monitor);
            }
            catch (IOException iOException) {
            }
            catch (CoreException coreException) {}
        }
        if (packedRef == null) {
            return this.asLocalReference(reference, monitor);
        }
        boolean success = false;
        Object object2 = jarLock;
        synchronized (object2) {
            Object packedLock;
            String packed = packedRef.toString();
            Object object3 = packedLock = LockManager.getLock(packed);
            synchronized (object3) {
                try {
                    File tempFile = packedRef.asFile();
                    long timeStamp = tempFile.lastModified();
                    JarProcessor processor = JarProcessor.getUnpackProcessor(null);
                    processor.setWorkingDirectory(tempFile.getParent());
                    File packedFile = new File(String.valueOf(tempFile.toString()) + ".pack.gz");
                    tempFile.renameTo(packedFile);
                    if (monitor != null) {
                        monitor.saveState();
                        monitor.subTask(String.valueOf(Messages.JarContentReference_Unpacking) + " " + reference.getIdentifier() + ".pack.gz");
                        monitor.showCopyDetails(false);
                    }
                    processor.processJar(packedFile);
                    if (tempFile.exists() && tempFile.length() > 0L) {
                        success = true;
                        tempFile.setLastModified(timeStamp);
                        Utilities.mapLocalFile(key, tempFile);
                        UpdateCore.getPlugin().getUpdateSession().markVisited(reference.asURL());
                    }
                }
                finally {
                    LockManager.returnLock(packed);
                    LockManager.returnLock(key);
                    if (monitor != null) {
                        monitor.restoreState();
                    }
                }
            }
        }
        if (!success) {
            return this.asLocalReference(reference, monitor);
        }
        return packedRef;
    }

    public ContentReference[] getNonPluginEntryArchiveReferences(INonPluginEntry nonPluginEntry, InstallMonitor monitor) throws CoreException {
        String archiveID = "features/" + (this.getFeature() != null ? this.getFeature().getVersionedIdentifier().toString() : "");
        archiveID = String.valueOf(archiveID) + "/" + nonPluginEntry.getIdentifier();
        ContentReference[] references = new ContentReference[1];
        ContentReference currentReference = null;
        try {
            ISite site = this.getFeature() == null ? null : this.getFeature().getSite();
            ISiteContentProvider siteContentProvider = site == null ? null : site.getSiteContentProvider();
            URL url = siteContentProvider == null ? null : siteContentProvider.getArchiveReference(archiveID);
            currentReference = new ContentReference(nonPluginEntry.getIdentifier(), url);
            references[0] = currentReference = this.asLocalReference(currentReference, monitor);
        }
        catch (IOException e) {
            references[0] = this.continueOnErrorOrRethrow(archiveID, e);
        }
        return references;
    }

    public ContentReference[] getFeatureEntryContentReferences(InstallMonitor monitor) throws CoreException {
        return this.localFeatureFiles;
    }

    public ContentReference[] getPluginEntryContentReferences(IPluginEntry pluginEntry, InstallMonitor monitor) throws CoreException {
        ContentReference[] references = this.getPluginEntryArchiveReferences(pluginEntry, monitor);
        ContentReference[] pluginReferences = new ContentReference[]{};
        try {
            if (references[0] instanceof JarContentReference) {
                JarContentReference localRef = (JarContentReference)this.asLocalReference(references[0], monitor);
                pluginReferences = localRef.peek(null, monitor);
            } else {
                List files = this.getFiles(references[0].asFile());
                pluginReferences = new ContentReference[files.size()];
                int i = 0;
                while (i < pluginReferences.length) {
                    File currentFile = (File)files.get(i);
                    pluginReferences[i] = new ContentReference(null, currentFile.toURL());
                    ++i;
                }
            }
            this.validatePermissions(pluginReferences);
        }
        catch (IOException e) {
            throw this.errorRetrieving(pluginEntry.getVersionedIdentifier().toString(), references[0], e);
        }
        return pluginReferences;
    }

    private List getFiles(File dir) throws IOException {
        ArrayList<File> result = new ArrayList<File>();
        if (!dir.isDirectory()) {
            throw new IOException(NLS.bind((String)Messages.FeaturePackagedContentProvider_InvalidDirectory, (Object[])new String[]{dir.getPath()}));
        }
        File[] files = dir.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    result.addAll(this.getFiles(files[i]));
                } else {
                    result.add(files[i]);
                }
                ++i;
            }
        }
        return result;
    }

    private CoreException errorRetrieving(String obj, ContentReference archive, Exception e) {
        Object[] values = new String[]{obj};
        return Utilities.newCoreException(NLS.bind((String)Messages.FeaturePackagedContentProvider_ErrorRetrieving, (Object[])values), e);
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    private ContentReference continueOnErrorOrRethrow(String archiveID, Exception e) throws CoreException {
        NullContentReference reference = null;
        if (!this.continueOnError) {
            throw this.errorRetrieving(archiveID, reference, e);
        }
        reference = new NullContentReference(archiveID);
        String msg = "    ContinueOnError: The following ID was not found, so was skipped, and is not on miror site: " + archiveID;
        String id = UpdateCore.getPlugin().getBundle().getSymbolicName();
        Status status = new Status(2, id, 0, msg, null);
        UpdateCore.log((IStatus)status);
        return reference;
    }
}

