/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.properties;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.tigris.subversion.subclipse.core.properties.SVNPropertyDefinition;

public class SVNPropertyManager {
    private static SVNPropertyManager instance;
    private SVNPropertyDefinition[] definitions;
    private SVNPropertyDefinition[] fileDefinitions;
    private SVNPropertyDefinition[] folderDefinitions;

    public static SVNPropertyManager getInstance() {
        if (instance == null) {
            instance = new SVNPropertyManager();
        }
        return instance;
    }

    private SVNPropertyManager() {
        this.loadPropertiesFromExtensions();
    }

    private void loadPropertiesFromExtensions() {
        ArrayList<SVNPropertyDefinition> propertyTypes = new ArrayList<SVNPropertyDefinition>();
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.tigris.subversion.subclipse.core", "svnPropertyTypes");
        IExtension[] extensions = extension.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                String name = configElements[j].getAttribute("name");
                String type = configElements[j].getAttribute("type");
                String fileOrFolder = configElements[j].getAttribute("fileOrFolder");
                String allowRecurse = configElements[j].getAttribute("allowRecurse");
                String description = "";
                IConfigurationElement[] descriptionElements = configElements[j].getChildren("description");
                if (descriptionElements.length == 1) {
                    description = descriptionElements[0].getValue();
                }
                int showFor = fileOrFolder.equals("file") ? 2 : (fileOrFolder.equals("folder") ? 1 : 0);
                boolean recurse = true;
                if (allowRecurse != null && allowRecurse.equalsIgnoreCase("false")) {
                    recurse = false;
                }
                SVNPropertyDefinition property = new SVNPropertyDefinition(name, description, showFor, recurse, type);
                propertyTypes.add(property);
                ++j;
            }
            ++i;
        }
        this.definitions = new SVNPropertyDefinition[propertyTypes.size()];
        propertyTypes.toArray(this.definitions);
        Arrays.sort(this.definitions);
        ArrayList<SVNPropertyDefinition> fileProperties = new ArrayList<SVNPropertyDefinition>();
        ArrayList<SVNPropertyDefinition> folderProperties = new ArrayList<SVNPropertyDefinition>();
        int i2 = 0;
        while (i2 < this.definitions.length) {
            if (this.definitions[i2].showForFile()) {
                fileProperties.add(this.definitions[i2]);
            }
            if (this.definitions[i2].showForFolder()) {
                folderProperties.add(this.definitions[i2]);
            }
            ++i2;
        }
        this.fileDefinitions = new SVNPropertyDefinition[fileProperties.size()];
        fileProperties.toArray(this.fileDefinitions);
        this.folderDefinitions = new SVNPropertyDefinition[folderProperties.size()];
        folderProperties.toArray(this.folderDefinitions);
    }

    public SVNPropertyDefinition[] getPropertyTypes() {
        return this.definitions;
    }

    public SVNPropertyDefinition[] getFilePropertyTypes() {
        return this.fileDefinitions;
    }

    public SVNPropertyDefinition[] getFolderPropertyTypes() {
        return this.folderDefinitions;
    }
}

