/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.dialogs.ElementListSelectionDialog;
import org.rubypeople.rdt.internal.ui.util.ResourceSelector;
import org.rubypeople.rdt.internal.ui.util.RubyElementVisitor;
import org.rubypeople.rdt.internal.ui.util.RubyProjectSelector;

public class RubyFileSelector
extends ResourceSelector {
    protected RubyProjectSelector rubyProjectSelector;

    public RubyFileSelector(Composite composite, RubyProjectSelector rubyProjectSelector) {
        super(composite);
        Assert.isNotNull((Object)rubyProjectSelector);
        this.rubyProjectSelector = rubyProjectSelector;
        this.browseDialogTitle = "File Selection";
    }

    protected Object[] getRubyFiles() {
        IProject iProject = this.rubyProjectSelector.getSelection();
        if (iProject == null) {
            return new Object[0];
        }
        RubyElementVisitor rubyElementVisitor = new RubyElementVisitor();
        try {
            iProject.accept((IResourceVisitor)rubyElementVisitor);
        }
        catch (CoreException coreException) {
            RubyPlugin.log(coreException);
        }
        return rubyElementVisitor.getCollectedRubyFiles();
    }

    public IFile getSelection() {
        String string = this.getSelectionText();
        if (string != null && !string.equals("")) {
            Path path = new Path(string);
            IProject iProject = this.rubyProjectSelector.getSelection();
            if (iProject != null && iProject.exists((IPath)path)) {
                return iProject.getFile((IPath)path);
            }
        }
        return null;
    }

    protected void handleBrowseSelected() {
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider());
        elementListSelectionDialog.setTitle(this.browseDialogTitle);
        elementListSelectionDialog.setMessage(this.browseDialogMessage);
        elementListSelectionDialog.setElements(this.getRubyFiles());
        if (elementListSelectionDialog.open() == 0) {
            this.textField.setText(((IResource)elementListSelectionDialog.getFirstResult()).getProjectRelativePath().toString());
        }
    }

    protected String validateResourceSelection() {
        IFile iFile = this.getSelection();
        return iFile == null ? "" : iFile.getProjectRelativePath().toString();
    }
}

