/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyProjectLibraryPage;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;

public class RubyProjectPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    protected RubyProjectLibraryPage projectsPage;
    protected RubyProject workingProject;

    protected Control createContents(Composite composite) {
        this.noDefaultAndApplyButton();
        this.workingProject = this.getRubyProject();
        if (this.workingProject == null || !this.workingProject.getProject().isOpen()) {
            return this.createClosedProjectPageContents(composite);
        }
        return this.createProjectPageContents(composite);
    }

    protected RubyProject getRubyProject() {
        IAdaptable iAdaptable = this.getElement();
        if (iAdaptable == null) {
            return null;
        }
        if (iAdaptable instanceof RubyProject) {
            return (RubyProject)iAdaptable;
        }
        if (iAdaptable instanceof IProject) {
            IProject iProject = (IProject)iAdaptable;
            try {
                if (iProject.hasNature("org.rubypeople.rdt.core.rubynature")) {
                    RubyProject rubyProject = new RubyProject();
                    rubyProject.setProject(iProject);
                    return rubyProject;
                }
            }
            catch (CoreException coreException) {
                RubyPlugin.log(coreException);
            }
        }
        return null;
    }

    protected Control createClosedProjectPageContents(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(RubyUIMessages.getString("RubyProjectPropertyPage.rubyProjectClosed"));
        return label;
    }

    protected Control createProjectPageContents(Composite composite) {
        TabFolder tabFolder = new TabFolder(composite, 0);
        tabFolder.setLayout((Layout)new GridLayout());
        tabFolder.setLayoutData((Object)new GridData(1808));
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
        this.projectsPage = new RubyProjectLibraryPage(this.workingProject);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(RubyUIMessages.getString("RubyProjectLibraryPage.tabName"));
        tabItem.setControl(this.projectsPage.getControl((Composite)tabFolder));
        return tabFolder;
    }

    public boolean performOk() {
        try {
            this.projectsPage.getWorkingProject().save();
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, RubyUIMessages.getString("RubyProjectPropertyPage.performOkException"), RubyUIMessages.getString("RubyProjectPropertyPage.performOkExceptionDialogMessage"));
        }
        return super.performOk();
    }
}

