/**
 * <copyright>
 *
 * Service Data Objects
 * Version 1.0
 * Licensed Materials - Property of BEA and IBM
 *
 * (c) Copyright BEA Systems, Inc. and International Business Machines Corp 2003.  All rights reserved.
 *
 * </copyright>
 * 
 * $Id: Property.java,v 1.1 2004/03/26 15:24:15 marcelop Exp $
 */
package commonj.sdo;

/**
 * A representation of a property in the {@link Type type} of a {@link DataObject data object}.
 */
public interface Property
{
  /**
   * Returns the name of the property.
   * @return the property name.
   */
  String getName();
  
  /**
   * Returns the type of the property.
   * @return the type.
   */
  Type getType();
  
  /**
   * Returns whether the property is many-valued.
   * @return <code>true</code> if the property is many-valued.
   */
  boolean isMany();
  
  /**
   * Returns whether the property is containment, i.e., whether it represents by-value composition.
   * @return <code>true</code> if the property is containment.
   */
  boolean isContainment();
  
  /**
   * Returns the containing type of this property.
   * @return the property's containing type.
   * @see Type#getProperties()
   */
  Type getContainingType();

  /**
   * Returns the default value this property will have in a {@link DataObject data object} where the property hasn't been set.
   * @return the default value.
   */
  Object getDefault();
}
