##
# $Id: aggressive.rb 10394 2010-09-20 08:06:27Z jduck $
##

##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/framework/
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote

	include Msf::Exploit::Remote::Tcp

	def initialize(info = {})
		super(update_info(info,
			'Name'           => 'Internal Aggressive Test Exploit',
			'Description'    =>
				"This module tests the exploitation of a test service.",
			'Author'         => 'skape',
			'License'        => MSF_LICENSE,
			'Version'        => '$Revision: 10394 $',
			'Arch'           => 'x86',
			'Payload'        =>
				{
					'Space'    => 1000,
					'MaxNops'  => 0,
					'BadChars' => "\x00",
					'StackAdjustment' => -3500,
				},
			'Targets'        =>
				[
					# Target 0: Universal
					[
						'Any Platform',
						{
							'Platform' => [ 'linux', 'win' ]
						}
					],
					[
						'Test encoder specific',
						{
							'Platform' => [ 'linux', 'win' ],
							'Payload'  =>
								{
									'EncoderType'    => Msf::Encoder::Type::AlphanumUpper,
									'EncoderOptions' =>
										{
											'BufferRegister' => 'EBX',
											'BufferOffset'   => 4
										}
								}
						},
					],
					[
						'Cannot be encoded',
						{
							'Platform' => [ 'linux', 'win' ],
							'Payload'  =>
								{
									'BadChars' => (0..255).to_a.map { |x| x.chr }.to_s
								}
						}
					],
					[ 'Test context encoder',
						{
							'Platform' => [ 'linux', 'win' ],
							'Payload'  =>
								{
									'BadChars' => "\x00"
								}
						}
					]
				],
			'DefaultTarget' => 0))

		register_options(
			[
				OptBool.new('WaitForInput', [ false, "Wait for user input before returning from exploit", false ]),
				OptInt.new('TestInteger', [ false, "Testing an integer value", nil ])
			])
	end


	def autofilter
		false
	end

	def check
		return Exploit::CheckCode::Vulnerable
	end

	def exploit
		# Show disassembled payload for context encoder test
		if target.name =~ /context encoder/
			puts Rex::Assembly::Nasm.disassemble(payload.encoded[0,40])
		end

		connect

		print_status("Sending #{payload.encoded.length} byte payload...[#{datastore['TestInteger']}]")

		sock.put(payload.encoded)

		if (datastore['WaitForInput'])
			puts "Type something..."
			gets
		end

		handler
	end

end
