##
# $Id: sample.rb 9212 2010-05-03 17:13:09Z jduck $
##

##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/framework/
##

require 'msf/core'

module Msf
module Nops

###
#
# This class implements a very basic NOP sled generator that just returns a
# string of 0x90's.
#
###
class Sample < Msf::Nop

	def initialize
		super(
			'Name'        => 'Sample NOP generator',
			'Version'     => '$Revision: 9212 $',
			'Description' => 'Sample single-byte NOP generator',
			'Author'      => 'skape',
			'Arch'        => ARCH_X86)
	end

	#
	# Returns a string of 0x90's for the supplied length.
	#
	def generate_sled(length, opts)
		"\x90" * length
	end

end

end 
end
