<?php
/*********************************************************************************
 * TimeTrex is a Payroll and Time Management program developed by
 * TimeTrex Payroll Services Copyright (C) 2003 - 2012 TimeTrex Payroll Services.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY TIMETREX, TIMETREX DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along
 * with this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 *
 * You can contact TimeTrex headquarters at Unit 22 - 2475 Dobbin Rd. Suite
 * #292 Westbank, BC V4T 2E9, Canada or at email address info@timetrex.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by TimeTrex" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by TimeTrex".
 ********************************************************************************/
/*
 * $Revision: 2116 $
 * $Id: calcExceptions.php 2116 2008-09-05 18:49:48Z ipso $
 * $Date: 2008-09-05 11:49:48 -0700 (Fri, 05 Sep 2008) $
 */
/*
 * Calculate Exceptions for the previous day. This helps especially for
 * the "Unscheuled Absence" exception.
 *
 * Run this once a day. AFTER AddUserDate
 */
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR .'..'. DIRECTORY_SEPARATOR .'includes'. DIRECTORY_SEPARATOR .'global.inc.php');
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR .'..'. DIRECTORY_SEPARATOR .'includes'. DIRECTORY_SEPARATOR .'CLI.inc.php');

//Debug::setVerbosity(5);

$execution_time = time();

$clf = new CompanyListFactory();
$clf->getAll();

$x=0;
if ( $clf->getRecordCount() > 0 ) {
	foreach ( $clf as $c_obj ) {

		if ( $c_obj->getStatus() != 30 ) {
			$company_start_time = microtime(TRUE);
			Debug::text('Company: '. $c_obj->getName() .'('.$c_obj->getId().')', __FILE__, __LINE__, __METHOD__,5);

			//Calculate exceptions just for today and yesterday, because some shifts may start late in the day and need to be handled first thing in the morning.
			$start_date = TTDate::getBeginDayEpoch( (TTDate::getMiddleDayEpoch( $execution_time )-86400) );
			$end_date = TTDate::getEndDayEpoch( time() );

			$udlf = new UserDateListFactory();
			$udlf->getByCompanyIdAndStartDateAndEndDateAndPayPeriodStatus($c_obj->getId(), $start_date, $end_date, array(10,12,15,30) );
			Debug::text(' Start Date: '. TTDate::getDate('DATE+TIME', $start_date ) .' End Date: '. TTDate::getDate('DATE+TIME', $end_date ) .' User Date Rows: '. $udlf->getRecordCount(), __FILE__, __LINE__, __METHOD__,5);

			if ( $udlf->getRecordCount() > 0 ) {
				$i=0;
				foreach ($udlf as $ud_obj) {
					Debug::text($x .'('.$i.'). User: '. $ud_obj->getUser() .' Date: '. TTDate::getDate('DATE+TIME', $ud_obj->getDateStamp() ) .' User Date ID: '. $ud_obj->getId() .' Enable PreMature Exceptions: '. (int)$enable_premature_exceptions, __FILE__, __LINE__, __METHOD__,5);

					//Calculate pre-mature exceptions, so pre-mature Missing Out Punch exceptions are made active until they are ready.
					//Don't calculate future exceptions though.
					ExceptionPolicyFactory::calcExceptions( $ud_obj->getId(), TRUE, FALSE );

					$i++;
					$x++;
				}
			}
			Debug::text('Company: '. $c_obj->getName() .'('.$c_obj->getId().') Finished In: '. (microtime(TRUE)-$company_start_time) .'s', __FILE__, __LINE__, __METHOD__,5);
		}
	}
}

Debug::writeToLog();
Debug::Display();
?>