DROP TABLE IF EXISTS report_schedule;
CREATE TABLE report_schedule (
        id serial NOT NULL,
        user_report_data_id integer NOT NULL,
        state_id integer DEFAULT 10 NOT NULL,
        status_id integer DEFAULT 10 NOT NULL,
        priority_id integer NOT NULL,
        name character varying,
        description character varying,
        last_run_date timestamp with time zone,
        last_run_processing_time integer,
        average_processing_time integer,
        total_processing_time bigint,
        total_runs integer,
        start_date timestamp with time zone,
        end_date timestamp with time zone,
        custom_frequency_id character varying,
        custom_frequency_data character varying,
        "minute" character varying,
        "hour" character varying,
        day_of_month character varying,
        "month" character varying,
        day_of_week character varying,
	home_email_cc smallint DEFAULT 0,
	other_email character varying,
        created_date integer,
        created_by integer,
        updated_date integer,
        updated_by integer,
        deleted_date integer,
        deleted_by integer,
        deleted smallint DEFAULT 0 NOT NULL
);
CREATE UNIQUE INDEX report_schedule_id ON report_schedule USING btree (id);
CREATE INDEX report_schedule_user_report_id ON report_schedule USING btree (user_report_data_id);
