<?php
/*********************************************************************************
 * TimeTrex is a Payroll and Time Management program developed by
 * TimeTrex Payroll Services Copyright (C) 2003 - 2012 TimeTrex Payroll Services.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY TIMETREX, TIMETREX DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along
 * with this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 *
 * You can contact TimeTrex headquarters at Unit 22 - 2475 Dobbin Rd. Suite
 * #292 Westbank, BC V4T 2E9, Canada or at email address info@timetrex.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by TimeTrex" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by TimeTrex".
 ********************************************************************************/
/*
 * $Revision: 2196 $
 * $Id: APINotification.class.php 2196 2008-10-14 16:08:54Z ipso $
 * $Date: 2008-10-14 09:08:54 -0700 (Tue, 14 Oct 2008) $
 */

/**
 * @package API_APINotification
 */
class APINotification extends APIFactory {
	protected $main_class = '';

	public function __construct() {
		parent::__construct(); //Make sure parent constructor is always called.

		return TRUE;
	}

	/**
	 * Returns array of notifications message to be displayed to the user.
	 * @param string $action Action that is being performed, possible values: 'login', 'preference', 'notification', 'pay_period'
	 * @return array
	 */
	function getNotifications( $action = FALSE ) {
		global $config_vars, $disable_database_connection;

		$retarr = FALSE;

		//Skip this step if disable_database_connection is enabled or the user is going through the installer still
		switch ( strtolower($action) ) {
			case 'login':
				if ( ( !isset($disable_database_connection) OR ( isset($disable_database_connection) AND $disable_database_connection != TRUE ) )
						AND ( !isset($config_vars['other']['installer_enabled']) OR ( isset($config_vars['other']['installer_enabled']) AND $config_vars['other']['installer_enabled'] != TRUE ) )) {
					//Get all system settings, so they can be used even if the user isn't logged in, such as the login page.
					$sslf = new SystemSettingListFactory();
					$system_settings = $sslf->getAllArray();
				}
				unset($sslf);

				//Check license validity
				if ( ( ( DEPLOYMENT_ON_DEMAND == FALSE AND $this->getCurrentCompanyObject()->getId() == 1 ) OR ( isset($config_vars['other']['primary_company_id']) AND $this->getCurrentCompanyObject()->getId() == $config_vars['other']['primary_company_id'] ) ) AND getTTProductEdition() > 10 ) {
					if ( !isset($system_settings['license']) ) {
						$system_settings['license'] = NULL;
					}

					$license = new TTLicense();
					$license_validate = $license->validateLicense( $system_settings['license'] );
					$license_message = $license->getFullErrorMessage( $license_validate , TRUE );
					if ( $license_message != '' ) {
						$destination_url = 'http://www.timetrex.com/r.php?id=899';

						if ( $license_validate === TRUE ) {
							//License likely expires soon.
							$retarr[] = array(
												  'delay' => 0, //0= Show until clicked, -1 = Show until next getNotifications call.
												  'bg_color' => '#FFFF00', //Yellow
												  'message' => TTi18n::getText('WARNING: %1', $license_message ),
												  'destination' => $destination_url,
												  );
						} else {
							//License error.
							$retarr[] = array(
												  'delay' => -1, //0= Show until clicked, -1 = Show until next getNotifications call.
												  'bg_color' => '#FF0000', //Red
												  'message' => TTi18n::getText('WARNING: %1', $license_message ),
												  'destination' => $destination_url,
												  );
						}
					}
					unset($license, $license_validate, $license_message, $destination);
				}

				//Check version mismatch
				if ( isset($system_settings['system_version']) AND DEPLOYMENT_ON_DEMAND == FALSE AND APPLICATION_VERSION != $system_settings['system_version'] ) {
					$retarr[] = array(
										  'delay' => -1, //0= Show until clicked, -1 = Show until next getNotifications call.
										  'bg_color' => '#FF0000', //Red
										  'message' => TTi18n::getText('WARNING: %1 application version does not match database version. Please re-run the TimeTrex installer to complete the upgrade process.', APPLICATION_NAME ),
										  'destination' => NULL,
										  );
				}

				if ( isset($system_settings['tax_data_version']) AND (time()-strtotime($system_settings['tax_data_version'])) > (86400*475) ) { //~1yr and 3mths
					$retarr[] = array(
										  'delay' => -1,
										  'bg_color' => '#FF0000', //Red
										  'message' => TTi18n::getText('WARNING: This %1 version (v%2) is severely out of date and may no longer be supported. Please upgrade to the latest version as soon as possible as invalid calculations may already be occurring.', array( APPLICATION_NAME, APPLICATION_VERSION ) ),
										  'destination' => NULL,
										  );
				}

				//Check installer enabled.
				if ( isset($config_vars['other']['installer_enabled']) AND $config_vars['other']['installer_enabled'] == 1 ) {
					$retarr[] = array(
										  'delay' => -1,
										  'bg_color' => '#FF0000', //Red
										  'message' => TTi18n::getText('WARNING: %1 is currently in INSTALL MODE. Please go to your timetrex.ini.php file and set "installer_enabled" to "FALSE".', APPLICATION_NAME ),
										  'destination' => NULL,
										  );
				}

				//Make sure CronJobs are running correctly.
				$cjlf = new CronJobListFactory();
				$cjlf->getMostRecentlyRun();
				if ( $cjlf->getRecordCount() > 0 ) {
					//Is last run job more then 48hrs old?
					$cj_obj = $cjlf->getCurrent();

					if ( PRODUCTION == TRUE
							AND DEMO_MODE == FALSE
							AND $cj_obj->getLastRunDate() < ( time()-172800 )
							AND $cj_obj->getCreatedDate() < ( time()-172800 ) ) {
						$retarr[] = array(
											  'delay' => -1,
											  'bg_color' => '#FF0000', //Red
											  'message' => TTi18n::getText('WARNING: Critical maintenance jobs have not run in the last 48hours. Please contact your %1 administrator immediately.', APPLICATION_NAME ),
											  'destination' => NULL,
											  );
					}
				}
				unset($cjlf, $cj_obj);

				//Check if any pay periods are past their transaction date and not closed.
				if ( $this->getPermissionObject()->Check('pay_period_schedule','enabled') AND $this->getPermissionObject()->Check('pay_period_schedule','view') ) {
					$pplf = TTnew('PayPeriodListFactory');
					$pplf->getByCompanyIdAndStatusAndTransactionDate( $this->getCurrentCompanyObject()->getId(), array(10,30), TTDate::getBeginDayEpoch( time() ) ); //Open or Post Adjustment pay periods.
					if ( $pplf->getRecordCount() > 0 ) {
						$retarr[] = array(
											  'delay' => 0,
											  'bg_color' => '#FF0000', //Red
											  'message' => TTi18n::getText('WARNING: Pay periods past their transaction date have not been closed yet. It\'s critical that these pay periods are closed to prevent accidental data loss.'),
											  'destination' => array('menu_name' => 'Pay Periods'),
											  );
					}
					unset($pplf);
				}

				break;
			default:
				break;
		}

		//Check timezone is proper.
		$current_user_prefs = $this->getCurrentUserObject()->getUserPreferenceObject();
		//If user doesnt have any preferences set, we need to bootstrap the preference object.
		//This is done in the UserFactory now.
		//if ( $current_user_prefs->getUser() == '' ) {
		//	$current_user_prefs->setUser( $this->getCurrentUserObject()->getId() );
		//}

		if ( $current_user_prefs->setDateTimePreferences() == FALSE ) {
			//Setting timezone failed, alert user to this fact.
			//WARNING: %1 was unable to set your time zone. Please contact your %1 administrator immediately.{/t} {if $permission->Check('company','enabled') AND $permission->Check('company','edit_own')}<a href="http://forums.timetrex.com/viewtopic.php?t=40">{t}For more information please click here.{/t}</a>{/if}
			if ( $this->getPermissionObject()->Check('company','enabled') AND $this->getPermissionObject()->Check('company','edit_own') ) {
				$destination_url = 'http://www.timetrex.com/r.php?id=1010';
				$sub_message = TTi18n::getText('For more information please click here.');
			} else {
				$destination_url = NULL;
				$sub_message = NULL;
			}

			$retarr[] = array(
								  'delay' => -1,
								  'bg_color' => '#FF0000', //Red
								  'message' => TTi18n::getText('WARNING: %1 was unable to set your time zone. Please contact your %1 administrator immediately.', APPLICATION_NAME ).' '. $sub_message,
								  'destination' => $destination_url,
								  );
			unset($destination_url, $sub_message );
		}

/*
		if ( PRODUCTION == FALSE ) {
			$retarr[] = 	array(
								  'delay' => 0, //0= Show until clicked, -1 = Show until next getNotifications call.
								  'bg_color' => '#FF0000', //FFFF00
								  'message' => 'This is a test message to show until clicked.',
								  'destination' => NULL,
								  );
			$retarr[] = 	array(
								  'delay' => -1, //0= Show until clicked, -1 = Show until next getNotifications call.
								  'bg_color' => '#FFFF00', //FFFF00
								  'message' => 'This is a test message to show until next getNotification() call.',
								  'destination' => NULL,
								  );
			$retarr[] = 	array(
								  'delay' => 5, //0= Show until clicked, -1 = Show until next getNotifications call.
								  'bg_color' => '#FFFF00', //FFFF00
								  'message' => 'This is a test message to show for 5 seconds than disappear',
								  'destination' => NULL,
								  );
		}
*/
		return $retarr;

	}
}
?>
