/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.tomcat.util.bcel.classfile.AccessFlags;
import org.apache.tomcat.util.bcel.classfile.AnnotationEntry;
import org.apache.tomcat.util.bcel.classfile.Annotations;
import org.apache.tomcat.util.bcel.classfile.Attribute;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;
import org.apache.tomcat.util.bcel.classfile.Field;
import org.apache.tomcat.util.bcel.classfile.Method;
import org.apache.tomcat.util.bcel.classfile.SourceFile;
import org.apache.tomcat.util.bcel.classfile.Utility;
import org.apache.tomcat.util.bcel.util.BCELComparator;

public class JavaClass
extends AccessFlags
implements Cloneable,
Comparable<JavaClass> {
    private static final long serialVersionUID = 7029227708237523236L;
    private String file_name;
    private String source_file_name = "<Unknown>";
    private String class_name;
    private String superclass_name;
    private int major;
    private int minor;
    private ConstantPool constant_pool;
    private int[] interfaces;
    private String[] interface_names;
    private Field[] fields;
    private Method[] methods;
    private Attribute[] attributes;
    private AnnotationEntry[] annotations;
    private boolean annotationsOutOfDate = true;
    private static BCELComparator _cmp = new BCELComparator(){

        @Override
        public boolean equals(Object o1, Object o2) {
            JavaClass THIS = (JavaClass)o1;
            JavaClass THAT = (JavaClass)o2;
            return THIS.getClassName().equals(THAT.getClassName());
        }

        @Override
        public int hashCode(Object o) {
            JavaClass THIS = (JavaClass)o;
            return THIS.getClassName().hashCode();
        }
    };

    public JavaClass(int class_name_index, int superclass_name_index, String file_name, int major, int minor, int access_flags, ConstantPool constant_pool, int[] interfaces, Field[] fields, Method[] methods, Attribute[] attributes) {
        int i;
        if (interfaces == null) {
            interfaces = new int[]{};
        }
        if (attributes == null) {
            attributes = new Attribute[]{};
        }
        if (fields == null) {
            fields = new Field[]{};
        }
        if (methods == null) {
            methods = new Method[]{};
        }
        this.file_name = file_name;
        this.major = major;
        this.minor = minor;
        this.access_flags = access_flags;
        this.constant_pool = constant_pool;
        this.interfaces = interfaces;
        this.fields = fields;
        this.methods = methods;
        this.attributes = attributes;
        this.annotationsOutOfDate = true;
        for (i = 0; i < attributes.length; ++i) {
            if (!(attributes[i] instanceof SourceFile)) continue;
            this.source_file_name = ((SourceFile)attributes[i]).getSourceFileName();
            break;
        }
        this.class_name = constant_pool.getConstantString(class_name_index, (byte)7);
        this.class_name = Utility.compactClassName(this.class_name, false);
        if (superclass_name_index > 0) {
            this.superclass_name = constant_pool.getConstantString(superclass_name_index, (byte)7);
            this.superclass_name = Utility.compactClassName(this.superclass_name, false);
        } else {
            this.superclass_name = "java.lang.Object";
        }
        this.interface_names = new String[interfaces.length];
        for (i = 0; i < interfaces.length; ++i) {
            String str = constant_pool.getConstantString(interfaces[i], (byte)7);
            this.interface_names[i] = Utility.compactClassName(str, false);
        }
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public AnnotationEntry[] getAnnotationEntries() {
        if (this.annotationsOutOfDate) {
            Attribute[] attrs = this.getAttributes();
            ArrayList<AnnotationEntry> accumulatedAnnotations = new ArrayList<AnnotationEntry>();
            for (int i = 0; i < attrs.length; ++i) {
                Attribute attribute = attrs[i];
                if (!(attribute instanceof Annotations)) continue;
                Annotations runtimeAnnotations = (Annotations)attribute;
                for (int j = 0; j < runtimeAnnotations.getAnnotationEntries().length; ++j) {
                    accumulatedAnnotations.add(runtimeAnnotations.getAnnotationEntries()[j]);
                }
            }
            this.annotations = accumulatedAnnotations.toArray(new AnnotationEntry[accumulatedAnnotations.size()]);
            this.annotationsOutOfDate = false;
        }
        return this.annotations;
    }

    public String getClassName() {
        return this.class_name;
    }

    public String toString() {
        int i;
        AnnotationEntry[] annotations;
        int i2;
        String access = Utility.accessToString(this.access_flags, true);
        access = access.equals("") ? "" : access + " ";
        StringBuilder buf = new StringBuilder(128);
        buf.append(access).append(Utility.classOrInterface(this.access_flags)).append(" ").append(this.class_name).append(" extends ").append(Utility.compactClassName(this.superclass_name, false)).append('\n');
        int size = this.interfaces.length;
        if (size > 0) {
            buf.append("implements\t\t");
            for (i2 = 0; i2 < size; ++i2) {
                buf.append(this.interface_names[i2]);
                if (i2 >= size - 1) continue;
                buf.append(", ");
            }
            buf.append('\n');
        }
        buf.append("filename\t\t").append(this.file_name).append('\n');
        buf.append("compiled from\t\t").append(this.source_file_name).append('\n');
        buf.append("compiler version\t").append(this.major).append(".").append(this.minor).append('\n');
        buf.append("access flags\t\t").append(this.access_flags).append('\n');
        buf.append("constant pool\t\t").append(this.constant_pool.getLength()).append(" entries\n");
        buf.append("ACC_SUPER flag\t\t").append(this.isSuper()).append("\n");
        if (this.attributes.length > 0) {
            buf.append("\nAttribute(s):\n");
            for (i2 = 0; i2 < this.attributes.length; ++i2) {
                buf.append(JavaClass.indent(this.attributes[i2]));
            }
        }
        if ((annotations = this.getAnnotationEntries()) != null && annotations.length > 0) {
            buf.append("\nAnnotation(s):\n");
            for (i = 0; i < annotations.length; ++i) {
                buf.append(JavaClass.indent(annotations[i]));
            }
        }
        if (this.fields.length > 0) {
            buf.append("\n").append(this.fields.length).append(" fields:\n");
            for (i = 0; i < this.fields.length; ++i) {
                buf.append("\t").append(this.fields[i]).append('\n');
            }
        }
        if (this.methods.length > 0) {
            buf.append("\n").append(this.methods.length).append(" methods:\n");
            for (i = 0; i < this.methods.length; ++i) {
                buf.append("\t").append(this.methods[i]).append('\n');
            }
        }
        return buf.toString();
    }

    private static final String indent(Object obj) {
        StringTokenizer tok = new StringTokenizer(obj.toString(), "\n");
        StringBuilder buf = new StringBuilder();
        while (tok.hasMoreTokens()) {
            buf.append("\t").append(tok.nextToken()).append("\n");
        }
        return buf.toString();
    }

    public final boolean isSuper() {
        return (this.access_flags & 0x20) != 0;
    }

    public boolean equals(Object obj) {
        return _cmp.equals(this, obj);
    }

    @Override
    public int compareTo(JavaClass obj) {
        return this.getClassName().compareTo(obj.getClassName());
    }

    public int hashCode() {
        return _cmp.hashCode(this);
    }
}

