/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.scheduler;

import java.util.Iterator;
import java.util.List;
import scala.Predef$;
import scala.ScalaObject;
import scala.actors.Debug$;
import scala.actors.IScheduler;
import scala.actors.IScheduler$class;
import scala.actors.Reactor;
import scala.actors.scheduler.QuitControl;
import scala.actors.scheduler.TerminationMonitor;
import scala.actors.scheduler.TerminationMonitor$class;
import scala.actors.scheduler.ThreadPoolConfig$;
import scala.actors.threadpool.LinkedBlockingQueue;
import scala.actors.threadpool.ThreadFactory;
import scala.actors.threadpool.ThreadPoolExecutor;
import scala.actors.threadpool.TimeUnit;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ManagedBlocker;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResizableThreadPoolScheduler
extends Thread
implements ScalaObject,
IScheduler,
TerminationMonitor {
    private final boolean terminate;
    private final boolean daemon;
    private boolean terminating;
    private boolean suspending;
    private volatile List<?> drainedTasks;
    private int coreSize;
    private final int maxSize;
    private final int numCores;
    private final int CHECK_FREQ;
    private final DaemonThreadFactory threadFac;
    private ThreadPoolExecutor executor;
    private int activeActors;
    private final HashMap terminationHandlers;
    private boolean scala$actors$scheduler$TerminationMonitor$$started;

    @Override
    public int activeActors() {
        return this.activeActors;
    }

    @Override
    public void activeActors_$eq(int n) {
        this.activeActors = n;
    }

    public HashMap terminationHandlers() {
        return this.terminationHandlers;
    }

    @Override
    public final boolean scala$actors$scheduler$TerminationMonitor$$started() {
        return this.scala$actors$scheduler$TerminationMonitor$$started;
    }

    @Override
    public final void scala$actors$scheduler$TerminationMonitor$$started_$eq(boolean bl) {
        this.scala$actors$scheduler$TerminationMonitor$$started = bl;
    }

    @Override
    public void scala$actors$scheduler$TerminationMonitor$_setter_$terminationHandlers_$eq(HashMap hashMap) {
        this.terminationHandlers = hashMap;
    }

    public void newActor(Reactor a) {
        TerminationMonitor$class.newActor(this, a);
    }

    public void terminated(Reactor a) {
        TerminationMonitor$class.terminated(this, a);
    }

    @Override
    public boolean allActorsTerminated() {
        return TerminationMonitor$class.allActorsTerminated(this);
    }

    @Override
    public void gc() {
        TerminationMonitor$class.gc(this);
    }

    @Override
    public void executeFromActor(Runnable task) {
        IScheduler$class.executeFromActor(this, task);
    }

    public boolean terminate() {
        return this.terminate;
    }

    public boolean daemon() {
        return this.daemon;
    }

    private boolean terminating() {
        return this.terminating;
    }

    private void terminating_$eq(boolean bl) {
        this.terminating = bl;
    }

    private boolean suspending() {
        return this.suspending;
    }

    private List<?> drainedTasks() {
        return this.drainedTasks;
    }

    private void drainedTasks_$eq(List<?> list) {
        this.drainedTasks = list;
    }

    private int coreSize() {
        return this.coreSize;
    }

    private void coreSize_$eq(int n) {
        this.coreSize = n;
    }

    private int maxSize() {
        return this.maxSize;
    }

    private int numCores() {
        return this.numCores;
    }

    public int CHECK_FREQ() {
        return this.CHECK_FREQ;
    }

    private DaemonThreadFactory threadFac() {
        return this.threadFac;
    }

    private ThreadPoolExecutor makeNewPool() {
        LinkedBlockingQueue workQueue = new LinkedBlockingQueue();
        return new ThreadPoolExecutor(this.coreSize(), this.maxSize(), 60000L, TimeUnit.MILLISECONDS, workQueue, this.threadFac(), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    private ThreadPoolExecutor executor() {
        return this.executor;
    }

    public ResizableThreadPoolScheduler(boolean d) {
        this(true, d);
    }

    public ResizableThreadPoolScheduler() {
        this(false);
    }

    /*
     * WARNING - void declaration
     */
    private int numWorkersBlocked() {
        void var2_2;
        this.executor().mainLock.lock();
        Iterator iter = this.executor().workers.iterator();
        int numBlocked = 0;
        while (iter.hasNext()) {
            Thread.State s;
            ThreadPoolExecutor.Worker w = (ThreadPoolExecutor.Worker)iter.next();
            if (w.tryLock()) {
                w.unlock();
                continue;
            }
            Thread.State state = s = w.thread.getState();
            Thread.State state2 = Thread.State.WAITING;
            if (state == null ? state2 != null : !((Object)((Object)state)).equals((Object)state2)) {
                Thread.State state3 = s;
                Thread.State state4 = Thread.State.TIMED_WAITING;
                if (state3 != null ? !((Object)((Object)state3)).equals((Object)state4) : state4 != null) continue;
            }
            ++numBlocked;
        }
        this.executor().mainLock.unlock();
        return (int)var2_2;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        try {
            while (true) lbl-1000:
            // 2 sources

            {
                var1_1 = this;
                synchronized (var1_1) {
                    this.liftedTree1$1();
                    if (this.terminating()) {
                        throw new QuitControl();
                    }
                    if (this.suspending()) {
                        this.drainedTasks_$eq(this.executor().shutdownNow());
                        Debug$.MODULE$.info(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this).$plus(": drained ")).append(BoxesRunTime.boxToInteger(this.drainedTasks().size())).append((Object)" tasks").toString());
                        this.terminating_$eq(true);
                        throw new QuitControl();
                    }
                    this.gc();
                    var2_2 = this.numWorkersBlocked();
                    if (this.coreSize() - var2_2 < this.numCores() && this.coreSize() < this.maxSize()) {
                        this.coreSize_$eq(this.numCores() + var2_2);
                        this.executor().setCorePoolSize(this.coreSize());
                        v0 = BoxedUnit.UNIT;
                    } else if (this.terminate() && this.allActorsTerminated()) {
                        if (this.executor().getActiveCount() == 0) {
                            Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": initiating shutdown..."));
                            Debug$.MODULE$.info(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this).$plus(": corePoolSize = ")).append(BoxesRunTime.boxToInteger(this.coreSize())).append((Object)", maxPoolSize = ").append(BoxesRunTime.boxToInteger(this.maxSize())).toString());
                            this.terminating_$eq(true);
                            throw new QuitControl();
                        }
                        v0 = BoxedUnit.UNIT;
                    } else {
                        v0 = BoxedUnit.UNIT;
                    }
                    continue;
                }
                break;
            }
        }
        catch (QuitControl v2) {
            this.executor().shutdown();
            return;
        }
        {
            ** while (true)
        }
    }

    @Override
    public void execute(Runnable task) {
        this.executor().execute(task);
    }

    @Override
    public boolean isActive() {
        ResizableThreadPoolScheduler resizableThreadPoolScheduler = this;
        synchronized (resizableThreadPoolScheduler) {
            Boolean bl = BoxesRunTime.boxToBoolean(!this.terminating() && this.executor() != null && !this.executor().isShutdown());
            return BoxesRunTime.unboxToBoolean(bl);
        }
    }

    @Override
    public void managedBlock(ManagedBlocker blocker) {
        blocker.block();
    }

    private final void liftedTree1$1() {
        try {
            this.wait(this.CHECK_FREQ());
        }
        catch (InterruptedException interruptedException) {}
    }

    public ResizableThreadPoolScheduler(boolean bl, boolean bl2) {
        this.terminate = bl;
        this.daemon = bl2;
        IScheduler$class.$init$(this);
        TerminationMonitor$class.$init$(this);
        this.setDaemon(bl2);
        this.terminating = false;
        this.suspending = false;
        this.drainedTasks = null;
        this.coreSize = ThreadPoolConfig$.MODULE$.corePoolSize();
        this.maxSize = ThreadPoolConfig$.MODULE$.maxPoolSize();
        this.numCores = Runtime.getRuntime().availableProcessors();
        this.CHECK_FREQ = 10;
        this.threadFac = new DaemonThreadFactory();
        this.executor = this.makeNewPool();
        Debug$.MODULE$.info(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this).$plus(": corePoolSize = ")).append(BoxesRunTime.boxToInteger(this.coreSize())).append((Object)", maxPoolSize = ").append(BoxesRunTime.boxToInteger(this.maxSize())).toString());
    }

    public class DaemonThreadFactory
    implements ScalaObject,
    ThreadFactory {
        /*
         * WARNING - void declaration
         */
        public Thread newThread(Runnable r) {
            void var2_2;
            Thread t = new Thread(r);
            t.setDaemon(this.scala$actors$scheduler$ResizableThreadPoolScheduler$DaemonThreadFactory$$$outer().daemon());
            return var2_2;
        }

        public /* synthetic */ ResizableThreadPoolScheduler scala$actors$scheduler$ResizableThreadPoolScheduler$DaemonThreadFactory$$$outer() {
            return ResizableThreadPoolScheduler.this;
        }

        public DaemonThreadFactory() {
            if (ResizableThreadPoolScheduler.this == null) {
                throw new NullPointerException();
            }
        }
    }
}

