/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.actions;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.REF;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.PyBreakpoint;
import org.python.pydev.debug.model.PyDebugModelPresentation;
import org.python.pydev.debug.ui.actions.AbstractBreakpointRulerAction;
import org.python.pydev.editorinput.PydevFileEditorInput;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreakpointRulerAction
extends AbstractBreakpointRulerAction {
    private List<IMarker> fMarkers;
    private String fAddLabel;
    private String fRemoveLabel;

    public BreakpointRulerAction(ITextEditor editor, IVerticalRulerInfo ruler) {
        this.setInfo(ruler);
        this.setTextEditor(editor);
        this.setText("Breakpoint &Properties...");
        this.fAddLabel = "Add Breakpoint";
        this.fRemoveLabel = "Remove Breakpoint";
    }

    public void update() {
        this.fMarkers = this.getMarkersFromCurrentFile();
        this.setText(this.fMarkers.isEmpty() ? this.fAddLabel : this.fRemoveLabel);
    }

    public void run() {
        if (this.fMarkers.isEmpty()) {
            this.addMarker();
        } else {
            this.removeMarkers(this.fMarkers);
        }
    }

    protected List<IMarker> getMarkersFromCurrentFile() {
        return BreakpointRulerAction.getMarkersFromEditorResource(this.getResourceForDebugMarkers(), this.getDocument(), this.getPydevFileEditorInput(), this.getInfo(), true);
    }

    protected void addMarker() {
        try {
            IDocument document = this.getDocument();
            int rulerLine = this.getInfo().getLineOfLastMouseButtonActivity();
            int lineNumber = rulerLine + 1;
            if (lineNumber < 0) {
                return;
            }
            document.getLineInformation(lineNumber - 1);
            final IResource resource = this.getResourceForDebugMarkers();
            final HashMap<String, Object> map = new HashMap<String, Object>();
            PydevFileEditorInput pydevFileEditorInput = this.getPydevFileEditorInput();
            if (pydevFileEditorInput == null && resource instanceof IWorkspaceRoot) {
                return;
            }
            map.put("message", "what's the message");
            map.put("lineNumber", new Integer(lineNumber));
            map.put("org.eclipse.debug.core.enabled", new Boolean(true));
            map.put("org.eclipse.debug.core.id", PyDebugModelPresentation.PY_DEBUG_MODEL_ID);
            if (pydevFileEditorInput != null) {
                map.put("org.python.pydev.debug.PYDEV_EXTERNAL_PATH_ID", REF.getFileAbsolutePath((File)pydevFileEditorInput.getFile()));
            }
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IMarker marker = resource.createMarker("org.python.pydev.debug.pyStopBreakpointMarker");
                    marker.setAttributes(map);
                    PyBreakpoint br = new PyBreakpoint();
                    br.setMarker(marker);
                    IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                    breakpointManager.addBreakpoint((IBreakpoint)br);
                }
            };
            resource.getWorkspace().run(runnable, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void removeMarkers(List markers) {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        try {
            Iterator e = markers.iterator();
            while (e.hasNext()) {
                IBreakpoint breakpoint = breakpointManager.getBreakpoint((IMarker)e.next());
                breakpointManager.removeBreakpoint(breakpoint, true);
            }
        }
        catch (CoreException e) {
            PydevDebugPlugin.log(4, "error removing markers", e);
        }
    }
}

