/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.grammarcommon;

import java.io.IOException;
import org.python.pydev.core.REF;
import org.python.pydev.parser.grammarcommon.AbstractTokenManager;
import org.python.pydev.parser.grammarcommon.ITokenManager;
import org.python.pydev.parser.grammarcommon.TokensIterator;
import org.python.pydev.parser.jython.FastCharStream;
import org.python.pydev.parser.jython.Token;

public abstract class AbstractGrammarWalkHelpers {
    private AbstractTokenManager tokenManager;
    private TokensIterator tokensIterator;

    protected abstract Token getCurrentToken();

    protected abstract void setCurrentToken(Token var1);

    protected final AbstractTokenManager getTokenManager() {
        if (this.tokenManager == null) {
            this.tokenManager = (AbstractTokenManager)REF.getAttrObj((Object)this, (String)"token_source", (boolean)true);
        }
        return this.tokenManager;
    }

    protected static Token nextTokenConsideringNewLine(ITokenManager tokenManager) {
        boolean foundNewLine = AbstractGrammarWalkHelpers.searchNewLine(tokenManager, true);
        if (foundNewLine) {
            tokenManager.indenting(0);
        }
        Token nextToken = tokenManager.getNextToken();
        return nextToken;
    }

    protected static boolean searchNewLine(ITokenManager tokenManager, boolean breakOnFirstNotWhitespace) {
        boolean foundNewLine = false;
        FastCharStream inputStream = tokenManager.getInputStream();
        int currentPos = inputStream.getCurrentPos();
        try {
            try {
                char c;
                do {
                    if ((c = inputStream.readChar()) != '\r' && c != '\n') continue;
                    if (c == '\r' && (c = inputStream.readChar()) != '\n') {
                        inputStream.backup(1);
                    }
                    foundNewLine = true;
                    break;
                } while (!breakOnFirstNotWhitespace || Character.isWhitespace(c));
            }
            catch (IOException iOException) {}
        }
        finally {
            if (!foundNewLine) {
                inputStream.restorePos(currentPos);
            }
        }
        return foundNewLine;
    }

    protected final TokensIterator getTokensIterator(Token firstIterationToken, int tokensToIterate, boolean breakOnIndentsDedentsAndNewCompounds) {
        if (this.tokensIterator == null) {
            this.tokensIterator = new TokensIterator(this.getTokenManager(), firstIterationToken, tokensToIterate, breakOnIndentsDedentsAndNewCompounds);
        } else {
            this.tokensIterator.reset(this.getTokenManager(), firstIterationToken, tokensToIterate, breakOnIndentsDedentsAndNewCompounds);
        }
        return this.tokensIterator;
    }
}

