/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask;

import com.sun.javacard.jcasm.AppletDeclarator;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.mask.AppletInfo;
import com.sun.javacard.jcasm.mask.ComponentLocInfo;
import com.sun.javacard.jcasm.mask.CrefOutputFormatter;
import com.sun.javacard.jcasm.mask.Main;
import com.sun.javacard.jcasm.mask.PackageTableManager;
import java.util.StringTokenizer;

class PackageTableEntry {
    int PACKAGE_LOCATION_INFORMATION_SIZE = Main.FLAG_32_BIT ? 24 : 16;
    JCPackage packageInfo;
    static final int importCount = 0;
    static final int importedPkgsArrayRef = 0;
    int pkgAID;
    int pkgMinor;
    int pkgMajor;
    int staticRefFieldCount;
    int appletCount;
    AppletInfo[] applets;
    int pkgNameLength;
    byte[] pkgName;
    ComponentLocInfo[] componentInfoReference;
    int comInfoTableAddress;
    int appletIndex = 0;
    int appTableRef = 0;
    int nameArrayRef = 0;

    PackageTableEntry(JCPackage jCPackage) {
        this.packageInfo = jCPackage;
        PackageIdentifier packageIdentifier = jCPackage.getIdentifier();
        this.pkgMinor = packageIdentifier.getMinorVersion();
        this.pkgMajor = packageIdentifier.getMajorVersion();
        this.appletCount = jCPackage.appletCount();
        if (this.appletCount > 0) {
            this.applets = new AppletInfo[this.appletCount];
        }
        this.componentInfoReference = new ComponentLocInfo[4];
    }

    void setStaticRefFieldCount(int n) {
        this.staticRefFieldCount = n;
    }

    public static String[] getTokens(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken().trim();
        }
        return stringArray;
    }

    int getInstallParametersArrayObject(String string) {
        int n = CrefOutputFormatter.cof.currentRomAddr;
        String[] stringArray = PackageTableEntry.getTokens(string, ",");
        byte[] byArray = new byte[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.startsWith("0x")) {
                string2 = string2.substring(2);
                byArray[i] = (byte)(Integer.parseInt(string2, 16) & 0xFF);
                continue;
            }
            byArray[i] = (byte)(Integer.parseInt(string2) & 0xFF);
        }
        byte[] byArray2 = PackageTableManager.createByteArrayObject((short)byArray.length, byArray, (byte)0, true);
        int n2 = CrefOutputFormatter.objectManager.addObject(n);
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString(byArray2, ", ") + "," + Msg.eol);
        CrefOutputFormatter.cof.currentRomAddr = n + byArray2.length;
        return n2;
    }

    void setAppletInformation(AppletDeclarator appletDeclarator) {
        int n = 0;
        String string = this.packageInfo.getName() + "/" + appletDeclarator.getName();
        System.out.println(string);
        String string2 = CrefOutputFormatter.cof.getMapEntry(string + "__INSTALL_PARAMS");
        if (string2 != null) {
            CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append("/* Install parameters for Applet  " + string + " */" + Msg.eol);
            n = this.getInstallParametersArrayObject(string2);
        }
        byte[] byArray = appletDeclarator.getAid().toByteArray();
        JCMethod jCMethod = appletDeclarator.resolve();
        int n2 = jCMethod.getRelocAddr();
        if (n2 > Short.MAX_VALUE) {
            n2 = CrefOutputFormatter.exportedRefManager.getExportedReference(jCMethod);
        }
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append("/* AID for Applet in package " + this.packageInfo.getName() + " */" + Msg.eol);
        int n3 = PackageTableManager.createAIDObject(byArray, true);
        this.applets[this.appletIndex] = new AppletInfo(n3, n2, n);
        ++this.appletIndex;
    }

    void setPkgNameInfo(byte[] byArray) {
        this.pkgNameLength = byArray.length;
        this.pkgName = byArray;
    }

    void setPackageComponentLocation(int n, int n2, int n3) {
        this.componentInfoReference[n] = new ComponentLocInfo(n2, n3);
    }

    void addAppletInfoArrayToMask() {
        if (this.appletCount > 0) {
            byte[] byArray = new byte[10 + this.appletCount * 2];
            int n = 0;
            int n2 = 0;
            while (n < this.appletCount) {
                int n3 = this.applets[n].addToMask();
                byArray[10 + n2] = (byte)(n3 >> 8);
                byArray[10 + (n2 + 1)] = (byte)n3;
                ++n;
                n2 += 2;
            }
            PackageTableManager.createRefArrayObjectHeader(byArray, this.appletCount, (byte)0, PackageTableManager.appletEntryClassOffset, PackageTableManager.appletEntryPkgId);
            n = CrefOutputFormatter.cof.currentRomAddr;
            CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.eol + "/* Applet Table Information for " + this.packageInfo.getName() + "@" + Msg.toAddressString(n) + " */" + Msg.eol);
            for (n2 = 0; n2 < byArray.length; ++n2) {
                CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString(byArray[n2]) + ", ");
                if (n2 % 12 != 11) continue;
                CrefOutputFormatter.cof.rom.append(Msg.eol);
            }
            this.appTableRef = CrefOutputFormatter.objectManager.addObject(n);
            CrefOutputFormatter.cof.currentRomAddr += byArray.length;
        }
    }

    void addNameArrayToMask() {
        if (this.pkgNameLength > 0) {
            int n = CrefOutputFormatter.cof.currentRomAddr;
            byte[] byArray = PackageTableManager.createByteArrayObject((short)this.pkgNameLength, this.pkgName, (byte)0, false);
            CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.eol + "/* Package name array object for " + this.packageInfo.getName() + "@" + Msg.toAddressString(n) + " */" + Msg.eol);
            for (int i = 0; i < byArray.length; ++i) {
                CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString(byArray[i]) + ", ");
                if (i % 12 != 11) continue;
                CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.eol);
            }
            this.nameArrayRef = CrefOutputFormatter.objectManager.addObject(n);
            CrefOutputFormatter.cof.currentRomAddr += byArray.length;
        }
    }

    int addToMask() {
        this.addAppletInfoArrayToMask();
        this.addNameArrayToMask();
        int n = 0;
        byte[] byArray = new byte[5];
        PackageTableManager.createSimpleObjectHeader(byArray, PackageTableManager.packageEntryClassRef, (byte)0, false, PackageTableManager.pkgEntryPkgId);
        int n2 = CrefOutputFormatter.cof.currentRomAddr;
        int n3 = 5;
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.eol + "/* Package Table entry for " + this.packageInfo.getName() + "@" + Msg.toAddressString(n2) + " */ " + Msg.eol);
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString(byArray, ", ") + ",/*Header*/" + Msg.eol);
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)(this.pkgAID >> 8)) + " ,");
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)this.pkgAID) + " , /*AID reference*/" + Msg.eol);
        n3 += 2;
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)0) + " ,");
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)0) + " , /*imported packages info*/" + Msg.eol);
        n3 += 2;
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)(this.appTableRef >> 8)) + " , ");
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)this.appTableRef) + " , /*applet table ref*/" + Msg.eol);
        n3 += 2;
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)(this.nameArrayRef >> 8)) + " ,");
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)this.nameArrayRef) + " , /*Package Name Object Ref*/" + Msg.eol);
        n3 += 2;
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)this.pkgMinor) + ", " + "0x00, ");
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)this.pkgMajor) + ", " + "0x00, " + " /*Minor and Major versions*/" + Msg.eol);
        n3 += 4;
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)(this.staticRefFieldCount >> 8)) + " ,");
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)this.staticRefFieldCount) + " , /*Static ref field count*/" + Msg.eol);
        n3 += 2;
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)0) + ", " + "0x00, " + " /*import count*/" + Msg.eol);
        n3 += 2;
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)this.appletCount) + ", " + "0x00, " + "/*applet count*/" + Msg.eol);
        n3 += 2;
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)this.pkgNameLength) + ", " + "0x00, " + "/*Package Name Length*/" + Msg.eol);
        n = CrefOutputFormatter.objectManager.addObject(CrefOutputFormatter.cof.currentRomAddr);
        CrefOutputFormatter.cof.currentRomAddr += (n3 += 2);
        return n;
    }

    int addPackageLocInfoToMask(StringBuffer stringBuffer, int n) {
        this.comInfoTableAddress = n;
        stringBuffer.append("/* Component Location Structure for " + this.packageInfo.getName() + " @" + Msg.toAddressString(this.comInfoTableAddress) + " */" + Msg.eol);
        for (int i = 0; i < 4; ++i) {
            if (Main.FLAG_32_BIT) {
                stringBuffer.append(Msg.to32BitHexString(this.componentInfoReference[i].compLocation));
            } else {
                stringBuffer.append(Msg.to16BitHexString(this.componentInfoReference[i].compLocation));
            }
            stringBuffer.append(Msg.to16BitHexString(this.componentInfoReference[i].compSize));
            stringBuffer.append(Msg.eol);
        }
        return this.PACKAGE_LOCATION_INFORMATION_SIZE;
    }
}

