/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.PackageIdentifier;

public class VirtualMethodRefInfo
extends Info {
    protected int virtualMethodToken;

    VirtualMethodRefInfo(PackageIdentifier packageIdentifier, String string) {
        super(3, packageIdentifier, string, string.substring(string.lastIndexOf(40)));
    }

    VirtualMethodRefInfo(PackageIdentifier packageIdentifier, int n, int n2, String string) {
        super(3, packageIdentifier, n, string);
        this.virtualMethodToken = n2;
    }

    public int getVirtualMethodToken() {
        return this.virtualMethodToken;
    }

    @Override
    public byte[] toByteArray(JCPackage jCPackage) {
        byte[] byArray = super.toByteArray(jCPackage);
        if (this.isPackageInternal()) {
            JCMethod jCMethod = (JCMethod)this.resolvedTo;
            int n = jCMethod.getParentClass().getRelocAddr();
            byArray[1] = (byte)(n >> 8 & 0xFF);
            byArray[2] = (byte)(n & 0xFF);
            byArray[3] = (byte)jCMethod.getMethodIdentifier().getMethodToken();
        } else {
            byArray[1] = (byte)jCPackage.getPackageToken(this.packageIdentifier);
            byArray[1] = (byte)(byArray[1] | 0x80);
            byArray[2] = (byte)this.classToken;
            byArray[3] = (byte)this.virtualMethodToken;
        }
        return byArray;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("." + Integer.toHexString(this.virtualMethodToken));
        return stringBuffer.toString();
    }
}

