/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.plugins;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.text.Position;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmVirtualInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.plugins.CsmModificationRefactoringPlugin;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.ModificationResult;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionRef;
import org.openide.util.NbBundle;

public class CsmRenameRefactoringPlugin
extends CsmModificationRefactoringPlugin {
    private final RenameRefactoring refactoring;
    private Collection<CsmObject> referencedObjects;

    public CsmRenameRefactoringPlugin(RenameRefactoring rename) {
        super((AbstractRefactoring)rename);
        this.refactoring = rename;
    }

    @Override
    public Problem fastCheckParameters() {
        Problem fastCheckProblem = null;
        String newName = this.refactoring.getNewName();
        String oldName = CsmRefactoringUtils.getSimpleText(this.getStartReferenceObject());
        if (oldName.equals(newName)) {
            fastCheckProblem = CsmRenameRefactoringPlugin.createProblem(fastCheckProblem, true, CsmRenameRefactoringPlugin.getString("ERR_NameNotChanged"));
            return fastCheckProblem;
        }
        if (!CndLexerUtilities.isCppIdentifier((CharSequence)newName)) {
            String s = CsmRenameRefactoringPlugin.getString("ERR_InvalidIdentifier");
            String msg = new MessageFormat(s).format(new Object[]{newName});
            fastCheckProblem = CsmRenameRefactoringPlugin.createProblem(fastCheckProblem, true, msg);
            return fastCheckProblem;
        }
        return fastCheckProblem;
    }

    @Override
    public Problem preCheck() {
        Problem preCheckProblem = null;
        this.fireProgressListenerStart(1, 5);
        if (this.referencedObjects == null) {
            this.initReferencedObjects();
            this.fireProgressListenerStep();
        }
        if ((preCheckProblem = this.isResovledElement(this.getStartReferenceObject())) != null) {
            return preCheckProblem;
        }
        CsmObject directReferencedObject = CsmRefactoringUtils.getReferencedElement(this.getStartReferenceObject());
        preCheckProblem = this.checkIfModificationPossible(preCheckProblem, directReferencedObject, CsmRenameRefactoringPlugin.getString("ERR_Overrides_Fatal"), CsmRenameRefactoringPlugin.getString("ERR_OverridesOrOverriden"));
        this.fireProgressListenerStop();
        return preCheckProblem;
    }

    private static final String getString(String key) {
        return NbBundle.getMessage(CsmRenameRefactoringPlugin.class, (String)key);
    }

    private void initReferencedObjects() {
        CsmObject referencedObject = CsmRefactoringUtils.getReferencedElement(this.getStartReferenceObject());
        if (referencedObject != null) {
            this.referencedObjects = new LinkedHashSet<CsmObject>();
            if (CsmKindUtilities.isClass((CsmObject)referencedObject)) {
                this.referencedObjects.addAll(this.getRenamingClassObjects((CsmClass)referencedObject));
            } else if (CsmKindUtilities.isConstructor((CsmObject)referencedObject) || CsmKindUtilities.isDestructor((CsmObject)referencedObject)) {
                CsmFunction fun = (CsmFunction)referencedObject;
                CsmClass cls = CsmBaseUtilities.getFunctionClass((CsmFunction)fun);
                if (cls != null) {
                    this.referencedObjects.addAll(this.getRenamingClassObjects(cls));
                }
            } else if (CsmKindUtilities.isMethod((CsmObject)referencedObject)) {
                CsmMethod method = (CsmMethod)CsmBaseUtilities.getFunctionDeclaration((CsmFunction)((CsmFunction)referencedObject));
                this.referencedObjects.add((CsmObject)method);
                if (CsmVirtualInfoQuery.getDefault().isVirtual(method)) {
                    this.referencedObjects.addAll(CsmVirtualInfoQuery.getDefault().getOverriddenMethods(method, true));
                    assert (!this.referencedObjects.isEmpty()) : "must be at least start object " + method;
                }
            } else {
                this.referencedObjects.add(referencedObject);
            }
        }
    }

    @Override
    protected Collection<CsmFile> getRefactoredFiles() {
        Collection<CsmObject> objs = this.getRefactoredObjects();
        if (objs == null || objs.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<CsmFile> files = new HashSet<CsmFile>();
        CsmFile startFile = this.getStartCsmFile();
        for (CsmObject obj : objs) {
            Collection<CsmProject> prjs = CsmRefactoringUtils.getRelatedCsmProjects(obj, null);
            CsmProject[] ar = prjs.toArray(new CsmProject[prjs.size()]);
            this.refactoring.getContext().add((Object)ar);
            files.addAll(this.getRelevantFiles(startFile, obj, (AbstractRefactoring)this.refactoring));
        }
        return files;
    }

    private CsmFile getStartCsmFile() {
        CsmFile startFile = CsmRefactoringUtils.getCsmFile(this.getStartReferenceObject());
        if (startFile == null && this.getEditorContext() != null) {
            startFile = this.getEditorContext().getFile();
        }
        return startFile;
    }

    private Collection<CsmObject> getRefactoredObjects() {
        return this.referencedObjects == null ? Collections.emptyList() : Collections.unmodifiableCollection(this.referencedObjects);
    }

    private Collection<? extends CsmObject> getRenamingClassObjects(CsmClass clazz) {
        ArrayList<Object> out = new ArrayList<Object>(5);
        if (clazz != null) {
            out.add(clazz);
            for (CsmMember member : clazz.getMembers()) {
                if (CsmKindUtilities.isConstructor((CsmObject)member)) {
                    out.add(member);
                    continue;
                }
                if (!CsmKindUtilities.isDestructor((CsmObject)member)) continue;
                out.add(member);
            }
        }
        return out;
    }

    @Override
    protected final void processFile(CsmFile csmFile, ModificationResult mr, AtomicReference<Problem> outProblem) {
        Collection<CsmObject> refObjects = this.getRefactoredObjects();
        assert (refObjects != null && refObjects.size() > 0) : "method must be called for resolved element";
        FileObject fo = CsmUtilities.getFileObject((CsmFile)csmFile);
        LinkedHashSet refs = new LinkedHashSet();
        for (CsmObject obj : refObjects) {
            Collection curRefs = CsmReferenceRepository.getDefault().getReferences(obj, csmFile, CsmReferenceKind.ALL, null);
            refs.addAll(curRefs);
        }
        if (refs.size() > 0) {
            ArrayList<CsmReference> sortedRefs = new ArrayList<CsmReference>(refs);
            Collections.sort(sortedRefs, new Comparator<CsmReference>(){

                @Override
                public int compare(CsmReference o1, CsmReference o2) {
                    return o1.getStartOffset() - o2.getStartOffset();
                }
            });
            CloneableEditorSupport ces = CsmUtilities.findCloneableEditorSupport((CsmFile)csmFile);
            this.processRefactoredReferences(sortedRefs, fo, ces, mr);
        }
    }

    private void processRefactoredReferences(List<CsmReference> sortedRefs, FileObject fo, CloneableEditorSupport ces, ModificationResult mr) {
        String newName = this.refactoring.getNewName();
        for (CsmReference ref : sortedRefs) {
            String oldName = ((Object)ref.getText()).toString();
            String descr = this.getDescription(ref, oldName);
            ModificationResult.Difference diff = this.rename(ref, ces, oldName, newName, descr);
            assert (diff != null);
            mr.addDifference(fo, diff);
        }
    }

    private String getDescription(CsmReference ref, String targetName) {
        String out = NbBundle.getMessage(CsmRenameRefactoringPlugin.class, (String)"UpdateRef", (Object)targetName);
        return out;
    }

    private ModificationResult.Difference rename(CsmReference ref, CloneableEditorSupport ces, String oldName, String newName, String descr) {
        if (oldName == null) {
            oldName = ((Object)ref.getText()).toString();
        }
        if (newName == null) {
            newName = this.refactoring.getNewName();
        }
        assert (oldName != null);
        assert (newName != null);
        PositionRef startPos = ces.createPositionRef(ref.getStartOffset(), Position.Bias.Forward);
        PositionRef endPos = ces.createPositionRef(ref.getEndOffset(), Position.Bias.Backward);
        ModificationResult.Difference diff = new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, startPos, endPos, oldName, newName, descr);
        return diff;
    }
}

