/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.subpanels;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.ui.ClassDialog;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.ServiceProvidersTablePanel;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.security.proprietary.service.STSConfiguration;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.openide.util.NbBundle;

public class STSConfigServicePanel
extends JPanel {
    private Binding binding;
    private Project project;
    private boolean inSync = false;
    private DefaultFormatterFactory lifeTimeDff = null;
    private ConfigVersion cfgVersion = null;
    private JButton contractButton;
    private JLabel contractLabel;
    private JTextField contractTextField;
    private JCheckBox encryptKeyChBox;
    private JCheckBox encryptTokenChBox;
    private JTextField issuerField;
    private JLabel issuerLabel;
    private JLabel lifeTimeLabel;
    private JFormattedTextField lifeTimeTextField;
    private JPanel serviceProvidersPanel;

    public STSConfigServicePanel(Project project, Binding binding, ConfigVersion configVersion) {
        this.project = project;
        this.binding = binding;
        this.cfgVersion = configVersion;
        this.lifeTimeDff = new DefaultFormatterFactory();
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setParseIntegerOnly(true);
        numberFormat.setMaximumFractionDigits(0);
        NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
        numberFormatter.setCommitsOnValidEdit(true);
        numberFormatter.setMinimum(Integer.valueOf(0));
        this.lifeTimeDff.setDefaultFormatter(numberFormatter);
        this.initComponents();
        this.inSync = true;
        ServiceProvidersTablePanel.ServiceProvidersTableModel serviceProvidersTableModel = new ServiceProvidersTablePanel.ServiceProvidersTableModel();
        this.remove(this.serviceProvidersPanel);
        STSConfiguration sTSConfiguration = ProprietarySecurityPolicyModelHelper.getSTSConfiguration(binding);
        if (sTSConfiguration == null) {
            sTSConfiguration = ProprietarySecurityPolicyModelHelper.createSTSConfiguration(binding);
        }
        this.serviceProvidersPanel = new ServiceProvidersTablePanel(serviceProvidersTableModel, sTSConfiguration, configVersion);
        ((ServiceProvidersTablePanel)((Object)this.serviceProvidersPanel)).populateModel();
        this.inSync = false;
        this.sync();
    }

    private void sync() {
        String string;
        this.inSync = true;
        String string2 = ProprietarySecurityPolicyModelHelper.getSTSLifeTime(this.binding);
        if (string2 == null) {
            this.setLifeTime("300000");
            ProprietarySecurityPolicyModelHelper.setSTSLifeTime(this.binding, "300000");
        } else {
            this.setLifeTime(string2);
        }
        boolean bl = ProprietarySecurityPolicyModelHelper.getSTSEncryptKey(this.binding);
        this.setChBox(this.encryptKeyChBox, bl);
        boolean bl2 = ProprietarySecurityPolicyModelHelper.getSTSEncryptToken(this.binding);
        this.setChBox(this.encryptTokenChBox, bl2);
        String string3 = ProprietarySecurityPolicyModelHelper.getSTSIssuer(this.binding);
        if (string3 != null) {
            this.setIssuer(string3);
        }
        if ((string = ProprietarySecurityPolicyModelHelper.getSTSContractClass(this.binding)) == null) {
            this.setContractClass("com.sun.xml.ws.security.trust.impl.IssueSamlTokenContractImpl");
            ProprietarySecurityPolicyModelHelper.setSTSContractClass(this.binding, "com.sun.xml.ws.security.trust.impl.IssueSamlTokenContractImpl");
        } else {
            this.setContractClass(string);
        }
        this.refreshPanels();
        this.inSync = false;
    }

    private void setLifeTime(String string) {
        this.lifeTimeTextField.setText(string);
    }

    private void setIssuer(String string) {
        this.issuerField.setText(string);
    }

    private void setChBox(JCheckBox jCheckBox, Boolean bl) {
        if (bl == null) {
            jCheckBox.setSelected(false);
        } else {
            jCheckBox.setSelected(bl);
        }
    }

    private void setContractClass(String string) {
        this.contractTextField.setText(string);
    }

    private void refreshPanels() {
        this.updateLayout();
    }

    private void updateLayout() {
        GroupLayout groupLayout = (GroupLayout)this.getLayout();
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.serviceProvidersPanel, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(2, 2, 2).add((Component)this.lifeTimeLabel)).add((Component)this.contractLabel).add((Component)this.issuerLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lifeTimeTextField, -2, 90, -2).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0).add((Component)this.contractTextField, -1, 353, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.contractButton)).add((Component)this.issuerField, -1, 438, Short.MAX_VALUE)).add(10, 10, 10)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.encryptKeyChBox).addContainerGap(493, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.encryptTokenChBox).addContainerGap(483, Short.MAX_VALUE)))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.issuerLabel).add((Component)this.issuerField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.contractLabel).add((Component)this.contractButton).add((Component)this.contractTextField, -2, -1, -2)).add(8, 8, 8).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lifeTimeLabel).add((Component)this.lifeTimeTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.encryptKeyChBox).addPreferredGap(0).add((Component)this.encryptTokenChBox).addPreferredGap(0).add((Component)this.serviceProvidersPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void initComponents() {
        this.serviceProvidersPanel = new JPanel();
        this.lifeTimeLabel = new JLabel();
        this.contractLabel = new JLabel();
        this.contractTextField = new JTextField();
        this.contractButton = new JButton();
        this.issuerLabel = new JLabel();
        this.issuerField = new JTextField();
        this.encryptKeyChBox = new JCheckBox();
        this.encryptTokenChBox = new JCheckBox();
        this.lifeTimeTextField = new JFormattedTextField();
        this.serviceProvidersPanel.setAutoscrolls(true);
        GroupLayout groupLayout = new GroupLayout((Container)this.serviceProvidersPanel);
        this.serviceProvidersPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 648, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 90, Short.MAX_VALUE));
        this.lifeTimeLabel.setText(NbBundle.getMessage(STSConfigServicePanel.class, (String)"LBL_STSConfig_Lifetime"));
        this.contractLabel.setText(NbBundle.getMessage(STSConfigServicePanel.class, (String)"LBL_STSConfig_Contract"));
        this.contractTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                STSConfigServicePanel.this.contractTextFieldKeyReleased(keyEvent);
            }
        });
        this.contractButton.setText(NbBundle.getMessage(STSConfigServicePanel.class, (String)"LBL_STSConfig_Browse"));
        this.contractButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                STSConfigServicePanel.this.contractButtonActionPerformed(actionEvent);
            }
        });
        this.issuerLabel.setText(NbBundle.getMessage(STSConfigServicePanel.class, (String)"LBL_STSConfig_Issuer"));
        this.issuerField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                STSConfigServicePanel.this.issuerFieldKeyReleased(keyEvent);
            }
        });
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/websvc/wsitconf/ui/service/subpanels/Bundle");
        this.encryptKeyChBox.setText(resourceBundle.getString("LBL_STSConfig_EncryptKey"));
        this.encryptKeyChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.encryptKeyChBox.setMargin(new Insets(0, 0, 0, 0));
        this.encryptKeyChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                STSConfigServicePanel.this.encryptKeyChBoxActionPerformed(actionEvent);
            }
        });
        this.encryptTokenChBox.setText(resourceBundle.getString("LBL_STSConfig_EncryptToken"));
        this.encryptTokenChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.encryptTokenChBox.setMargin(new Insets(0, 0, 0, 0));
        this.encryptTokenChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                STSConfigServicePanel.this.encryptTokenChBoxActionPerformed(actionEvent);
            }
        });
        this.lifeTimeTextField.setFormatterFactory(this.lifeTimeDff);
        this.lifeTimeTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                STSConfigServicePanel.this.lifeTimeTextFieldKeyReleased(keyEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.serviceProvidersPanel, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(2, 2, 2).add((Component)this.lifeTimeLabel)).add((Component)this.contractLabel).add((Component)this.issuerLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.issuerField, -1, 446, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.lifeTimeTextField, -2, 95, -2).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.contractTextField, -1, 353, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.contractButton))))).add(10, 10, 10)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.encryptKeyChBox).addContainerGap(523, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.encryptTokenChBox).addContainerGap(509, Short.MAX_VALUE)))));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.issuerLabel).add((Component)this.issuerField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.contractLabel).add((Component)this.contractButton).add((Component)this.contractTextField, -2, -1, -2)).add(8, 8, 8).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.lifeTimeLabel).add((Component)this.lifeTimeTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.encryptKeyChBox).addPreferredGap(0).add((Component)this.encryptTokenChBox).addPreferredGap(0).add((Component)this.serviceProvidersPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void lifeTimeTextFieldKeyReleased(KeyEvent keyEvent) {
        Object object = this.lifeTimeTextField.getValue();
        if (object instanceof Integer) {
            String string = object.toString();
            ProprietarySecurityPolicyModelHelper.setSTSLifeTime(this.binding, string);
        }
    }

    private void encryptTokenChBoxActionPerformed(ActionEvent actionEvent) {
        ProprietarySecurityPolicyModelHelper.setSTSEncryptToken(this.binding, this.encryptTokenChBox.isSelected());
    }

    private void encryptKeyChBoxActionPerformed(ActionEvent actionEvent) {
        ProprietarySecurityPolicyModelHelper.setSTSEncryptKey(this.binding, this.encryptKeyChBox.isSelected());
    }

    private void contractTextFieldKeyReleased(KeyEvent keyEvent) {
        String string = this.contractTextField.getText();
        ProprietarySecurityPolicyModelHelper.setSTSContractClass(this.binding, string);
    }

    private void issuerFieldKeyReleased(KeyEvent keyEvent) {
        String string = this.issuerField.getText();
        ProprietarySecurityPolicyModelHelper.setSTSIssuer(this.binding, string);
    }

    private void contractButtonActionPerformed(ActionEvent actionEvent) {
        block1: {
            Set<String> set;
            Iterator<String> iterator;
            if (this.project == null) break block1;
            ClassDialog classDialog = new ClassDialog(this.project, "com.sun.xml.ws.trust.WSTrustContract");
            classDialog.show();
            if (classDialog.okButtonPressed() && (iterator = (set = classDialog.getSelectedClasses()).iterator()).hasNext()) {
                String string = iterator.next();
                this.setContractClass(string);
                ProprietarySecurityPolicyModelHelper.setSTSContractClass(this.binding, string);
            }
        }
    }
}

