/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.io.CharArrayReader;
import java.io.IOException;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.tools.JavaFileObject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.NullUnknown;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.PositionConverter;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.source.builder.TreeFactory;
import org.netbeans.modules.java.source.engine.SourceReader;
import org.netbeans.modules.java.source.engine.SourceRewriter;
import org.netbeans.modules.java.source.parsing.CompilationInfoImpl;
import org.netbeans.modules.java.source.parsing.JavacParserResult;
import org.netbeans.modules.java.source.pretty.ImportAnalysis2;
import org.netbeans.modules.java.source.pretty.VeryPretty;
import org.netbeans.modules.java.source.save.CasualDiff;
import org.netbeans.modules.java.source.transform.ImmutableTreeTranslator;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class WorkingCopy
extends CompilationController {
    static Reference<WorkingCopy> instance;
    private Map<Tree, Tree> changes;
    private Map<JavaFileObject, CompilationUnitTree> externalChanges;
    private Set<CasualDiff.Diff> textualChanges;
    private Map<Integer, String> userInfo;
    private boolean afterCommit = false;
    private TreeMaker treeMaker;
    private Map<Tree, Object> tree2Tag;
    private static boolean REWRITE_WHOLE_FILE;

    WorkingCopy(CompilationInfoImpl impl) {
        super(impl);
    }

    private synchronized void init() {
        if (this.changes != null) {
            return;
        }
        this.treeMaker = new TreeMaker(this, TreeFactory.instance(this.getContext()));
        this.changes = new IdentityHashMap<Tree, Tree>();
        this.tree2Tag = new IdentityHashMap<Tree, Object>();
        this.externalChanges = null;
        this.textualChanges = new HashSet<CasualDiff.Diff>();
        this.userInfo = new HashMap<Integer, String>();
    }

    private Context getContext() {
        return this.impl.getJavacTask().getContext();
    }

    @NullUnknown
    public static WorkingCopy get(@NonNull Parser.Result result) {
        JavacParserResult javacResult;
        CompilationController controller;
        WorkingCopy copy;
        Parameters.notNull((CharSequence)"result", (Object)result);
        WorkingCopy workingCopy = copy = instance != null ? instance.get() : null;
        if (copy != null && result instanceof JavacParserResult && (controller = (javacResult = (JavacParserResult)result).get(CompilationController.class)) != null && controller.impl == copy.impl) {
            return copy;
        }
        return null;
    }

    @Override
    @NonNull
    public JavaSource.Phase toPhase(@NonNull JavaSource.Phase phase) throws IOException {
        JavaSource.Phase result = super.toPhase(phase);
        if (result.compareTo(JavaSource.Phase.PARSED) >= 0) {
            this.init();
        }
        return result;
    }

    @NonNull
    public synchronized TreeMaker getTreeMaker() throws IllegalStateException {
        this.checkConfinement();
        if (this.treeMaker == null) {
            throw new IllegalStateException("Cannot call getTreeMaker before toPhase.");
        }
        return this.treeMaker;
    }

    Map<Tree, Tree> getChangeSet() {
        return this.changes;
    }

    public synchronized void rewrite(@NullAllowed Tree oldTree, @NonNull Tree newTree) {
        this.checkConfinement();
        if (this.changes == null) {
            throw new IllegalStateException("Cannot call rewrite before toPhase.");
        }
        if (oldTree == newTree) {
            return;
        }
        if (oldTree == null && Tree.Kind.COMPILATION_UNIT == newTree.getKind()) {
            this.createCompilationUnit((JCTree.JCCompilationUnit)newTree);
            return;
        }
        if (oldTree == null || newTree == null) {
            throw new IllegalArgumentException("Null values are not allowed.");
        }
        this.changes.put(oldTree, newTree);
    }

    public synchronized void rewriteInComment(int start, int length, @NonNull String newText) throws IllegalArgumentException {
        int commentSuffix;
        int commentPrefix;
        this.checkConfinement();
        TokenSequence ts = this.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        ts.move(start);
        if (!ts.moveNext()) {
            throw new IllegalArgumentException("Cannot rewriteInComment start=" + start + ", text length=" + this.getText().length());
        }
        if (ts.token().id() != JavaTokenId.LINE_COMMENT && ts.token().id() != JavaTokenId.BLOCK_COMMENT && ts.token().id() != JavaTokenId.JAVADOC_COMMENT) {
            throw new IllegalArgumentException("Cannot rewriteInComment: attempt to rewrite non-comment token: " + ts.token().id());
        }
        if (ts.offset() + ts.token().length() < start + length) {
            throw new IllegalArgumentException("Cannot rewriteInComment: attempt to rewrite text after comment token. Token end offset: " + (ts.offset() + ts.token().length()) + ", rewrite end offset: " + (start + length));
        }
        switch ((JavaTokenId)ts.token().id()) {
            case LINE_COMMENT: {
                commentPrefix = 2;
                commentSuffix = 0;
                break;
            }
            case BLOCK_COMMENT: {
                commentPrefix = 2;
                commentSuffix = 2;
                break;
            }
            case JAVADOC_COMMENT: {
                commentPrefix = 3;
                commentSuffix = 2;
                break;
            }
            default: {
                throw new IllegalStateException("Internal error");
            }
        }
        if (ts.offset() + commentPrefix > start) {
            throw new IllegalArgumentException("Cannot rewriteInComment: attempt to rewrite comment prefix");
        }
        if (ts.offset() + ts.token().length() - commentSuffix < start + length) {
            throw new IllegalArgumentException("Cannot rewriteInComment: attempt to rewrite comment suffix");
        }
        this.textualChanges.add(CasualDiff.Diff.delete(start, start + length));
        this.textualChanges.add(CasualDiff.Diff.insert(start + length, newText));
        this.userInfo.put(start, NbBundle.getMessage(CasualDiff.class, (String)"TXT_RenameInComment"));
    }

    public synchronized void tag(@NonNull Tree t, @NonNull Object tag) {
        this.tree2Tag.put(t, tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void commit(CompilationUnitTree topLevel, List<CasualDiff.Diff> diffs, SourceRewriter out) throws IOException, BadLocationException {
        CharArrayReader in = null;
        try {
            String s = ((Object)((JCTree.JCCompilationUnit)topLevel).sourcefile.getCharContent(true)).toString();
            char[] buf = s.toCharArray();
            in = new SourceReader(buf);
            block7: for (CasualDiff.Diff d : diffs) {
                switch (d.type) {
                    case INSERT: {
                        out.copyTo((SourceReader)in, d.getPos());
                        out.writeTo(d.getText());
                        continue block7;
                    }
                    case DELETE: {
                        out.copyTo((SourceReader)in, d.getPos());
                        out.skipThrough((SourceReader)in, d.getEnd());
                        continue block7;
                    }
                }
                throw new AssertionError((Object)("unknown CasualDiff type: " + (Object)((Object)d.type)));
            }
            out.copyRest((SourceReader)in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private List<ModificationResult.Difference> processCurrentCompilationUnit(Map<?, int[]> tag2Span) throws IOException, BadLocationException {
        List<? extends ImportTree> nueImports;
        final LinkedHashSet<TreePath> pathsToRewrite = new LinkedHashSet<TreePath>();
        final IdentityHashMap<TreePath, Map<Tree, Tree>> parent2Rewrites = new IdentityHashMap<TreePath, Map<Tree, Tree>>();
        boolean fillImports = true;
        HashMap<Integer, String> userInfo = new HashMap<Integer, String>();
        if (!REWRITE_WHOLE_FILE) {
            new TreePathScanner<Void, Void>(){
                private TreePath currentParent;
                private Map<Tree, TreePath> tree2Path = new IdentityHashMap<Tree, TreePath>();

                private TreePath getParentPath(TreePath tp, Tree t) {
                    Tree parent = tp != null ? tp.getLeaf() : t;
                    TreePath c = this.tree2Path.get(parent);
                    if (c == null) {
                        c = tp != null ? tp : new TreePath((CompilationUnitTree)t);
                        this.tree2Path.put(parent, c);
                    }
                    return c;
                }

                @Override
                public Void scan(Tree tree, Void p) {
                    boolean clearCurrentParent = false;
                    if (WorkingCopy.this.changes.containsKey(tree)) {
                        if (this.currentParent == null) {
                            clearCurrentParent = true;
                            this.currentParent = this.getParentPath(this.getCurrentPath(), tree);
                            pathsToRewrite.add(this.currentParent);
                            if (!parent2Rewrites.containsKey(this.currentParent)) {
                                parent2Rewrites.put(this.currentParent, new IdentityHashMap());
                            }
                        }
                        Map rewrites = (Map)parent2Rewrites.get(this.currentParent);
                        Tree rev = (Tree)WorkingCopy.this.changes.remove(tree);
                        rewrites.put(tree, rev);
                        this.scan(rev, p);
                        if (clearCurrentParent) {
                            this.currentParent = null;
                        }
                    } else {
                        super.scan(tree, p);
                    }
                    return null;
                }
            }.scan((Tree)this.getCompilationUnit(), (Void)null);
        } else {
            TreePath topLevel = new TreePath(this.getCompilationUnit());
            pathsToRewrite.add(topLevel);
            parent2Rewrites.put(topLevel, this.changes);
            fillImports = false;
        }
        ArrayList<CasualDiff.Diff> diffs = new ArrayList<CasualDiff.Diff>();
        ImportAnalysis2 ia = new ImportAnalysis2(this.getContext());
        boolean importsFilled = false;
        for (TreePath path : pathsToRewrite) {
            Translator translator = new Translator();
            ArrayList<ClassTree> classes = new ArrayList<ClassTree>();
            if (path.getParentPath() != null) {
                for (Tree t : path) {
                    if (t.getKind() == Tree.Kind.COMPILATION_UNIT && !importsFilled) {
                        CompilationUnitTree cut = (CompilationUnitTree)t;
                        ia.setPackage(cut.getPackageName());
                        ia.setImports(cut.getImports());
                        importsFilled = true;
                    }
                    if (t.getKind() != Tree.Kind.CLASS) continue;
                    classes.add((ClassTree)t);
                }
            }
            Collections.reverse(classes);
            for (ClassTree ct : classes) {
                ia.classEntered(ct);
            }
            translator.attach(this.getContext(), ia, this.getCompilationUnit(), this.tree2Tag);
            Tree brandNew = translator.translate(path.getLeaf(), (Map)parent2Rewrites.get(path));
            for (ClassTree ct : classes) {
                ia.classLeft();
            }
            if (brandNew.getKind() == Tree.Kind.COMPILATION_UNIT) {
                fillImports = false;
            }
            diffs.addAll(CasualDiff.diff(this.getContext(), this, path, (JCTree)brandNew, userInfo, this.tree2Tag, tag2Span));
        }
        if (fillImports && (nueImports = ia.getImports()) != null) {
            diffs.addAll(CasualDiff.diff(this.getContext(), this, this.getCompilationUnit().getImports(), nueImports, userInfo, this.tree2Tag, tag2Span));
        }
        diffs.addAll(this.textualChanges);
        userInfo.putAll(this.userInfo);
        Collections.sort(diffs, new Comparator<CasualDiff.Diff>(){

            @Override
            public int compare(CasualDiff.Diff o1, CasualDiff.Diff o2) {
                return o1.getPos() - o2.getPos();
            }
        });
        Rewriter r = new Rewriter(this.getFileObject(), this.getPositionConverter(), userInfo);
        WorkingCopy.commit(this.getCompilationUnit(), diffs, r);
        return r.diffs;
    }

    private List<ModificationResult.Difference> processExternalCUs() {
        if (this.externalChanges == null) {
            return Collections.emptyList();
        }
        LinkedList<ModificationResult.Difference> result = new LinkedList<ModificationResult.Difference>();
        for (CompilationUnitTree t : this.externalChanges.values()) {
            Translator translator = new Translator();
            translator.attach(this.getContext(), new ImportAnalysis2(this.getContext()), t, this.tree2Tag);
            CompilationUnitTree nue = (CompilationUnitTree)translator.translate(t, this.changes);
            VeryPretty printer = new VeryPretty(this, VeryPretty.getCodeStyle(this));
            printer.print((JCTree.JCCompilationUnit)nue);
            result.add(new ModificationResult.CreateChange(nue.getSourceFile(), printer.toString()));
        }
        return result;
    }

    List<ModificationResult.Difference> getChanges(Map<?, int[]> tag2Span) throws IOException, BadLocationException {
        if (this.afterCommit) {
            throw new IllegalStateException("The commit method can be called only once on a WorkingCopy instance");
        }
        this.afterCommit = true;
        if (this.changes == null) {
            return null;
        }
        LinkedList<ModificationResult.Difference> result = new LinkedList<ModificationResult.Difference>();
        result.addAll(this.processCurrentCompilationUnit(tag2Span));
        result.addAll(this.processExternalCUs());
        return result;
    }

    private void createCompilationUnit(JCTree.JCCompilationUnit unitTree) {
        if (this.externalChanges == null) {
            this.externalChanges = new HashMap<JavaFileObject, CompilationUnitTree>();
        }
        this.externalChanges.put(unitTree.getSourceFile(), unitTree);
    }

    static {
        REWRITE_WHOLE_FILE = Boolean.getBoolean(WorkingCopy.class.getName() + ".rewrite-whole-file");
    }

    private static class Rewriter
    implements SourceRewriter {
        private int offset = 0;
        private CloneableEditorSupport ces;
        private PositionConverter converter;
        private List<ModificationResult.Difference> diffs = new LinkedList<ModificationResult.Difference>();
        private Map<Integer, String> userInfo;

        public Rewriter(FileObject fo, PositionConverter converter, Map<Integer, String> userInfo) throws IOException {
            this.converter = converter;
            this.userInfo = userInfo;
            if (fo != null) {
                DataObject dObj = DataObject.find((FileObject)fo);
                CloneableEditorSupport cloneableEditorSupport = this.ces = dObj != null ? (CloneableEditorSupport)dObj.getCookie(EditorCookie.class) : null;
            }
            if (this.ces == null) {
                throw new IOException("Could not find CloneableEditorSupport for " + FileUtil.getFileDisplayName((FileObject)fo));
            }
        }

        @Override
        public void writeTo(String s) throws IOException, BadLocationException {
            ModificationResult.Difference diff;
            ModificationResult.Difference difference = diff = this.diffs.size() > 0 ? this.diffs.get(this.diffs.size() - 1) : null;
            if (diff != null && diff.getKind() == ModificationResult.Difference.Kind.REMOVE && diff.getEndPosition().getOffset() == this.offset) {
                diff.kind = ModificationResult.Difference.Kind.CHANGE;
                diff.newText = s;
            } else {
                int off;
                int n = off = this.converter != null ? this.converter.getOriginalPosition(this.offset) : this.offset;
                if (off >= 0) {
                    this.diffs.add(new ModificationResult.Difference(ModificationResult.Difference.Kind.INSERT, this.ces.createPositionRef(off, Position.Bias.Forward), this.ces.createPositionRef(off, Position.Bias.Backward), null, s, this.userInfo.get(this.offset)));
                }
            }
        }

        @Override
        public void skipThrough(SourceReader in, int pos) throws IOException, BadLocationException {
            ModificationResult.Difference diff;
            char[] buf = in.getCharsTo(pos);
            ModificationResult.Difference difference = diff = this.diffs.size() > 0 ? this.diffs.get(this.diffs.size() - 1) : null;
            if (diff != null && diff.getKind() == ModificationResult.Difference.Kind.INSERT && diff.getStartPosition().getOffset() == this.offset) {
                diff.kind = ModificationResult.Difference.Kind.CHANGE;
                diff.oldText = new String(buf);
            } else {
                int off;
                int n = off = this.converter != null ? this.converter.getOriginalPosition(this.offset) : this.offset;
                if (off >= 0) {
                    this.diffs.add(new ModificationResult.Difference(ModificationResult.Difference.Kind.REMOVE, this.ces.createPositionRef(off, Position.Bias.Forward), this.ces.createPositionRef(off + buf.length, Position.Bias.Backward), new String(buf), null, this.userInfo.get(this.offset)));
                }
            }
            this.offset += buf.length;
        }

        @Override
        public void copyTo(SourceReader in, int pos) throws IOException {
            char[] buf = in.getCharsTo(pos);
            this.offset += buf.length;
        }

        @Override
        public void copyRest(SourceReader in) throws IOException {
        }

        @Override
        public void close(boolean save) {
        }
    }

    class Translator
    extends ImmutableTreeTranslator {
        private Map<Tree, Tree> changeMap;

        Translator() {
        }

        Tree translate(Tree tree, Map<Tree, Tree> changeMap) {
            this.changeMap = new HashMap<Tree, Tree>(changeMap);
            return this.translate(tree);
        }

        @Override
        public Tree translate(Tree tree) {
            assert (this.changeMap != null);
            if (tree == null) {
                return null;
            }
            Tree repl = this.changeMap.remove(tree);
            Tree newRepl = repl != null ? this.translate(repl) : super.translate(tree);
            return newRepl;
        }
    }
}

