/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.j2ee.wizard;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;

public class MasterDetailGenerator {
    private static final String LABEL_TEMPLATE = "LABEL_TEMPLATE";
    private static final String FIELD_TEMPLATE = "FIELD_TEMPLATE";
    private static final String MASTER_SUBBINDING_TEMPLATE = "MASTER_SUBBINDING_TEMPLATE";
    private static final String DETAIL_SUBBINDING_TEMPLATE = "DETAIL_SUBBINDING_TEMPLATE";
    private static final String V_LAYOUT_TEMPLATE = "V_LAYOUT_TEMPLATE";
    private static final String LABEL_H_LAYOUT_TEMPLATE = "LABEL_H_LAYOUT_TEMPLATE";
    private static final String FIELD_H_LAYOUT_TEMPLATE = "FIELD_H_LAYOUT_TEMPLATE";
    private static final String DETAIL_ONLY = "DETAIL_ONLY";
    private static final String MASTER_ONLY = "MASTER_ONLY";
    private static final String JDK6ONLY = "JDK6ONLY";
    private FileObject formFile;
    private FileObject javaFile;
    private String masterClass;
    private String detailClass;
    private String masterEntity;
    private String detailEntity;
    private String joinProperty;
    private String joinCollectionProperty;
    private String unit;
    private List<String> masterColumns;
    private List<String> detailColumns;
    private List<String> masterColumnTypes;
    private List<String> detailColumnTypes;

    MasterDetailGenerator(FileObject fileObject, FileObject fileObject2, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.formFile = fileObject;
        this.javaFile = fileObject2;
        this.masterClass = string;
        this.detailClass = string2;
        this.masterEntity = string3;
        this.detailEntity = string4;
        this.joinProperty = string5;
        this.joinCollectionProperty = string6;
        this.unit = string7;
    }

    void setMasterColumns(List<String> list) {
        this.masterColumns = list;
    }

    void setMasterColumnTypes(List<String> list) {
        this.masterColumnTypes = list;
    }

    void setDetailColumns(List<String> list) {
        this.detailColumns = list;
    }

    void setDetailColumnTypes(List<String> list) {
        this.detailColumnTypes = list;
    }

    void generate() throws IOException {
        String string = "UTF-8";
        String string2 = FileEncodingQuery.getDefaultEncoding().name();
        String string3 = MasterDetailGenerator.read(this.formFile, string);
        String string4 = MasterDetailGenerator.read(this.javaFile, string2);
        Map<String, String> map = this.replacements();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            string3 = string3.replace(entry.getKey(), entry.getValue());
            string4 = string4.replace(entry.getKey(), entry.getValue());
        }
        string3 = this.generateMasterColumns(string3);
        if (this.detailEntity == null) {
            string3 = this.generateLabels(string3);
            string3 = this.generateFields(string3);
            string3 = this.generateVLayout(string3);
            string3 = this.generateLabelsHLayout(string3);
            string3 = this.generateFieldsHLayout(string3);
            string3 = MasterDetailGenerator.deleteSections(string3, DETAIL_ONLY, false, false);
            string3 = MasterDetailGenerator.deleteSections(string3, MASTER_ONLY, true, false);
            string4 = MasterDetailGenerator.deleteSections(string4, DETAIL_ONLY, false, true);
        } else {
            string3 = this.generateDetailColumns(string3);
            string4 = MasterDetailGenerator.deleteSections(string4, DETAIL_ONLY, true, true);
            string3 = MasterDetailGenerator.deleteSections(string3, MASTER_ONLY, false, false);
            string3 = MasterDetailGenerator.deleteSections(string3, DETAIL_ONLY, true, false);
        }
        string4 = MasterDetailGenerator.deleteSections(string4, JDK6ONLY, ClassPathUtils.isJava6ProjectPlatform((FileObject)this.javaFile), true);
        MasterDetailGenerator.write(this.formFile, string3, string);
        MasterDetailGenerator.write(this.javaFile, string4, string2);
    }

    private String generateMasterColumns(String string) {
        String string2 = MasterDetailGenerator.findTemplate(string, MASTER_SUBBINDING_TEMPLATE);
        int n = string.indexOf(string2);
        string = string.substring(0, n) + string.substring(n + string2.length());
        string2 = MasterDetailGenerator.uncomment(string2, false);
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        Iterator<String> iterator = this.masterColumnTypes.iterator();
        for (String string3 : this.masterColumns) {
            String string4;
            String string5 = string2.replace("_index_", "" + n2++);
            string5 = string5.replace("_fieldName_", string3);
            String string6 = string4 = iterator.hasNext() ? iterator.next() : null;
            if (string4 == null) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Cannot determine type of {0} property!", string3);
                string4 = "Object.class";
            }
            string5 = string5.replace("_fieldType_", string4);
            stringBuilder.append(string5);
        }
        StringBuilder stringBuilder2 = new StringBuilder(string);
        stringBuilder2.insert(n, stringBuilder.toString());
        return stringBuilder2.toString();
    }

    private String generateDetailColumns(String string) {
        String string2 = MasterDetailGenerator.findTemplate(string, DETAIL_SUBBINDING_TEMPLATE);
        int n = string.indexOf(string2);
        string = string.substring(0, n) + string.substring(n + string2.length());
        string2 = MasterDetailGenerator.uncomment(string2, false);
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        Iterator<String> iterator = this.detailColumnTypes.iterator();
        for (String string3 : this.detailColumns) {
            String string4 = string2.replace("_index_", "" + n2++);
            string4 = string4.replace("_fieldName_", string3);
            string4 = string4.replace("_fieldType_", iterator.next());
            stringBuilder.append(string4);
        }
        StringBuilder stringBuilder2 = new StringBuilder(string);
        stringBuilder2.insert(n, stringBuilder.toString());
        return stringBuilder2.toString();
    }

    private String generateLabels(String string) {
        String string2 = MasterDetailGenerator.findTemplate(string, LABEL_TEMPLATE);
        int n = string.indexOf(string2);
        string = string.substring(0, n) + string.substring(n + string2.length());
        string2 = MasterDetailGenerator.uncomment(string2, false);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : this.detailColumns) {
            String string4 = string2.replace("_labelName_", MasterDetailGenerator.columnToLabelName(string3));
            string4 = string4.replace("_labelText_", MasterDetailGenerator.capitalize(string3));
            stringBuilder.append(string4);
        }
        StringBuilder stringBuilder2 = new StringBuilder(string);
        stringBuilder2.insert(n, stringBuilder.toString());
        return stringBuilder2.toString();
    }

    private String generateFields(String string) {
        String string2 = MasterDetailGenerator.findTemplate(string, FIELD_TEMPLATE);
        int n = string.indexOf(string2);
        string = string.substring(0, n) + string.substring(n + string2.length());
        string2 = MasterDetailGenerator.uncomment(string2, false);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : this.detailColumns) {
            String string4 = string2.replace("_textFieldName_", MasterDetailGenerator.columnToFieldName(string3));
            string4 = string4.replace("_fieldName_", string3);
            stringBuilder.append(string4);
        }
        StringBuilder stringBuilder2 = new StringBuilder(string);
        stringBuilder2.insert(n, stringBuilder.toString());
        return stringBuilder2.toString();
    }

    private String generateVLayout(String string) {
        String string2 = MasterDetailGenerator.findTemplate(string, V_LAYOUT_TEMPLATE);
        int n = string.indexOf(string2);
        string = string.substring(0, n) + string.substring(n + string2.length());
        string2 = MasterDetailGenerator.uncomment(string2, false);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : this.detailColumns) {
            String string4 = string2.replace("_labelName_", MasterDetailGenerator.columnToLabelName(string3));
            string4 = string4.replace("_textFieldName_", MasterDetailGenerator.columnToFieldName(string3));
            stringBuilder.append(string4);
        }
        StringBuilder stringBuilder2 = new StringBuilder(string);
        stringBuilder2.insert(n, stringBuilder.toString());
        return stringBuilder2.toString();
    }

    private String generateLabelsHLayout(String string) {
        String string2 = MasterDetailGenerator.findTemplate(string, LABEL_H_LAYOUT_TEMPLATE);
        int n = string.indexOf(string2);
        string = string.substring(0, n) + string.substring(n + string2.length());
        string2 = MasterDetailGenerator.uncomment(string2, false);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : this.detailColumns) {
            String string4 = string2.replace("_labelName_", MasterDetailGenerator.columnToLabelName(string3));
            stringBuilder.append(string4);
        }
        StringBuilder stringBuilder2 = new StringBuilder(string);
        stringBuilder2.insert(n, stringBuilder.toString());
        return stringBuilder2.toString();
    }

    private String generateFieldsHLayout(String string) {
        String string2 = MasterDetailGenerator.findTemplate(string, FIELD_H_LAYOUT_TEMPLATE);
        int n = string.indexOf(string2);
        string = string.substring(0, n) + string.substring(n + string2.length());
        string2 = MasterDetailGenerator.uncomment(string2, false);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : this.detailColumns) {
            String string4 = string2.replace("_textFieldName_", MasterDetailGenerator.columnToFieldName(string3));
            stringBuilder.append(string4);
        }
        StringBuilder stringBuilder2 = new StringBuilder(string);
        stringBuilder2.insert(n, stringBuilder.toString());
        return stringBuilder2.toString();
    }

    private static String deleteSections(String string, String string2, boolean bl, boolean bl2) {
        String string3 = MasterDetailGenerator.comment(string2, bl2);
        if (bl) {
            int n;
            while ((n = string.indexOf(string3)) != -1) {
                string = string.substring(0, n) + string.substring(n + string3.length());
            }
        } else {
            int n;
            while ((n = string.indexOf(string3)) != -1) {
                int n2 = string.indexOf(string3, n + 1);
                assert (n2 != -1);
                string = string.substring(0, n) + string.substring(n2 + string3.length());
            }
        }
        return string;
    }

    private static String comment(String string, boolean bl) {
        String string2 = bl ? "/*" : "<!--";
        String string3 = bl ? "*/" : "-->";
        return string2 + " " + string + " " + string3;
    }

    private static String uncomment(String string, boolean bl) {
        String string2 = bl ? "/*" : "<!--";
        String string3 = bl ? "*/" : "-->";
        int n = string.indexOf(string3);
        int n2 = string.lastIndexOf(string2);
        return string.substring(n + string2.length(), n2);
    }

    private static String columnToLabelName(String string) {
        return string + "Label";
    }

    private static String columnToFieldName(String string) {
        return string + "Field";
    }

    private static String read(FileObject fileObject, String string) throws IOException {
        String string2;
        InputStream inputStream = fileObject.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
        StringBuilder stringBuilder = new StringBuilder();
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuilder.append(string2).append('\n');
        }
        bufferedReader.close();
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(FileObject fileObject, String string, String string2) throws IOException {
        FileLock fileLock = fileObject.lock();
        try {
            OutputStream outputStream = fileObject.getOutputStream(fileLock);
            outputStream.write(string.getBytes(string2));
            outputStream.close();
        }
        finally {
            fileLock.releaseLock();
        }
    }

    private Map<String, String> replacements() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("_masterClass_", this.masterClass);
        hashMap.put("_masterEntity_", this.masterEntity);
        char c = Character.toLowerCase(this.masterEntity.charAt(0));
        hashMap.put("_unitName_", this.unit);
        if (this.detailClass != null) {
            hashMap.put("_detailClass_", this.detailClass);
            hashMap.put("_detailEntity_", this.detailEntity);
            char c2 = Character.toLowerCase(this.detailEntity.charAt(0));
            hashMap.put("_detailEntityInitial_", Character.toString(c2));
            if (c2 == c) {
                c = Character.toUpperCase(c);
            }
            if (this.joinCollectionProperty != null) {
                hashMap.put("_joinCollection_", this.joinCollectionProperty);
                hashMap.put("_joinCollectionCapital_", Character.toUpperCase(this.joinCollectionProperty.charAt(0)) + this.joinCollectionProperty.substring(1));
            }
            if (this.joinProperty != null) {
                hashMap.put("_joinCapital_", Character.toUpperCase(this.joinProperty.charAt(0)) + this.joinProperty.substring(1));
            }
        }
        hashMap.put("_masterEntityInitial_", Character.toString(c));
        return hashMap;
    }

    private static String findTemplate(String string, String string2) {
        String string3 = MasterDetailGenerator.comment(string2, false);
        int n = string.indexOf(string3);
        int n2 = string.lastIndexOf(string3);
        return string.substring(n, n2 + string3.length());
    }

    private static String capitalize(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        boolean bl = false;
        for (int i = 0; i < stringBuilder.length(); ++i) {
            char c = stringBuilder.charAt(i);
            if (i == 0) {
                stringBuilder.setCharAt(i, Character.toUpperCase(c));
                bl = true;
                continue;
            }
            if (Character.isUpperCase(c)) {
                if (!bl) {
                    stringBuilder.insert(i, ' ');
                }
                bl = true;
                ++i;
                continue;
            }
            bl = false;
        }
        return stringBuilder.toString();
    }
}

