/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modeldiscovery.provider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.api.remote.RemoteFile;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.discovery.api.PkgConfigManager;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.Path;

public class PkgConfigImpl
implements PkgConfigManager.PkgConfig {
    private HashMap<String, PackageConfigurationImpl> configurations = new HashMap();
    private Map<String, List<Pair>> seachBase;
    private String drivePrefix;
    private PlatformInfo pi;

    public PkgConfigImpl(MakeConfiguration makeConfiguration) {
        this.pi = PlatformInfo.localhost();
        this.initPackagesFromSet(null);
    }

    PkgConfigImpl(PlatformInfo platformInfo, CompilerSet compilerSet) {
        this.pi = platformInfo;
        this.initPackagesFromSet(compilerSet);
    }

    private List<String> envPaths(String string) {
        String string2 = System.getenv("PKG_CONFIG_PATH");
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = "";
        arrayList.add(string3 + string);
        if (string2 != null && string2.length() > 0) {
            StringTokenizer stringTokenizer = this.pi.isWindows() ? new StringTokenizer(string2, ";") : new StringTokenizer(string2, ":");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(string3 + stringTokenizer.nextToken());
            }
        }
        return arrayList;
    }

    private void initPackagesFromSet(CompilerSet compilerSet) {
        if (this.pi.isWindows()) {
            String string = this.getPkgConfihPath();
            if (string == null) {
                if (compilerSet == null) {
                    for (CompilerSet compilerSet2 : CompilerSetManager.get((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal()).getCompilerSets()) {
                        if (!compilerSet2.getCompilerFlavor().isCygwinCompiler()) continue;
                        compilerSet = compilerSet2;
                        break;
                    }
                }
                if (compilerSet != null && (string = compilerSet.getDirectory()) != null && string.endsWith("bin")) {
                    this.drivePrefix = string.substring(0, string.length() - 4);
                    string = string.substring(0, string.length() - 3) + "lib/pkgconfig/";
                }
                if (string == null) {
                    this.drivePrefix = "c:/cygwin";
                    string = "c:/cygwin/lib/pkgconfig/";
                }
            } else {
                String string2 = "/lib/pkgconfig/";
                if (string.endsWith(string2)) {
                    this.drivePrefix = string.substring(0, string.length() - string2.length());
                }
            }
            this.initPackages(this.envPaths(string), true);
        } else {
            this.initPackages(this.envPaths("/usr/lib/pkgconfig/"), false);
        }
    }

    private String getPkgConfihPath() {
        for (String string : Path.getPath()) {
            int n;
            File file = new File(string + File.separator + "pkg-config.exe");
            if (!file.exists()) continue;
            if ((string = string.replace('\\', '/')).endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            if ((n = string.lastIndexOf(47)) > 0) {
                string = string.substring(0, n + 1) + "lib/pkgconfig/";
                return string;
            }
            return null;
        }
        return null;
    }

    private void initPackages(List<String> list, boolean bl) {
        HashSet<File> hashSet = new HashSet<File>();
        for (String string : list) {
            File file = RemoteFile.create((ExecutionEnvironment)this.pi.getExecutionEnvironment(), (String)string);
            if (hashSet.contains(file)) continue;
            hashSet.add(file);
            if (!file.exists() || !file.isDirectory() || !file.canRead()) continue;
            for (File file2 : file.listFiles()) {
                String string2 = file2.getName();
                if (!string2.endsWith(".pc") || !file2.canRead() || !file2.isFile()) continue;
                String string3 = string2.substring(0, string2.length() - 3);
                PackageConfigurationImpl packageConfigurationImpl = new PackageConfigurationImpl(string3);
                this.readConfig(file2, packageConfigurationImpl, bl);
                this.configurations.put(string3, packageConfigurationImpl);
            }
        }
    }

    public PkgConfigManager.PackageConfiguration getPkgConfig(String string) {
        return this.getConfig(string);
    }

    public Collection<PkgConfigManager.ResolvedPath> getResolvedPath(String string) {
        Map<String, List<Pair>> map = this.getLibraryItems();
        List<Pair> list = map.get(string);
        if (list != null && list.size() > 0) {
            ArrayList<PkgConfigManager.ResolvedPath> arrayList = new ArrayList<PkgConfigManager.ResolvedPath>(list.size());
            for (Pair pair : list) {
                arrayList.add(new ResolvedPathImpl(pair.path, pair.configurations));
            }
            return arrayList;
        }
        return null;
    }

    void trace() {
        ArrayList<String> arrayList = new ArrayList<String>(this.configurations.keySet());
        Collections.sort(arrayList);
        for (String object : arrayList) {
            this.traceConfig(object, false);
        }
        Map<String, List<Pair>> map = this.getLibraryItems();
        System.out.println("Known includes size: " + map.size());
        arrayList = new ArrayList(map.keySet());
        Collections.sort(arrayList);
        for (String string : arrayList) {
            List list = (List)map.get(string);
            if (list == null) continue;
            for (Pair pair : list) {
                StringBuilder stringBuilder = new StringBuilder();
                for (PkgConfigManager.PackageConfiguration packageConfiguration : pair.configurations) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(packageConfiguration.getName());
                }
                System.out.println(string + "\t" + pair.path + "\t[" + stringBuilder.toString() + "]");
            }
        }
    }

    void traceConfig(String string, boolean bl) {
        this.traceConfig(string, bl, new HashSet<String>(), "");
    }

    private void traceConfig(String string, boolean bl, Set<String> set, String string2) {
        if (set.contains(string)) {
            return;
        }
        set.add(string);
        PackageConfigurationImpl packageConfigurationImpl = this.configurations.get(string);
        if (packageConfigurationImpl != null) {
            System.out.println(string2 + "Package definition");
            System.out.println(string2 + "Name:     " + string);
            System.out.println(string2 + "Requires: " + packageConfigurationImpl.requires);
            System.out.println(string2 + "Macros:   " + packageConfigurationImpl.macros);
            System.out.println(string2 + "Paths:    " + packageConfigurationImpl.paths);
            if (bl) {
                for (String string3 : packageConfigurationImpl.requires) {
                    this.traceConfig(string3, bl, set, string2 + "    ");
                }
            }
        } else {
            System.out.println("Not found package definition " + string);
        }
    }

    void traceRecursiveConfig(String string) {
        PkgConfigManager.PackageConfiguration packageConfiguration = this.getConfig(string);
        if (packageConfiguration != null) {
            System.out.println("Recursive package definition");
            System.out.println("Name:    " + string);
            System.out.println("Package: " + string);
            System.out.println("Macros:  " + packageConfiguration.getMacros());
            System.out.println("Paths:   " + packageConfiguration.getIncludePaths());
        }
    }

    private PkgConfigManager.PackageConfiguration getConfig(String string) {
        PackageConfigurationImpl packageConfigurationImpl = new PackageConfigurationImpl(string);
        this.getConfig(packageConfigurationImpl, this.configurations.get(string));
        return packageConfigurationImpl;
    }

    private void getConfig(PackageConfigurationImpl packageConfigurationImpl, PackageConfigurationImpl packageConfigurationImpl2) {
        if (packageConfigurationImpl2 != null) {
            for (String string : packageConfigurationImpl2.macros) {
                if (packageConfigurationImpl.macros.contains(string)) continue;
                packageConfigurationImpl.macros.add(string);
            }
            for (String string : packageConfigurationImpl2.paths) {
                if (packageConfigurationImpl.paths.contains(string)) continue;
                packageConfigurationImpl.paths.add(string);
            }
            for (String string : packageConfigurationImpl2.requires) {
                this.getConfig(packageConfigurationImpl, this.configurations.get(string));
            }
        }
    }

    private Map<String, List<Pair>> getLibraryItems() {
        Map<String, List<Pair>> map = null;
        if (this.seachBase != null) {
            map = this.seachBase;
        }
        if (map == null) {
            this.seachBase = map = this._getLibraryItems();
        }
        return map;
    }

    private Map<String, List<Pair>> _getLibraryItems() {
        HashMap<String, HashSet<PackageConfigurationImpl>> hashMap = new HashMap<String, HashSet<PackageConfigurationImpl>>();
        for (String object : this.configurations.keySet()) {
            PackageConfigurationImpl packageConfigurationImpl = this.configurations.get(object);
            if (packageConfigurationImpl == null) continue;
            for (String string : packageConfigurationImpl.paths) {
                if (this.drivePrefix == null ? string.equals("/usr/include") || string.equals("/usr/sfw/include") : string.substring(this.drivePrefix.length()).equals("/usr/include") || string.substring(this.drivePrefix.length()).equals("/usr/sfw/include")) continue;
                HashSet<PackageConfigurationImpl> hashSet = (HashSet<PackageConfigurationImpl>)hashMap.get(string);
                if (hashSet == null) {
                    hashSet = new HashSet<PackageConfigurationImpl>();
                    hashMap.put(string, hashSet);
                }
                hashSet.add(packageConfigurationImpl);
            }
        }
        HashMap hashMap2 = new HashMap();
        for (Map.Entry entry : hashMap.entrySet()) {
            Pair pair = new Pair((String)entry.getKey(), (Set)entry.getValue());
            File file = RemoteFile.create((ExecutionEnvironment)this.pi.getExecutionEnvironment(), (String)((String)entry.getKey()));
            this.addLibraryItem(hashMap2, pair, "", file, 0);
        }
        return hashMap2;
    }

    private void addLibraryItem(Map<String, List<Pair>> map, Pair pair, String string, File file, int n) {
        if (n > 2) {
            return;
        }
        if (file.isDirectory() && file.canRead()) {
            for (File file2 : file.listFiles()) {
                if (!file2.canRead()) continue;
                if (file2.isDirectory()) {
                    if (n == 0) {
                        this.addLibraryItem(map, pair, file2.getName(), file2, n + 1);
                        continue;
                    }
                    this.addLibraryItem(map, pair, string + "/" + file2.getName(), file2, n + 1);
                    continue;
                }
                if (!file2.isFile()) continue;
                String string2 = string.length() == 0 ? file2.getName() : string + "/" + file2.getName();
                List<Pair> list = map.get(string2);
                if (list == null) {
                    list = new ArrayList<Pair>(1);
                    map.put(string2, list);
                }
                if (list.contains(pair)) continue;
                list.add(pair);
            }
        }
    }

    private void readConfig(File file, PackageConfigurationImpl packageConfigurationImpl, boolean bl) {
        try {
            String string;
            String string2 = null;
            String string3 = null;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("pcfiledir", file.getParent());
            BufferedReader bufferedReader = new BufferedReader(RemoteFile.createReader((File)file));
            while ((string = bufferedReader.readLine()) != null) {
                String string4;
                Object object;
                if ((string = string.trim()).startsWith("#")) continue;
                if (string.startsWith("Requires:")) {
                    String string5 = string.substring(9).trim();
                    string5 = this.expandMacros(string5, hashMap);
                    object = new StringTokenizer(string5, " ,");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        string4 = ((StringTokenizer)object).nextToken();
                        if (string4.startsWith("<") || string4.startsWith(">") || string4.startsWith("=") || Character.isDigit(string4.charAt(0))) continue;
                        packageConfigurationImpl.requires.add(string4);
                    }
                    continue;
                }
                if (string.startsWith("Requires.private:")) continue;
                if (string.startsWith("Version:")) {
                    packageConfigurationImpl.version = string.substring(8).trim();
                    continue;
                }
                if (string.startsWith("Cflags:")) {
                    String string6 = string.substring(7).trim();
                    string6 = this.expandMacros(string6, hashMap);
                    object = new StringTokenizer(string6, " ");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        string4 = ((StringTokenizer)object).nextToken();
                        if (string4.startsWith("-I")) {
                            string4 = string4.substring(2);
                            if (bl) {
                                if (string4.length() > 2 && string4.charAt(1) == ':') {
                                    if (string2 != null && string4.startsWith(string2)) {
                                        if (string3 != null) {
                                            string4 = string3 + string4.substring(string2.length());
                                        } else if (this.drivePrefix != null) {
                                            string4 = this.drivePrefix + string4.substring(string2.length());
                                        }
                                    }
                                } else {
                                    if (string4.startsWith("/usr/lib/")) {
                                        string4 = string4.substring(4);
                                    }
                                    if (string3 != null) {
                                        string4 = string3 + string4;
                                    } else if (this.drivePrefix != null) {
                                        string4 = this.drivePrefix + string4;
                                    }
                                }
                            }
                            packageConfigurationImpl.paths.add(string4);
                            continue;
                        }
                        if (!string4.startsWith("-D")) continue;
                        packageConfigurationImpl.macros.add(string4.substring(2));
                    }
                    continue;
                }
                if (string.indexOf(61) <= 0) continue;
                int n = string.indexOf(61);
                object = string.substring(0, n).trim();
                string4 = string.substring(n + 1).trim();
                if (bl && ((String)object).equals("prefix")) {
                    string2 = string4;
                    string3 = this.fixPrefixPath(string4, file);
                }
                hashMap.put((String)object, this.expandMacros(string4, hashMap));
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String fixPrefixPath(String string, File file) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\/");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() != 32) continue;
            boolean bl = true;
            block4: for (int i = 0; i < 32; ++i) {
                char c = string2.charAt(i);
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        continue block4;
                    }
                    default: {
                        bl = false;
                    }
                }
            }
            if (!bl) continue;
            if ((file = file.getParentFile()) != null) {
                file = file.getParentFile();
            }
            if (file != null) {
                file = file.getParentFile();
            }
            if (file == null) continue;
            return file.getAbsolutePath();
        }
        if (string.startsWith("/")) {
            int n = string.indexOf(47, 1);
            if ((file = file.getParentFile()) != null) {
                file = file.getParentFile();
            }
            if (file != null) {
                file = file.getParentFile();
            }
            if (file != null) {
                if (n > 0) {
                    return file.getAbsolutePath() + string.substring(n);
                }
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    private String expandMacros(String string, Map<String, String> map) {
        if (string.indexOf("${") >= 0) {
            while (string.indexOf("${") >= 0) {
                String string2;
                String string3;
                int n = string.indexOf("${");
                int n2 = string.indexOf(125);
                if (n2 < n || (string3 = map.get(string2 = string.substring(n + 2, n2))) == null || string3.indexOf("${") >= 0) break;
                string = string.substring(0, n) + string3 + string.substring(n2 + 1);
            }
        }
        return string;
    }

    private static class Pair {
        private String path;
        private Set<PkgConfigManager.PackageConfiguration> configurations;

        private Pair(String string, Set<PkgConfigManager.PackageConfiguration> set) {
            this.path = string;
            this.configurations = set;
        }
    }

    class ResolvedPathImpl
    implements PkgConfigManager.ResolvedPath {
        private String path;
        private Set<PkgConfigManager.PackageConfiguration> packages;

        private ResolvedPathImpl(String string, Set<PkgConfigManager.PackageConfiguration> set) {
            this.path = string;
            this.packages = set;
        }

        public String getIncludePath() {
            return this.path;
        }

        public Collection<PkgConfigManager.PackageConfiguration> getPackages() {
            ArrayList<PkgConfigManager.PackageConfiguration> arrayList = new ArrayList<PkgConfigManager.PackageConfiguration>(this.packages.size());
            for (PkgConfigManager.PackageConfiguration packageConfiguration : this.packages) {
                arrayList.add(PkgConfigImpl.this.getPkgConfig(packageConfiguration.getName()));
            }
            return arrayList;
        }
    }

    static class PackageConfigurationImpl
    implements PkgConfigManager.PackageConfiguration {
        List<String> requires = new ArrayList<String>();
        List<String> macros = new ArrayList<String>();
        List<String> paths = new ArrayList<String>();
        private String name;
        private String version;

        private PackageConfigurationImpl(String string) {
            this.name = string;
        }

        public Collection<String> getIncludePaths() {
            return new ArrayList<String>(this.paths);
        }

        public Collection<String> getMacros() {
            return new ArrayList<String>(this.macros);
        }

        public String getName() {
            return this.name;
        }
    }
}

