/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.screen.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.api.screen.resource.ScreenResourceCategoriesPresenter;
import org.netbeans.modules.vmd.api.screen.resource.ScreenResourceCategoryDescriptor;
import org.netbeans.modules.vmd.api.screen.resource.ScreenResourceItemPresenter;
import org.netbeans.modules.vmd.api.screen.resource.ScreenResourceOrderingController;

public class ResourcePanelSupport {
    static Map<ScreenResourceCategoryDescriptor, ArrayList<ScreenResourceItemPresenter>> getCategoryDescriptors(DesignComponent editedScreen) {
        if (editedScreen == null) {
            return Collections.emptyMap();
        }
        Collection categoriesPresenters = editedScreen.getPresenters(ScreenResourceCategoriesPresenter.class);
        HashMap<ScreenResourceCategoryDescriptor, ArrayList<ScreenResourceItemPresenter>> categories = new HashMap<ScreenResourceCategoryDescriptor, ArrayList<ScreenResourceItemPresenter>>();
        for (ScreenResourceCategoriesPresenter presenter : categoriesPresenters) {
            Collection<ScreenResourceCategoryDescriptor> list = presenter.getCategoryDescriptors();
            if (list == null) continue;
            for (ScreenResourceCategoryDescriptor category : list) {
                categories.put(category, new ArrayList());
            }
        }
        return categories;
    }

    static void resolveResources(DesignDocument document, DesignComponent editedScreen, Map<ScreenResourceCategoryDescriptor, ArrayList<ScreenResourceItemPresenter>> categories) {
        if (editedScreen == null) {
            return;
        }
        Collection resources = DocumentSupport.gatherAllPresentersOfClass((DesignDocument)document, ScreenResourceItemPresenter.class);
        for (ScreenResourceItemPresenter resource : resources) {
            ScreenResourceCategoryDescriptor category;
            ArrayList<ScreenResourceItemPresenter> list;
            if (!resource.isActiveFor(editedScreen) || (list = categories.get(category = resource.getCategoryDescriptor())) == null) continue;
            list.add(resource);
        }
        for (ScreenResourceCategoryDescriptor category : categories.keySet()) {
            for (ScreenResourceOrderingController oc : category.getOrderingControllers()) {
                List<ScreenResourceItemPresenter> orderedList = oc.getOrdered(editedScreen, (Collection<ScreenResourceItemPresenter>)categories.get(category));
                if (orderedList == null) continue;
                categories.get(category).removeAll(orderedList);
                categories.get(category).addAll(orderedList);
            }
        }
    }

    public static List<ScreenResourceCategoryDescriptor> getSortedCategories(Set<ScreenResourceCategoryDescriptor> set) {
        ArrayList<ScreenResourceCategoryDescriptor> list = new ArrayList<ScreenResourceCategoryDescriptor>(set);
        Collections.sort(list, new Comparator<ScreenResourceCategoryDescriptor>(){

            @Override
            public int compare(ScreenResourceCategoryDescriptor o1, ScreenResourceCategoryDescriptor o2) {
                return o1.getOrder() - o2.getOrder();
            }
        });
        return list;
    }
}

