/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.server;

import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.server.ServerRegistry;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstance;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

final class ServerResolver {
    private static final Logger LOGGER = Logger.getLogger(ServerResolver.class.getName());
    private static final Pattern SERVER_ARGUMENT = Pattern.compile("[^#+\\s*]\\s*[^\\S+]ARGV.*\\[0\\]\\s*=\\s*\"(\\S+)\\s*\"");

    ServerResolver() {
    }

    public static RubyInstance getExplicitlySpecifiedServer(RailsProject project) {
        FileObject serverScript = project.getProjectDirectory().getFileObject("script/server");
        if (serverScript == null) {
            return null;
        }
        if (serverScript != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)serverScript);
                EditorCookie editor = (EditorCookie)dobj.getCookie(EditorCookie.class);
                if (editor == null) {
                    return null;
                }
                try {
                    editor.prepareDocument().waitFinished(1500L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                StyledDocument doc = editor.getDocument();
                if (doc == null) {
                    return null;
                }
                String text = doc.getText(0, doc.getLength());
                String serverId = ServerResolver.getSpecifiedServer(text);
                if (serverId != null) {
                    RubyPlatform platform = RubyPlatform.platformFor((Project)project);
                    RubyInstance result = ServerRegistry.getDefault().getServer(serverId.toUpperCase(), platform);
                    if (result == null) {
                        LOGGER.info("Found explicitly set server [" + serverId + "] in server/script, " + "but the server was not found on project's platform [ " + platform + "] or recognized " + "as a known server");
                        return null;
                    }
                    return result;
                }
            }
            catch (BadLocationException ble) {
            }
            catch (DataObjectNotFoundException dnfe) {
                Exceptions.printStackTrace((Throwable)dnfe);
            }
        }
        return null;
    }

    static String getSpecifiedServer(String text) {
        Matcher matcher = SERVER_ARGUMENT.matcher(text);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group(1);
    }
}

