/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import javax.swing.JLabel;
import org.netbeans.modules.web.monitor.client.DataDisplay;
import org.netbeans.modules.web.monitor.client.DisplayTable;
import org.netbeans.modules.web.monitor.data.DataRecord;
import org.netbeans.modules.web.monitor.data.Param;
import org.netbeans.modules.web.monitor.data.SessionData;
import org.openide.util.NbBundle;

public class SessionDisplay
extends DataDisplay {
    private static final boolean debug = false;

    public void setData(DataRecord md) {
        Param[] param;
        String[] data;
        String msg;
        this.removeAll();
        if (md == null) {
            return;
        }
        SessionData sd = md.getSessionData();
        int gridy = -1;
        if (sd == null || "false".equals(sd.getAttributeValue("before")) && "false".equals(sd.getAttributeValue("after"))) {
            this.addGridBagComponent(this, SessionDisplay.createTopSpacer(), 0, ++gridy, 0, 1, 0.0, 0.0, 17, 0, topSpacerInsets, 0, 0);
            this.addGridBagComponent(this, SessionDisplay.createDataLabel(NbBundle.getBundle((Class)SessionDisplay.class).getString("MON_No_session")), 0, ++gridy, 0, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0);
            this.addGridBagComponent(this, SessionDisplay.createGlue(), 0, ++gridy, 1, 1, 1.0, 1.0, 17, 1, zeroInsets, 0, 0);
            return;
        }
        String lastAccessed = null;
        String maxInactiveBefore = null;
        String maxInactiveAfter = null;
        this.addGridBagComponent(this, SessionDisplay.createTopSpacer(), 0, ++gridy, 0, 1, 0.0, 0.0, 17, 0, topSpacerInsets, 0, 0);
        JLabel sessionHeaderLabel = SessionDisplay.createHeaderLabel(NbBundle.getBundle((Class)SessionDisplay.class).getString("MON_Session_24"), NbBundle.getBundle((Class)SessionDisplay.class).getString("ACS_MON_Session_24A11yDesc"), null);
        this.addGridBagComponent(this, sessionHeaderLabel, 0, ++gridy, 0, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0);
        if ("true".equals(sd.getAttributeValue("before"))) {
            msg = NbBundle.getBundle((Class)SessionDisplay.class).getString("MON_Session_existed");
            lastAccessed = sd.getSessionIn().getAttributeValue("lastAccessed");
            maxInactiveBefore = sd.getSessionIn().getAttributeValue("inactiveInterval");
        } else {
            msg = NbBundle.getBundle((Class)SessionDisplay.class).getString("MON_Session_created");
            lastAccessed = sd.getSessionOut().getAttributeValue("lastAccessed");
        }
        JLabel sessionDataLabel = SessionDisplay.createHeaderLabel(msg, msg, null);
        sessionHeaderLabel.setLabelFor(sessionDataLabel);
        this.addGridBagComponent(this, sessionDataLabel, 0, ++gridy, 0, 1, 0.0, 0.0, 17, 0, indentInsets, 0, 0);
        if ("false".equals(sd.getAttributeValue("after"))) {
            msg = NbBundle.getBundle((Class)SessionDisplay.class).getString("MON_Session_invalidated");
            this.addGridBagComponent(this, SessionDisplay.createDataLabel(msg), 0, ++gridy, 0, 1, 0.0, 0.0, 17, 0, indentInsets, 0, 0);
        } else {
            maxInactiveAfter = sd.getSessionOut().getAttributeValue("inactiveInterval");
        }
        boolean inactiveChanged = false;
        if (maxInactiveBefore == null || maxInactiveBefore.equals("")) {
            maxInactiveBefore = maxInactiveAfter != null ? maxInactiveAfter : "";
        } else if (maxInactiveAfter != null && !maxInactiveBefore.equals(maxInactiveAfter)) {
            inactiveChanged = true;
        }
        DisplayTable dt = null;
        if (!inactiveChanged) {
            data = new String[]{sd.getAttributeValue("id"), sd.getAttributeValue("created"), lastAccessed, maxInactiveBefore};
            String[] props = new String[]{NbBundle.getBundle((Class)SessionDisplay.class).getString("MON_Session_ID"), NbBundle.getBundle((Class)SessionDisplay.class).getString("MON_Created"), NbBundle.getBundle((Class)SessionDisplay.class).getString("MON_Last_accessed"), NbBundle.getBundle((Class)SessionDisplay.class).getString("MON_Max_inactive")};
            dt = new DisplayTable(props, data);
        } else {
            data = new String[]{sd.getAttributeValue("id"), sd.getAttributeValue("created"), lastAccessed, maxInactiveBefore, maxInactiveAfter};
            String[] props2 = new String[]{NbBundle.getBundle((Class)SessionDisplay.class).getString("MON_Session_ID"), NbBundle.getBundle((Class)SessionDisplay.class).getString("MON_Created"), NbBundle.getBundle((Class)SessionDisplay.class).getString("MON_Last_accessed"), NbBundle.getBundle((Class)SessionDisplay.class).getString("MON_Max_inactive_before"), NbBundle.getBundle((Class)SessionDisplay.class).getString("MON_Max_inactive_after")};
            dt = new DisplayTable(props2, data);
        }
        JLabel sessionPropertiesLabel = SessionDisplay.createHeaderLabel(NbBundle.getBundle((Class)SessionDisplay.class).getString("MON_Session_properties"), NbBundle.getBundle((Class)SessionDisplay.class).getString("ACS_MON_Session_propertiesA11yDesc"), dt);
        this.addGridBagComponent(this, sessionPropertiesLabel, 0, ++gridy, 0, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0);
        dt.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)SessionDisplay.class).getString("ACS_MON_Session_propertiesTableA11yName"));
        dt.setToolTipText(NbBundle.getBundle((Class)SessionDisplay.class).getString("ACS_MON_Session_propertiesTableA11yDesc"));
        this.addGridBagComponent(this, dt, 0, ++gridy, 0, 1, 1.0, 0.0, 17, 1, tableInsets, 0, 0);
        if ("true".equals(sd.getAttributeValue("before"))) {
            param = null;
            try {
                param = sd.getSessionIn().getParam();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (param == null || param.length == 0) {
                this.addGridBagComponent(this, SessionDisplay.createDataLabel(NbBundle.getBundle((Class)SessionDisplay.class).getString("MON_Session_no_att_before")), 0, ++gridy, 0, 1, 0.0, 0.0, 17, 0, tableInsets, 0, 0);
            } else {
                dt = new DisplayTable(param);
                JLabel sessionBeforeLabel = SessionDisplay.createHeaderLabel(NbBundle.getBundle((Class)SessionDisplay.class).getString("MON_Session_att_before"), NbBundle.getBundle((Class)SessionDisplay.class).getString("ACS_MON_Session_att_beforeA11yDesc"), dt);
                this.addGridBagComponent(this, sessionBeforeLabel, 0, ++gridy, 0, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0);
                dt.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)SessionDisplay.class).getString("ACS_MON_Session_att_beforeTableA11yName"));
                dt.setToolTipText(NbBundle.getBundle((Class)SessionDisplay.class).getString("ACS_MON_Session_att_beforeTableA11yDesc"));
                this.addGridBagComponent(this, dt, 0, ++gridy, 0, 1, 1.0, 0.0, 17, 1, tableInsets, 0, 0);
            }
        }
        if ("true".equals(sd.getAttributeValue("after"))) {
            param = null;
            try {
                param = sd.getSessionOut().getParam();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (param == null || param.length == 0) {
                this.addGridBagComponent(this, SessionDisplay.createDataLabel(NbBundle.getBundle((Class)SessionDisplay.class).getString("MON_Session_no_att_after")), 0, ++gridy, 0, 1, 0.0, 0.0, 17, 0, tableInsets, 0, 0);
            } else {
                dt = new DisplayTable(param);
                JLabel sessionAfterLabel = SessionDisplay.createHeaderLabel(NbBundle.getBundle((Class)SessionDisplay.class).getString("MON_Session_att_after"), NbBundle.getBundle((Class)SessionDisplay.class).getString("ACS_MON_Session_att_afterA11yDesc"), dt);
                this.addGridBagComponent(this, sessionAfterLabel, 0, ++gridy, 0, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0);
                dt.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)SessionDisplay.class).getString("ACS_MON_Session_att_afterTableA11yName"));
                dt.setToolTipText(NbBundle.getBundle((Class)SessionDisplay.class).getString("ACS_MON_Session_att_afterTableA11yDesc"));
                this.addGridBagComponent(this, dt, 0, ++gridy, 0, 1, 1.0, 0.0, 17, 1, tableInsets, 0, 0);
            }
            this.add(SessionDisplay.createRigidArea());
        }
        this.addGridBagComponent(this, SessionDisplay.createGlue(), 0, ++gridy, 1, 1, 1.0, 1.0, 17, 1, zeroInsets, 0, 0);
        this.setMaximumSize(this.getPreferredSize());
        this.repaint();
    }
}

