/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Stamps;
import org.netbeans.Util;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class LocaleVariants
implements Stamps.Updater {
    private static final Logger err = Util.err;
    private static final Map<File, List<FileWithSuffix>> map;
    private static Locale mapLocale;
    private static LocaleVariants UPDATER;
    private static String[] suffixes;
    private static Locale lastLocale;
    private static String lastBranding;

    private LocaleVariants() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushCaches(DataOutputStream os) throws IOException {
        Map<File, List<FileWithSuffix>> map = LocaleVariants.map;
        synchronized (map) {
            os.writeUTF(mapLocale.toString());
            for (Map.Entry<File, List<FileWithSuffix>> entry : LocaleVariants.map.entrySet()) {
                os.writeUTF(entry.getKey().getPath());
                for (FileWithSuffix fws : entry.getValue()) {
                    fws.write(os);
                }
                os.writeUTF("");
            }
            os.writeUTF("");
        }
    }

    @Override
    public void cacheReady() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCaches() {
        Map<File, List<FileWithSuffix>> map = LocaleVariants.map;
        synchronized (map) {
            LocaleVariants.map.clear();
        }
    }

    static List<File> findLocaleVariantsOf(File f) {
        List<FileWithSuffix> result = LocaleVariants.findLocaleVariantsWithSuffixesOf(f);
        ArrayList<File> l = new ArrayList<File>(result.size());
        for (FileWithSuffix fws : result) {
            l.add(fws.file);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<FileWithSuffix> findLocaleVariantsWithSuffixesOf(File f) {
        List<FileWithSuffix> res;
        Map<File, List<FileWithSuffix>> map = LocaleVariants.map;
        synchronized (map) {
            if (mapLocale != Locale.getDefault()) {
                LocaleVariants.map.clear();
                mapLocale = Locale.getDefault();
            }
            if ((res = LocaleVariants.map.get(f)) != null) {
                return res;
            }
        }
        if (!f.isFile()) {
            res = Collections.emptyList();
        } else {
            String ext;
            String name;
            String logicalDir = null;
            String logicalPath = LocaleVariants.findLogicalPath(f);
            if (logicalPath != null) {
                int slash = logicalPath.lastIndexOf(47);
                logicalDir = slash != -1 ? logicalPath.substring(0, slash + 1) + "locale/" : "locale/";
            }
            ArrayList<FileWithSuffix> l = new ArrayList<FileWithSuffix>(7);
            String nameExt = f.getName();
            int idx = nameExt.lastIndexOf(46);
            if (idx != -1) {
                name = nameExt.substring(0, idx);
                ext = nameExt.substring(idx);
            } else {
                name = nameExt;
                ext = "";
            }
            if (logicalDir != null) {
                for (String suffix : LocaleVariants.getLocalizingSuffixesFast()) {
                    String path = logicalDir + name + suffix + ext;
                    File v = InstalledFileLocator.getDefault().locate(path, null, false);
                    if (v == null) continue;
                    l.add(new FileWithSuffix(v, suffix));
                }
            } else {
                File dir = new File(f.getParentFile(), "locale");
                if (dir.exists()) {
                    for (String suffix : LocaleVariants.getLocalizingSuffixesFast()) {
                        File v = new File(dir, name + suffix + ext);
                        if (!v.isFile()) continue;
                        l.add(new FileWithSuffix(v, suffix));
                    }
                }
            }
            res = l;
        }
        map = LocaleVariants.map;
        synchronized (map) {
            LocaleVariants.map.put(f, res);
        }
        if (UPDATER == null) {
            UPDATER = new LocaleVariants();
            Stamps.getModulesJARs().scheduleSave(UPDATER, "localeVariants", false);
        }
        return res;
    }

    static synchronized String[] getLocalizingSuffixesFast() {
        if (suffixes == null || Locale.getDefault() != lastLocale || !Utilities.compareObjects((Object)NbBundle.getBranding(), (Object)lastBranding)) {
            ArrayList _suffixes = new ArrayList();
            Iterator it = NbBundle.getLocalizingSuffixes();
            while (it.hasNext()) {
                _suffixes.add(it.next());
            }
            suffixes = _suffixes.toArray(new String[_suffixes.size()]);
            lastLocale = Locale.getDefault();
            lastBranding = NbBundle.getBranding();
        }
        return suffixes;
    }

    private static String findLogicalPath(File f) {
        InstalledFileLocator l = InstalledFileLocator.getDefault();
        String path = f.getName();
        for (File parent = f.getParentFile(); parent != null; parent = parent.getParentFile()) {
            File probe = l.locate(path, null, false);
            if (f.equals(probe)) {
                return path;
            }
            path = parent.getName() + '/' + path;
        }
        return null;
    }

    static {
        InputStream stream = Stamps.getModulesJARs().asStream("localeVariants");
        HashMap<File, List<FileWithSuffix>> tmp = new HashMap<File, List<FileWithSuffix>>();
        if (stream != null) {
            try {
                String file;
                DataInputStream is = new DataInputStream(stream);
                String locale = is.readUTF();
                Locale locale2 = mapLocale = Locale.getDefault().toString().equals(locale) ? Locale.getDefault() : null;
                while ((file = is.readUTF()).length() != 0) {
                    FileWithSuffix fws;
                    ArrayList<FileWithSuffix> arr = new ArrayList<FileWithSuffix>();
                    while ((fws = FileWithSuffix.read(is)) != null) {
                        arr.add(fws);
                    }
                    tmp.put(new File(file), arr);
                }
                is.close();
            }
            catch (IOException ex) {
                err.log(Level.WARNING, "Cannot read localeVariants cache", ex);
                tmp.clear();
            }
        }
        map = tmp;
        suffixes = null;
        lastLocale = null;
        lastBranding = null;
    }

    static final class FileWithSuffix {
        public final File file;
        public final String suffix;

        FileWithSuffix(File file, String suffix) {
            this.file = file;
            this.suffix = suffix;
        }

        static FileWithSuffix read(DataInputStream is) throws IOException {
            String path = is.readUTF();
            if (path.length() == 0) {
                return null;
            }
            String suffix = is.readUTF();
            return new FileWithSuffix(new File(path), suffix);
        }

        void write(DataOutputStream os) throws IOException {
            os.writeUTF(this.file.getPath());
            os.writeUTF(this.suffix);
        }
    }
}

