/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JToolBar;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.providers.IOSupport;
import org.netbeans.modules.vmd.game.GameController;
import org.netbeans.modules.vmd.game.dialog.NewSceneDialog;
import org.netbeans.modules.vmd.game.dialog.NewSimpleTiledLayerDialog;
import org.netbeans.modules.vmd.game.model.Editable;
import org.netbeans.modules.vmd.game.model.EditorManagerListener;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.adapter.GlobalRepositoryComboBoxModel;
import org.netbeans.modules.vmd.game.nbdialog.SpriteDialog;
import org.netbeans.modules.vmd.game.nbdialog.TiledLayerDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.UndoRedo;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class GameEditorView
implements DataEditorView,
EditorManagerListener {
    private static final long serialVersionUID = 3317521472849153199L;
    public static final transient boolean DEBUG = false;
    private DataObjectContext context;
    private transient GameController controller;
    private transient GlobalRepository gameDesign;
    private transient JComponent toolBarRepresentation;
    private transient JComboBox comboGlobal;
    private transient boolean firstTime = false;

    public GameEditorView(DataObjectContext dataObjectContext) {
        this.context = dataObjectContext;
        this.init();
    }

    private void init() {
        this.controller = new GameController(this.context, this);
        if (this.controller.getGameDesign() != null) {
            this.controller.getGameDesign().getMainView().addEditorManagerListener(this);
        }
    }

    public void setGameDesign(GlobalRepository globalRepository) {
        if (this.gameDesign == globalRepository) {
            return;
        }
        if (this.gameDesign != null) {
            this.gameDesign.getMainView().removeEditorManagerListener(this);
        }
        this.gameDesign = globalRepository;
        if (this.gameDesign != null) {
            if (this.comboGlobal == null) {
                this.comboGlobal = new JComboBox();
            }
            GlobalRepositoryComboBoxModel globalRepositoryComboBoxModel = new GlobalRepositoryComboBoxModel();
            globalRepositoryComboBoxModel.setGameDesign(globalRepository);
            this.comboGlobal.setModel(globalRepositoryComboBoxModel);
        }
    }

    public DataObjectContext getContext() {
        return this.context;
    }

    public DataEditorView.Kind getKind() {
        return DataEditorView.Kind.MODEL;
    }

    public boolean canShowSideWindows() {
        return false;
    }

    public Collection<String> getTags() {
        return Collections.singleton("DO_NOT_OPEN_PROPERTIES_WINDOW");
    }

    public String preferredID() {
        return "vmd-midp-game";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(GameEditorView.class, (String)"GameEditorView.DisplayName");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(GameEditorView.class);
    }

    public JComponent getVisualRepresentation() {
        return this.controller.getVisualRepresentation();
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolBarRepresentation == null) {
            JToolBar jToolBar = new JToolBar();
            jToolBar.setFloatable(false);
            jToolBar.setRollover(true);
            jToolBar.addSeparator();
            if (this.comboGlobal == null) {
                this.comboGlobal = new JComboBox();
            }
            this.comboGlobal.setMaximumRowCount(16);
            this.comboGlobal.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    DefaultListCellRenderer defaultListCellRenderer = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    if (object instanceof GlobalRepository) {
                        defaultListCellRenderer.setFont(defaultListCellRenderer.getFont().deriveFont(1));
                    } else if (object instanceof String) {
                        defaultListCellRenderer.setFont(defaultListCellRenderer.getFont().deriveFont(1));
                        defaultListCellRenderer.setText("  " + defaultListCellRenderer.getText());
                    } else {
                        defaultListCellRenderer.setText("    " + defaultListCellRenderer.getText());
                    }
                    return defaultListCellRenderer;
                }
            });
            this.comboGlobal.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object = GameEditorView.this.comboGlobal.getSelectedItem();
                    if (GameEditorView.this.gameDesign == null) {
                        return;
                    }
                    if (object instanceof Editable) {
                        GameEditorView.this.gameDesign.getMainView().requestEditing((Editable)object);
                    } else if (object instanceof String) {
                        GameEditorView.this.gameDesign.getMainView().requestEditing(GameEditorView.this.gameDesign);
                    }
                }
            });
            if (this.gameDesign != null) {
                this.comboGlobal.setSelectedItem(this.gameDesign.getMainView().getCurrentEditable());
            }
            jToolBar.add(this.comboGlobal);
            jToolBar.addSeparator();
            JButton jButton = new JButton(new ImageIcon(this.getClass().getResource("res/new_scene_16.png")));
            jButton.setToolTipText(NbBundle.getMessage(GameEditorView.class, (String)"GameEditorView.buttonCreateScene.tooltip"));
            jButton.setBorderPainted(false);
            jButton.setRolloverEnabled(true);
            jButton.setSize(14, 14);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NewSceneDialog newSceneDialog = new NewSceneDialog(GameEditorView.this.gameDesign);
                    DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)newSceneDialog, NbBundle.getMessage(NewSceneDialog.class, (String)"NewSceneDialog.title.text"));
                    dialogDescriptor.setButtonListener((ActionListener)newSceneDialog);
                    dialogDescriptor.setValid(false);
                    newSceneDialog.setDialogDescriptor(dialogDescriptor);
                    Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                    dialog.setVisible(true);
                }
            });
            JButton jButton2 = new JButton(new ImageIcon(this.getClass().getResource("res/new_tiled_layer_16.png")));
            jButton2.setToolTipText(NbBundle.getMessage(GameEditorView.class, (String)"GameEditorView.buttonCreateTiledLayer.tooltip"));
            jButton2.setBorderPainted(false);
            jButton2.setRolloverEnabled(true);
            jButton2.setSize(14, 14);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TiledLayerDialog tiledLayerDialog = new TiledLayerDialog(GameEditorView.this.gameDesign);
                    DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)tiledLayerDialog, NbBundle.getMessage(NewSimpleTiledLayerDialog.class, (String)"NewSimpleTiledLayerDialog.title.text"));
                    dialogDescriptor.setButtonListener((ActionListener)tiledLayerDialog);
                    dialogDescriptor.setValid(false);
                    tiledLayerDialog.setDialogDescriptor(dialogDescriptor);
                    Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                    dialog.setVisible(true);
                }
            });
            JButton jButton3 = new JButton(new ImageIcon(this.getClass().getResource("res/new_sprite_16.png")));
            jButton3.setToolTipText(NbBundle.getMessage(GameEditorView.class, (String)"GameEditorView.buttonCreateSprite.tooltip"));
            jButton3.setBorderPainted(false);
            jButton3.setRolloverEnabled(true);
            jButton3.setSize(14, 14);
            jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SpriteDialog spriteDialog = new SpriteDialog(GameEditorView.this.gameDesign);
                    DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)spriteDialog, NbBundle.getMessage(GameEditorView.class, (String)"GameEditorView.buttonCreateSprite.txt"));
                    dialogDescriptor.setButtonListener((ActionListener)spriteDialog);
                    dialogDescriptor.setValid(false);
                    spriteDialog.setDialogDescriptor(dialogDescriptor);
                    Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                    dialog.setVisible(true);
                }
            });
            jToolBar.add(jButton);
            jToolBar.add(jButton2);
            jToolBar.add(jButton3);
            this.toolBarRepresentation = jToolBar;
        }
        return this.toolBarRepresentation;
    }

    public UndoRedo getUndoRedo() {
        if (this.firstTime) {
            IOSupport.getDocumentSerializer((DataObject)this.context.getDataObject()).getUndoRedoManager().setLimit(100);
        }
        return null;
    }

    public void discardAllEdits() {
        IOSupport.getDocumentSerializer((DataObject)this.context.getDataObject()).getUndoRedoManager().discardAllEdits();
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public void componentShowing() {
    }

    public void componentHidden() {
    }

    public void componentActivated() {
    }

    public void componentDeactivated() {
    }

    public int getOpenPriority() {
        return this.getOrder();
    }

    public int getEditPriority() {
        return -this.getOrder();
    }

    public int getOrder() {
        return 500;
    }

    @Override
    public void editing(Editable editable) {
        if (this.comboGlobal != null) {
            this.comboGlobal.setSelectedItem(editable);
            this.comboGlobal.repaint();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.context);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object = objectInputStream.readObject();
        if (!(object instanceof DataObjectContext)) {
            throw new ClassNotFoundException("DataObjectContext expected but not found");
        }
        this.context = (DataObjectContext)object;
        this.init();
    }
}

