/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing.errors;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.masterfs.providers.AnnotationProvider;
import org.netbeans.modules.masterfs.providers.InterceptionListener;
import org.netbeans.modules.parsing.impl.indexing.errors.Settings;
import org.netbeans.modules.parsing.impl.indexing.errors.TaskCache;
import org.netbeans.modules.parsing.impl.indexing.errors.Utilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ErrorAnnotator
extends AnnotationProvider {
    private static final Logger LOG = Logger.getLogger(ErrorAnnotator.class.getName());
    private static final String ERROR_BADGE_URL = "org/netbeans/modules/parsing/impl/resources/error-badge.gif";
    private static final Image ERROR_BADGE_SINGLE;
    private static final Image ERROR_BADGE_FOLDER;
    private static final int IN_ERROR_REC = 1;
    private static final int IN_ERROR_NONREC = 2;
    private static final int INVALID = 4;
    private Map<FileObject, Integer> knownFiles2Error = new WeakHashMap<FileObject, Integer>();
    private long cumulativeTime;
    private Collection<FileObject> toProcess = null;
    private final RequestProcessor.Task WORKER = new RequestProcessor("ErrorAnnotator worker", 1).create(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Collection toProcess;
            long startTime = System.currentTimeMillis();
            ErrorAnnotator errorAnnotator = ErrorAnnotator.this;
            synchronized (errorAnnotator) {
                toProcess = ErrorAnnotator.this.toProcess;
                ErrorAnnotator.this.toProcess = null;
            }
            for (FileObject f : toProcess) {
                boolean stateChanged;
                ErrorAnnotator errorAnnotator2 = ErrorAnnotator.this;
                synchronized (errorAnnotator2) {
                    Integer currentState = (Integer)ErrorAnnotator.this.knownFiles2Error.get(f);
                    if (currentState != null && (currentState & 4) == 0) {
                        continue;
                    }
                }
                boolean recError = false;
                boolean nonRecError = false;
                if (f.isData()) {
                    recError = nonRecError = TaskCache.getDefault().isInError(f, true);
                } else {
                    ClassPath source = ClassPath.getClassPath((FileObject)f, (String)"classpath/source");
                    if (source == null) {
                        Project p = FileOwnerQuery.getOwner((FileObject)f);
                        if (p != null) {
                            for (FileObject fileObject : Utilities.findIndexedRootsUnderDirectory(p, f)) {
                                recError |= TaskCache.getDefault().isInError(fileObject, true);
                            }
                        }
                    } else {
                        recError = TaskCache.getDefault().isInError(f, true);
                        nonRecError = TaskCache.getDefault().isInError(f, false);
                    }
                }
                Integer value = (recError ? 1 : 0) | (nonRecError ? 2 : 0);
                ErrorAnnotator errorAnnotator3 = ErrorAnnotator.this;
                synchronized (errorAnnotator3) {
                    Integer n = (Integer)ErrorAnnotator.this.knownFiles2Error.get(f);
                    int orig = n != null ? n & 0xFFFFFFFB : 0;
                    stateChanged = orig != value;
                    ErrorAnnotator.this.knownFiles2Error.put(f, value);
                }
                if (!stateChanged) continue;
                ErrorAnnotator.this.fireFileStatusChanged(Collections.singleton(f));
            }
            long endTime = System.currentTimeMillis();
            Logger.getLogger(ErrorAnnotator.class.getName()).log(Level.FINE, "time spent in error annotations computation: {0}, cumulative time: {1}", new Object[]{endTime - startTime, ErrorAnnotator.this.cumulativeTime += endTime - startTime});
        }
    });

    public String annotateName(String name, Set files) {
        return null;
    }

    public Image annotateIcon(Image icon, int iconType, Set<? extends FileObject> files) {
        boolean singleFile;
        if (!Settings.isBadgesEnabled()) {
            return null;
        }
        boolean inError = false;
        boolean bl = singleFile = files.size() == 1;
        if (files instanceof NonRecursiveFolder) {
            FileObject folder = ((NonRecursiveFolder)files).getFolder();
            inError = this.isInError(folder, false, true);
            singleFile = false;
        } else {
            for (FileObject fileObject : files) {
                if (!(fileObject instanceof FileObject)) continue;
                FileObject f = fileObject;
                if (f.isFolder()) {
                    singleFile = false;
                    if (this.isInError(f, true, !inError)) {
                        inError = true;
                        continue;
                    }
                    if (!inError) continue;
                    continue;
                }
                if (!f.isData() || !this.isInError(f, true, !inError)) continue;
                inError = true;
            }
        }
        Logger.getLogger(ErrorAnnotator.class.getName()).log(Level.FINE, "files={0}, in error={1}", new Object[]{files, inError});
        if (inError) {
            Image i = ImageUtilities.mergeImages((Image)icon, (Image)(singleFile ? ERROR_BADGE_SINGLE : ERROR_BADGE_FOLDER), (int)0, (int)8);
            Iterator iterator = Lookup.getDefault().lookupAll(AnnotationProvider.class).iterator();
            boolean found = false;
            while (iterator.hasNext()) {
                AnnotationProvider p = (AnnotationProvider)iterator.next();
                if (found) {
                    Image res = p.annotateIcon(i, iconType, files);
                    if (res == null) continue;
                    return res;
                }
                found = p == this;
            }
            return i;
        }
        return null;
    }

    public String annotateNameHtml(String name, Set files) {
        return null;
    }

    public Action[] actions(Set files) {
        return null;
    }

    public InterceptionListener getInterceptionListener() {
        return null;
    }

    public void updateAllInError() {
        try {
            File[] roots;
            for (File root : roots = File.listRoots()) {
                FileObject rootFO = FileUtil.toFileObject((File)root);
                if (rootFO == null) continue;
                this.fireFileStatusChanged(new FileStatusEvent(rootFO.getFileSystem(), true, false));
            }
        }
        catch (FileStateInvalidException ex) {
            LOG.log(Level.INFO, ex.getMessage(), ex);
        }
    }

    public synchronized void updateInError(Set<URL> urls) {
        HashSet<FileObject> toRefresh = new HashSet<FileObject>();
        for (FileObject f : this.knownFiles2Error.keySet()) {
            try {
                if (!urls.contains(f.getURL())) continue;
                toRefresh.add(f);
                Integer i = this.knownFiles2Error.get(f);
                if (i == null) continue;
                this.knownFiles2Error.put(f, i | 4);
                this.enqueue(f);
            }
            catch (IOException e) {
                LOG.log(Level.INFO, e.getMessage(), e);
            }
        }
    }

    public void fireFileStatusChanged(Set<FileObject> fos) {
        if (fos.isEmpty()) {
            return;
        }
        try {
            this.fireFileStatusChanged(new FileStatusEvent(fos.iterator().next().getFileSystem(), fos, true, false));
        }
        catch (FileStateInvalidException ex) {
            LOG.log(Level.INFO, ex.getMessage(), ex);
        }
    }

    public static ErrorAnnotator getAnnotator() {
        for (AnnotationProvider ap : Lookup.getDefault().lookupAll(AnnotationProvider.class)) {
            if (ap.getClass() != ErrorAnnotator.class) continue;
            return (ErrorAnnotator)ap;
        }
        return null;
    }

    private void enqueue(FileObject file) {
        if (this.toProcess == null) {
            this.toProcess = new LinkedList<FileObject>();
            this.WORKER.schedule(50);
        }
        this.toProcess.add(file);
    }

    private synchronized boolean isInError(FileObject file, boolean recursive, boolean forceValue) {
        boolean result = false;
        Integer i = this.knownFiles2Error.get(file);
        if (i != null) {
            boolean bl = result = (i & (recursive ? 1 : 2)) != 0;
            if ((i & 4) == 0) {
                return result;
            }
        }
        if (!forceValue) {
            if (i == null) {
                this.knownFiles2Error.put(file, null);
            }
            return result;
        }
        this.enqueue(file);
        return result;
    }

    static {
        URL errorBadgeIconURL = ErrorAnnotator.class.getClassLoader().getResource(ERROR_BADGE_URL);
        assert (errorBadgeIconURL != null) : "Note in bug #166236";
        String errorBadgeSingleTP = "<img src=\"" + errorBadgeIconURL + "\">&nbsp;" + NbBundle.getMessage(ErrorAnnotator.class, (String)"TP_ErrorBadgeSingle");
        Image errorBadge = ImageUtilities.loadImage((String)ERROR_BADGE_URL);
        assert (errorBadge != null) : "Note in bug #166236";
        ERROR_BADGE_SINGLE = ImageUtilities.assignToolTipToImage((Image)errorBadge, (String)errorBadgeSingleTP);
        String errorBadgeFolderTP = "<img src=\"" + errorBadgeIconURL + "\">&nbsp;" + NbBundle.getMessage(ErrorAnnotator.class, (String)"TP_ErrorBadgeFolder");
        ERROR_BADGE_FOLDER = ImageUtilities.assignToolTipToImage((Image)errorBadge, (String)errorBadgeFolderTP);
    }
}

